/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.assembly;

import com.copycatsplus.copycats.foundation.copycat.model.assembly.AssemblyTransform;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Contract;

public record Mutation(MutationType type, int value) {
    public <T extends AssemblyTransform.Transformable<T>> T mutate(T vec3) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case MutationType.ROTATE_X -> vec3.rotateX(this.value);
            case MutationType.ROTATE_Y -> vec3.rotateY(this.value);
            case MutationType.ROTATE_Z -> vec3.rotateZ(this.value);
            case MutationType.MIRROR -> this.value == 0 ? vec3.flipX(true) : (this.value == 1 ? vec3.flipY(true) : (this.value == 2 ? vec3.flipZ(true) : vec3));
        };
    }

    @Nullable
    @Contract(value="null -> null")
    public class_2350 mutate(@Nullable class_2350 dir) {
        if (dir == null) {
            return null;
        }
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case MutationType.ROTATE_X -> Mutation.rotateX(dir, this.value);
            case MutationType.ROTATE_Y -> Mutation.rotateY(dir, this.value);
            case MutationType.ROTATE_Z -> Mutation.rotateZ(dir, this.value);
            case MutationType.MIRROR -> this.value == 0 && dir.method_10166() == class_2350.class_2351.field_11048 ? dir.method_10153() : (this.value == 1 && dir.method_10166() == class_2350.class_2351.field_11052 ? dir.method_10153() : (this.value == 2 && dir.method_10166() == class_2350.class_2351.field_11051 ? dir.method_10153() : dir));
        };
    }

    public <T extends AssemblyTransform.Transformable<T>> T undoMutate(T vec3) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case MutationType.ROTATE_X -> vec3.rotateX(-this.value);
            case MutationType.ROTATE_Y -> vec3.rotateY(-this.value);
            case MutationType.ROTATE_Z -> vec3.rotateZ(-this.value);
            case MutationType.MIRROR -> this.value == 0 ? vec3.flipX(true) : (this.value == 1 ? vec3.flipY(true) : (this.value == 2 ? vec3.flipZ(true) : vec3));
        };
    }

    @Nullable
    @Contract(value="null -> null")
    public class_2350 undoMutate(@Nullable class_2350 dir) {
        if (dir == null) {
            return null;
        }
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case MutationType.ROTATE_X -> Mutation.rotateX(dir, -this.value);
            case MutationType.ROTATE_Y -> Mutation.rotateY(dir, -this.value);
            case MutationType.ROTATE_Z -> Mutation.rotateZ(dir, -this.value);
            case MutationType.MIRROR -> this.value == 0 && dir.method_10166() == class_2350.class_2351.field_11048 ? dir.method_10153() : (this.value == 1 && dir.method_10166() == class_2350.class_2351.field_11052 ? dir.method_10153() : (this.value == 2 && dir.method_10166() == class_2350.class_2351.field_11051 ? dir.method_10153() : dir));
        };
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static class_2350 rotateX(@Nullable class_2350 dir, int angle) {
        if (dir == null) {
            return null;
        }
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return switch (angle) {
            case 90 -> {
                switch (dir) {
                    case field_11043: {
                        yield class_2350.field_11033;
                    }
                    case field_11035: {
                        yield class_2350.field_11036;
                    }
                    case field_11036: {
                        yield class_2350.field_11043;
                    }
                    case field_11033: {
                        yield class_2350.field_11035;
                    }
                }
                yield dir;
            }
            case 180 -> {
                switch (dir) {
                    case field_11043: {
                        yield class_2350.field_11035;
                    }
                    case field_11035: {
                        yield class_2350.field_11043;
                    }
                    case field_11036: {
                        yield class_2350.field_11033;
                    }
                    case field_11033: {
                        yield class_2350.field_11036;
                    }
                }
                yield dir;
            }
            case 270 -> {
                switch (dir) {
                    case field_11043: {
                        yield class_2350.field_11036;
                    }
                    case field_11035: {
                        yield class_2350.field_11033;
                    }
                    case field_11036: {
                        yield class_2350.field_11035;
                    }
                    case field_11033: {
                        yield class_2350.field_11043;
                    }
                }
                yield dir;
            }
            default -> dir;
        };
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static class_2350 rotateY(@Nullable class_2350 dir, int angle) {
        if (dir == null) {
            return null;
        }
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return switch (angle) {
            case 90 -> {
                switch (dir) {
                    case field_11043: {
                        yield class_2350.field_11034;
                    }
                    case field_11035: {
                        yield class_2350.field_11039;
                    }
                    case field_11034: {
                        yield class_2350.field_11035;
                    }
                    case field_11039: {
                        yield class_2350.field_11043;
                    }
                }
                yield dir;
            }
            case 180 -> {
                switch (dir) {
                    case field_11043: {
                        yield class_2350.field_11035;
                    }
                    case field_11035: {
                        yield class_2350.field_11043;
                    }
                    case field_11034: {
                        yield class_2350.field_11039;
                    }
                    case field_11039: {
                        yield class_2350.field_11034;
                    }
                }
                yield dir;
            }
            case 270 -> {
                switch (dir) {
                    case field_11043: {
                        yield class_2350.field_11039;
                    }
                    case field_11035: {
                        yield class_2350.field_11034;
                    }
                    case field_11034: {
                        yield class_2350.field_11043;
                    }
                    case field_11039: {
                        yield class_2350.field_11035;
                    }
                }
                yield dir;
            }
            default -> dir;
        };
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static class_2350 rotateZ(@Nullable class_2350 dir, int angle) {
        if (dir == null) {
            return null;
        }
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return switch (angle) {
            case 90 -> {
                switch (dir) {
                    case field_11036: {
                        yield class_2350.field_11034;
                    }
                    case field_11033: {
                        yield class_2350.field_11039;
                    }
                    case field_11034: {
                        yield class_2350.field_11033;
                    }
                    case field_11039: {
                        yield class_2350.field_11036;
                    }
                }
                yield dir;
            }
            case 180 -> {
                switch (dir) {
                    case field_11036: {
                        yield class_2350.field_11033;
                    }
                    case field_11033: {
                        yield class_2350.field_11036;
                    }
                    case field_11034: {
                        yield class_2350.field_11039;
                    }
                    case field_11039: {
                        yield class_2350.field_11034;
                    }
                }
                yield dir;
            }
            case 270 -> {
                switch (dir) {
                    case field_11036: {
                        yield class_2350.field_11039;
                    }
                    case field_11033: {
                        yield class_2350.field_11034;
                    }
                    case field_11034: {
                        yield class_2350.field_11036;
                    }
                    case field_11039: {
                        yield class_2350.field_11033;
                    }
                }
                yield dir;
            }
            default -> dir;
        };
    }

    public static enum MutationType {
        ROTATE_X,
        ROTATE_Y,
        ROTATE_Z,
        MIRROR;

    }
}

