/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.particle.AirParticleData;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.class_1275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class BacktankBlockEntity
extends KineticBlockEntity
implements class_1275 {
    public int airLevel;
    public int airLevelTimer;
    private class_2561 defaultName;
    private class_2561 customName;
    private int capacityEnchantLevel;
    private class_2499 enchantmentTag;

    public BacktankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.defaultName = BacktankBlockEntity.getDefaultName(state);
        this.enchantmentTag = new class_2499();
    }

    public static class_2561 getDefaultName(class_2680 state) {
        if (AllBlocks.NETHERITE_BACKTANK.has(state)) {
            ((BacktankItem)AllItems.NETHERITE_BACKTANK.get()).method_7848();
        }
        return ((BacktankItem)AllItems.COPPER_BACKTANK.get()).method_7848();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.BACKTANK);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this.getSpeed() != 0.0f) {
            this.award(AllAdvancements.BACKTANK);
        }
    }

    @Override
    public void tick() {
        class_2746 waterProperty;
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)(waterProperty = class_2741.field_12508)) && ((Boolean)state.method_11654((class_2769)waterProperty)).booleanValue()) {
            return;
        }
        if (this.airLevelTimer > 0) {
            --this.airLevelTimer;
            return;
        }
        int max = BacktankUtil.maxAir(this.capacityEnchantLevel);
        if (this.field_11863.field_9236) {
            class_243 centerOf = VecHelper.getCenterOf((class_2382)this.field_11867);
            class_243 v = VecHelper.offsetRandomly(centerOf, this.field_11863.field_9229, 0.65f);
            class_243 m = centerOf.method_1020(v);
            if (this.airLevel != max) {
                this.field_11863.method_8406((class_2394)new AirParticleData(1.0f, 0.05f), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
            }
            return;
        }
        if (this.airLevel == max) {
            return;
        }
        int prevComparatorLevel = this.getComparatorOutput();
        float abs = Math.abs(this.getSpeed());
        int increment = class_3532.method_15340((int)(((int)abs - 100) / 20), (int)1, (int)5);
        this.airLevel = Math.min(max, this.airLevel + increment);
        if (this.getComparatorOutput() != prevComparatorLevel && !this.field_11863.field_9236) {
            this.field_11863.method_8455(this.field_11867, state.method_26204());
        }
        if (this.airLevel == max) {
            this.sendData();
        }
        this.airLevelTimer = class_3532.method_15340((int)((int)(128.0f - abs / 5.0f) - 108), (int)0, (int)20);
    }

    public int getComparatorOutput() {
        int max = BacktankUtil.maxAir(this.capacityEnchantLevel);
        return ComparatorUtil.fractionToRedstoneLevel((float)this.airLevel / (float)max);
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("Air", this.airLevel);
        compound.method_10569("Timer", this.airLevelTimer);
        compound.method_10569("CapacityEnchantment", this.capacityEnchantLevel);
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        compound.method_10566("Enchantments", (class_2520)this.enchantmentTag);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        int prev = this.airLevel;
        this.capacityEnchantLevel = compound.method_10550("CapacityEnchantment");
        this.airLevel = compound.method_10550("Air");
        this.airLevelTimer = compound.method_10550("Timer");
        this.enchantmentTag = compound.method_10554("Enchantments", 10);
        if (compound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"));
        }
        if (prev != 0 && prev != this.airLevel && this.airLevel == BacktankUtil.maxAir(this.capacityEnchantLevel) && clientPacket) {
            this.playFilledEffect();
        }
    }

    protected void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(this.field_11863, (class_2382)this.field_11867, 0.4f, 1.0f, true);
        class_243 baseMotion = new class_243(0.25, 0.1, 0.0);
        class_243 baseVec = VecHelper.getCenterOf((class_2382)this.field_11867);
        for (int i = 0; i < 360; i += 10) {
            class_243 m = VecHelper.rotate(baseMotion, i, class_2350.class_2351.field_11052);
            class_243 v = baseVec.method_1019(m.method_1029().method_1021(0.25));
            this.field_11863.method_8406((class_2394)class_2398.field_11228, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.defaultName;
    }

    public int getAirLevel() {
        return this.airLevel;
    }

    public void setAirLevel(int airLevel) {
        this.airLevel = airLevel;
        this.sendData();
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2499 getEnchantmentTag() {
        return this.enchantmentTag;
    }

    public void setEnchantmentTag(class_2499 enchantmentTag) {
        this.enchantmentTag = enchantmentTag;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
    }
}

