/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Lists;
import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.config.ui.CConfigureConfigPacket;
import com.simibubi.create.foundation.config.ui.ConfigAnnotations;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigScreenList;
import com.simibubi.create.foundation.config.ui.ConfigTextField;
import com.simibubi.create.foundation.config.ui.HintableTextFieldWidget;
import com.simibubi.create.foundation.config.ui.entries.BooleanEntry;
import com.simibubi.create.foundation.config.ui.entries.EnumEntry;
import com.simibubi.create.foundation.config.ui.entries.NumberEntry;
import com.simibubi.create.foundation.config.ui.entries.SubMenuEntry;
import com.simibubi.create.foundation.config.ui.entries.ValueEntry;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ConfirmationScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.AbstractSelectionListAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SubMenuConfigScreen
extends ConfigScreen {
    public final ModConfig.Type type;
    protected ForgeConfigSpec spec;
    protected UnmodifiableConfig configGroup;
    protected ConfigScreenList list;
    protected BoxWidget resetAll;
    protected BoxWidget saveChanges;
    protected BoxWidget discardChanges;
    protected BoxWidget goBack;
    protected BoxWidget serverLocked;
    protected HintableTextFieldWidget search;
    protected int listWidth;
    protected String title;
    protected Set<String> highlights = new HashSet<String>();

    public static SubMenuConfigScreen find(ConfigHelper.ConfigPath path) {
        ForgeConfigSpec spec = ConfigHelper.findForgeConfigSpecFor(path.getType(), path.getModID());
        UnmodifiableConfig values = spec.getValues();
        BaseConfigScreen base = new BaseConfigScreen(null, path.getModID());
        SubMenuConfigScreen screen = new SubMenuConfigScreen(base, "root", path.getType(), spec, values);
        ArrayList remainingPath = Lists.newArrayList((Object[])path.getPath());
        block0: while (!remainingPath.isEmpty()) {
            String next = (String)remainingPath.remove(0);
            for (Map.Entry entry : values.valueMap().entrySet()) {
                String key = (String)entry.getKey();
                Object obj = entry.getValue();
                if (!key.equalsIgnoreCase(next)) continue;
                if (!(obj instanceof AbstractConfig)) {
                    screen.highlights.add(path.getPath()[path.getPath().length - 1]);
                    continue;
                }
                values = (UnmodifiableConfig)obj;
                screen = new SubMenuConfigScreen(screen, SubMenuConfigScreen.toHumanReadable(key), path.getType(), spec, values);
                continue block0;
            }
        }
        ConfigScreen.modID = path.getModID();
        return screen;
    }

    public SubMenuConfigScreen(class_437 parent, String title, ModConfig.Type type, ForgeConfigSpec configSpec, UnmodifiableConfig configGroup) {
        super(parent);
        this.type = type;
        this.spec = configSpec;
        this.title = title;
        this.configGroup = configGroup;
    }

    public SubMenuConfigScreen(class_437 parent, ModConfig.Type type, ForgeConfigSpec configSpec) {
        super(parent);
        this.type = type;
        this.spec = configSpec;
        this.title = "root";
        this.configGroup = configSpec.getValues();
    }

    protected void clearChanges() {
        ConfigHelper.changes.clear();
        this.list.method_25396().stream().filter(e -> e instanceof ValueEntry).forEach(e -> ((ValueEntry)e).onValueChange());
    }

    protected void saveChanges() {
        UnmodifiableConfig values = this.spec.getValues();
        ConfigHelper.changes.forEach((path, change) -> {
            ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)values.get(path);
            configValue.set(change.value);
            if (this.type == ModConfig.Type.SERVER) {
                AllPackets.getChannel().sendToServer(new CConfigureConfigPacket<Object>(ConfigScreen.modID, (String)path, change.value));
            }
            String command = change.annotations.get("Execute");
            if (this.field_22787.field_1724 != null && command != null && command.startsWith("/")) {
                this.field_22787.field_1724.field_3944.method_45730(command.substring(1));
            }
        });
        this.clearChanges();
    }

    protected void resetConfig(UnmodifiableConfig values) {
        values.valueMap().forEach((key, obj) -> {
            if (obj instanceof AbstractConfig) {
                this.resetConfig((UnmodifiableConfig)obj);
            } else if (obj instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)obj;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath());
                ArrayList<String> comments = new ArrayList<String>();
                if (valueSpec.getComment() != null) {
                    comments.addAll(Arrays.asList(valueSpec.getComment().split("\n")));
                }
                Pair<String, Map<String, String>> metadata = ConfigHelper.readMetadataFromComment(comments);
                ConfigHelper.setValue(String.join((CharSequence)".", configValue.getPath()), configValue, valueSpec.getDefault(), metadata.getSecond());
            }
        });
        this.list.method_25396().stream().filter(e -> e instanceof ValueEntry).forEach(e -> ((ValueEntry)e).onValueChange());
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.listWidth = Math.min(this.field_22789 - 80, 300);
        int yCenter = this.field_22790 / 2;
        int listL = this.field_22789 / 2 - this.listWidth / 2;
        int listR = this.field_22789 / 2 + this.listWidth / 2;
        this.resetAll = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listR + 10, yCenter - 25, 20, 20).withPadding(2.0f, 2.0f)).withCallback((x, y) -> new ConfirmationScreen().centered().withText(class_5348.method_29430((String)("Resetting all settings of the " + this.type.toString() + " config. Are you sure?"))).withAction(success -> {
            if (success.booleanValue()) {
                this.resetConfig(this.spec.getValues());
            }
        }).open(this));
        this.resetAll.showingElement((RenderElement)AllIcons.I_CONFIG_RESET.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.resetAll)));
        this.resetAll.getToolTip().add((class_2561)Components.literal("Reset All"));
        this.resetAll.getToolTip().addAll(TooltipHelper.cutStringTextComponent("Click here to reset all settings to their default value.", TooltipHelper.Palette.ALL_GRAY));
        this.saveChanges = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listL - 30, yCenter - 25, 20, 20).withPadding(2.0f, 2.0f)).withCallback((x, y) -> {
            if (ConfigHelper.changes.isEmpty()) {
                return;
            }
            ConfirmationScreen confirm = new ConfirmationScreen().centered().withText(class_5348.method_29430((String)("Saving " + ConfigHelper.changes.size() + " changed value" + (ConfigHelper.changes.size() != 1 ? "s" : "")))).withAction(success -> {
                if (success.booleanValue()) {
                    this.saveChanges();
                }
            });
            this.addAnnotationsToConfirm(confirm).open(this);
        });
        this.saveChanges.showingElement((RenderElement)AllIcons.I_CONFIG_SAVE.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.saveChanges)));
        this.saveChanges.getToolTip().add((class_2561)Components.literal("Save Changes"));
        this.saveChanges.getToolTip().addAll(TooltipHelper.cutStringTextComponent("Click here to save your current changes.", TooltipHelper.Palette.ALL_GRAY));
        this.discardChanges = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listL - 30, yCenter + 5, 20, 20).withPadding(2.0f, 2.0f)).withCallback((x, y) -> {
            if (ConfigHelper.changes.isEmpty()) {
                return;
            }
            new ConfirmationScreen().centered().withText(class_5348.method_29430((String)("Discarding " + ConfigHelper.changes.size() + " unsaved change" + (ConfigHelper.changes.size() != 1 ? "s" : "")))).withAction(success -> {
                if (success.booleanValue()) {
                    this.clearChanges();
                }
            }).open(this);
        });
        this.discardChanges.showingElement((RenderElement)AllIcons.I_CONFIG_DISCARD.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.discardChanges)));
        this.discardChanges.getToolTip().add((class_2561)Components.literal("Discard Changes"));
        this.discardChanges.getToolTip().addAll(TooltipHelper.cutStringTextComponent("Click here to discard all the changes you made.", TooltipHelper.Palette.ALL_GRAY));
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listL - 30, yCenter + 65, 20, 20).withPadding(2.0f, 2.0f)).withCallback(this::attemptBackstep);
        this.goBack.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((class_2561)Components.literal("Go Back"));
        this.method_37063(this.resetAll);
        this.method_37063(this.saveChanges);
        this.method_37063(this.discardChanges);
        this.method_37063(this.goBack);
        this.list = new ConfigScreenList(this.field_22787, this.listWidth, this.field_22790 - 80, 35, this.field_22790 - 45, 40);
        this.list.method_25333(this.field_22789 / 2 - ((AbstractSelectionListAccessor)this.list).port_lib$getWidth() / 2);
        this.method_37063(this.list);
        this.search = new ConfigTextField(this.field_22793, this.field_22789 / 2 - this.listWidth / 2, this.field_22790 - 35, this.listWidth, 20);
        this.search.method_1863(this::updateFilter);
        this.search.setHint("Search...");
        this.search.method_1870();
        this.method_37063((class_364)this.search);
        this.configGroup.valueMap().forEach((key, obj) -> {
            String humanKey = SubMenuConfigScreen.toHumanReadable(key);
            if (obj instanceof AbstractConfig) {
                SubMenuEntry entry = new SubMenuEntry(this, humanKey, this.spec, (UnmodifiableConfig)obj);
                entry.path = key;
                this.list.method_25396().add(entry);
                if (this.configGroup.valueMap().size() == 1) {
                    ScreenOpener.open(new SubMenuConfigScreen(this.parent, humanKey, this.type, this.spec, (UnmodifiableConfig)obj));
                }
            } else if (obj instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)obj;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath());
                Object value = configValue.get();
                ConfigScreenList.LabeledEntry entry = null;
                if (value instanceof Boolean) {
                    entry = new BooleanEntry(humanKey, (ForgeConfigSpec.ConfigValue<Boolean>)configValue, valueSpec);
                } else if (value instanceof Enum) {
                    entry = new EnumEntry(humanKey, (ForgeConfigSpec.ConfigValue<Enum<?>>)configValue, valueSpec);
                } else if (value instanceof Number) {
                    entry = NumberEntry.create(value, humanKey, configValue, valueSpec);
                }
                if (entry == null) {
                    entry = new ConfigScreenList.LabeledEntry("Impl missing - " + configValue.get().getClass().getSimpleName() + "  " + humanKey + " : " + value);
                }
                if (this.highlights.contains(key)) {
                    entry.annotations.put("highlight", ":)");
                }
                this.list.method_25396().add(entry);
            }
        });
        Collections.sort(this.list.method_25396(), (e, e2) -> {
            int group = (e2 instanceof SubMenuEntry ? 1 : 0) - (e instanceof SubMenuEntry ? 1 : 0);
            if (group == 0 && e instanceof ConfigScreenList.LabeledEntry && e2 instanceof ConfigScreenList.LabeledEntry) {
                ConfigScreenList.LabeledEntry le = (ConfigScreenList.LabeledEntry)e;
                ConfigScreenList.LabeledEntry le2 = (ConfigScreenList.LabeledEntry)e2;
                return le.label.getComponent().getString().compareTo(le2.label.getComponent().getString());
            }
            return group;
        });
        this.list.search(this.highlights.stream().findFirst().orElse(""));
        if (this.type != ModConfig.Type.SERVER) {
            return;
        }
        if (this.field_22787.method_1496()) {
            return;
        }
        boolean canEdit = this.field_22787 != null && this.field_22787.field_1724 != null && this.field_22787.field_1724.method_5687(2);
        Couple<Color> red = Theme.p(Theme.Key.BUTTON_FAIL);
        Couple<Color> green = Theme.p(Theme.Key.BUTTON_SUCCESS);
        DelegatedStencilElement stencil = new DelegatedStencilElement();
        this.serverLocked = (BoxWidget)((ElementWidget)new BoxWidget(listR + 10, yCenter + 5, 20, 20).withPadding(2.0f, 2.0f)).showingElement(stencil);
        if (!canEdit) {
            this.list.method_25396().forEach(e -> e.setEditable(false));
            this.resetAll.field_22763 = false;
            stencil.withStencilRenderer((ms, w, h, alpha) -> AllIcons.I_CONFIG_LOCKED.render(ms, 0, 0));
            stencil.withElementRenderer((ms, w, h, alpha) -> UIRenderHelper.angledGradient(ms, 90.0f, 8, 0, 16, 16, red));
            this.serverLocked.withBorderColors(red);
            this.serverLocked.getToolTip().add((class_2561)Components.literal("Locked").method_27692(class_124.field_1067));
            this.serverLocked.getToolTip().addAll(TooltipHelper.cutStringTextComponent("You do not have enough permissions to edit the server config. You can still look at the current values here though.", TooltipHelper.Palette.ALL_GRAY));
        } else {
            stencil.withStencilRenderer((ms, w, h, alpha) -> AllIcons.I_CONFIG_UNLOCKED.render(ms, 0, 0));
            stencil.withElementRenderer((ms, w, h, alpha) -> UIRenderHelper.angledGradient(ms, 90.0f, 8, 0, 16, 16, green));
            this.serverLocked.withBorderColors(green);
            this.serverLocked.getToolTip().add((class_2561)Components.literal("Unlocked").method_27692(class_124.field_1067));
            this.serverLocked.getToolTip().addAll(TooltipHelper.cutStringTextComponent("You have enough permissions to edit the server config. Changes you make here will be synced with the server when you save them.", TooltipHelper.Palette.ALL_GRAY));
        }
        this.method_37063(this.serverLocked);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = this.field_22789 / 2;
        graphics.method_25300(this.field_22787.field_1772, ConfigScreen.modID + " > " + this.type.toString().toLowerCase(Locale.ROOT) + " > " + this.title, x, 15, Theme.i(Theme.Key.TEXT));
    }

    @Override
    protected void renderWindowForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
    }

    public void method_25410(@Nonnull class_310 client, int width, int height) {
        double scroll = this.list.method_25341();
        this.method_25423(client, width, height);
        this.list.method_25307(scroll);
    }

    @Override
    @Nullable
    public class_364 method_25399() {
        if (ConfigScreenList.currentText != null) {
            return ConfigScreenList.currentText;
        }
        return super.method_25399();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (class_437.method_25441() && keyCode == 70) {
            this.search.method_25365(true);
        }
        if (keyCode == 259) {
            this.attemptBackstep();
        }
        return false;
    }

    protected void updateFilter(String search) {
        if (this.list.search(search)) {
            this.search.method_1868(Theme.i(Theme.Key.TEXT));
        } else {
            this.search.method_1868(Theme.i(Theme.Key.BUTTON_FAIL));
        }
    }

    protected void attemptBackstep() {
        if (ConfigHelper.changes.isEmpty() || !(this.parent instanceof BaseConfigScreen)) {
            ScreenOpener.open(this.parent);
            return;
        }
        this.showLeavingPrompt(success -> {
            if (success == ConfirmationScreen.Response.Cancel) {
                return;
            }
            if (success == ConfirmationScreen.Response.Confirm) {
                this.saveChanges();
            }
            ConfigHelper.changes.clear();
            ScreenOpener.open(this.parent);
        });
    }

    public void method_25419() {
        if (ConfigHelper.changes.isEmpty()) {
            super.method_25419();
            return;
        }
        this.showLeavingPrompt(success -> {
            if (success == ConfirmationScreen.Response.Cancel) {
                return;
            }
            if (success == ConfirmationScreen.Response.Confirm) {
                this.saveChanges();
            }
            ConfigHelper.changes.clear();
            super.method_25419();
        });
    }

    public void showLeavingPrompt(Consumer<ConfirmationScreen.Response> action) {
        ConfirmationScreen screen = new ConfirmationScreen().centered().withThreeActions(action).addText(class_5348.method_29430((String)("Leaving with " + ConfigHelper.changes.size() + " unsaved change" + (ConfigHelper.changes.size() != 1 ? "s" : "") + " for this config")));
        this.addAnnotationsToConfirm(screen).open(this);
    }

    protected ConfirmationScreen addAnnotationsToConfirm(ConfirmationScreen screen) {
        AtomicBoolean relog = new AtomicBoolean(false);
        AtomicBoolean restart = new AtomicBoolean(false);
        ConfigHelper.changes.values().forEach(change -> {
            if (change.annotations.containsKey(ConfigAnnotations.RequiresRelog.TRUE.getName())) {
                relog.set(true);
            }
            if (change.annotations.containsKey(ConfigAnnotations.RequiresRestart.CLIENT.getName())) {
                restart.set(true);
            }
        });
        if (relog.get()) {
            screen.addText(class_5348.method_29430((String)" "));
            screen.addText(class_5348.method_29430((String)"At least one changed value will require you to relog to take full effect"));
        }
        if (restart.get()) {
            screen.addText(class_5348.method_29430((String)" "));
            screen.addText(class_5348.method_29430((String)"At least one changed value will require you to restart your game to take full effect"));
        }
        return screen;
    }
}

