/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.LongAttached;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5250;

public class CountedItemStackList {
    Map<class_1792, Set<ItemStackEntry>> items = new HashMap<class_1792, Set<ItemStackEntry>>();

    public CountedItemStackList(Storage<ItemVariant> inventory, FilteringBehaviour filteringBehaviour) {
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : inventory.nonEmptyViews()) {
                ItemVariant resource = (ItemVariant)view.getResource();
                class_1799 stack = resource.toStack();
                if (!filteringBehaviour.test(stack)) {
                    return;
                }
                long amount = view.getAmount();
                this.add(stack, amount);
                view.extract((Object)resource, amount, (TransactionContext)t);
            }
        }
    }

    public Stream<LongAttached<class_5250>> getTopNames(int limit) {
        return this.items.values().stream().flatMap(Collection::stream).sorted(LongAttached.comparator()).limit(limit).map(entry -> LongAttached.with(entry.count(), entry.stack().method_7964().method_27661()));
    }

    public void add(class_1799 stack) {
        this.add(stack, stack.method_7947());
    }

    public void add(class_1799 stack, long amount) {
        if (stack.method_7960()) {
            return;
        }
        Set<ItemStackEntry> stackSet = this.getOrCreateItemSet(stack);
        for (ItemStackEntry entry : stackSet) {
            if (!entry.matches(stack)) continue;
            entry.grow(amount);
            return;
        }
        stackSet.add(new ItemStackEntry(stack, amount));
    }

    private Set<ItemStackEntry> getOrCreateItemSet(class_1799 stack) {
        if (!this.items.containsKey(stack.method_7909())) {
            this.items.put(stack.method_7909(), new HashSet());
        }
        return this.getItemSet(stack);
    }

    private Set<ItemStackEntry> getItemSet(class_1799 stack) {
        return this.items.get(stack.method_7909());
    }

    public static class ItemStackEntry
    extends LongAttached<class_1799> {
        public ItemStackEntry(class_1799 stack) {
            this(stack, stack.method_7947());
        }

        public ItemStackEntry(class_1799 stack, long amount) {
            super(amount, stack);
        }

        public boolean matches(class_1799 other) {
            return ItemHandlerHelper.canItemStacksStack((class_1799)other, (class_1799)this.stack());
        }

        public class_1799 stack() {
            return (class_1799)this.getSecond();
        }

        public void grow(long amount) {
            this.setFirst((Long)this.getFirst() + amount);
        }

        public long count() {
            return (Long)this.getFirst();
        }
    }
}

