/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.be;

import com.simibubi.create.content.trains.display.FlapDisplayBlock;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.AbstractAdvancedDisplayBlock;
import de.mrjulsen.crn.block.be.IColorableBlockEntity;
import de.mrjulsen.crn.block.be.IContraptionBlockEntity;
import de.mrjulsen.crn.block.be.IMultiblockBlockEntity;
import de.mrjulsen.crn.block.display.AdvancedDisplaySource;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.data.CarriageData;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.EDisplayInfo;
import de.mrjulsen.crn.data.EDisplayType;
import de.mrjulsen.crn.data.IBlockEntitySerializable;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.TrainDataRequestPacket;
import de.mrjulsen.mcdragonlib.block.IBERInstance;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class AdvancedDisplayBlockEntity
extends SmartBlockEntity
implements IMultiblockBlockEntity<AdvancedDisplayBlockEntity, AbstractAdvancedDisplayBlock>,
IContraptionBlockEntity<AdvancedDisplayBlockEntity>,
IBERInstance<AdvancedDisplayBlockEntity>,
IBlockEntitySerializable,
IColorableBlockEntity {
    private static final String NBT_XSIZE = "XSize";
    private static final String NBT_YSIZE = "YSize";
    private static final String NBT_CONTROLLER = "IsController";
    private static final String NBT_COLOR = "Color";
    private static final String NBT_GLOWING = "Glowing";
    private static final String NBT_INFO_TYPE = "InfoType";
    private static final String NBT_DISPLAY_TYPE = "DisplayType";
    private static final String NBT_PREDICTIONS = "Predictions";
    private static final String NBT_NEXT_DEPARTURE_STOPOVERS = "NextStopovers";
    private static final String NBT_FILTER = "Filter";
    private static final String NBT_LAST_REFRESH_TIME = "LastRefreshed";
    private static final String NBT_PLATFORM_WIDTH = "PlatformWidth";
    private static final String NBT_TRAIN_NAME_WIDTH = "TrainNameWidth";
    private static final String NBT_TIME_DISPLAY = "TimeDisplay";
    public static final byte MAX_XSIZE = 16;
    public static final byte MAX_YSIZE = 16;
    private static final int REFRESH_FREQUENCY = 100;
    private byte xSize = 1;
    private byte ySize = 1;
    private boolean isController;
    private List<DeparturePrediction.SimpleDeparturePrediction> predictions;
    private List<String> nextDepartureStopovers;
    private String stationNameFilter;
    private TrainStationAlias.StationInfo stationInfo;
    private byte trainNameWidth;
    private byte platformWidth;
    private AdvancedDisplaySource.ETimeDisplay timeDisplay = AdvancedDisplaySource.ETimeDisplay.ABS;
    private int color = class_1767.field_7952.method_16357();
    private boolean glowing = false;
    private EDisplayInfo infoType = EDisplayInfo.SIMPLE;
    private EDisplayType displayType = EDisplayType.TRAIN_DESTINATION;
    private long lastRefreshedTime;
    private TrainDataRequestPacket.TrainData trainData = TrainDataRequestPacket.TrainData.empty(false);
    private CarriageData carriageData = new CarriageData(0, class_2350.field_11043, false);
    private int syncTicks = 99;
    private final Cache<IBlockEntityRendererInstance<AdvancedDisplayBlockEntity>> renderer = new Cache(() -> new AdvancedDisplayRenderInstance(this));
    public final Cache<DeparturePrediction.TrainExitSide> relativeExitDirection = new Cache(() -> {
        if (this.getCarriageData() == null || !this.getTrainData().getNextStop().isPresent() || !(this.method_11010().method_26204() instanceof AbstractAdvancedDisplayBlock)) {
            return DeparturePrediction.TrainExitSide.UNKNOWN;
        }
        DeparturePrediction.TrainExitSide side = this.getTrainData().getNextStop().get().exitSide();
        class_2350 blockFacing = (class_2350)this.method_11010().method_11654((class_2769)class_2383.field_11177);
        if (!this.carriageData.isOppositeDirection()) {
            blockFacing = blockFacing.method_10153();
        }
        DeparturePrediction.TrainExitSide result = side;
        if (this.getCarriageData().assemblyDirection() == blockFacing) {
            result = result.getOpposite();
        } else if (this.getCarriageData().assemblyDirection().method_10153() != blockFacing) {
            result = DeparturePrediction.TrainExitSide.UNKNOWN;
        }
        return result;
    });
    public final Cache<Tripple<Float, Float, Float>> renderRotation = new Cache(() -> {
        class_2248 patt6190$temp = this.method_11010().method_26204();
        if (patt6190$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt6190$temp;
            return block.getRenderRotation(this.field_11863, this.method_11010(), this.field_11867);
        }
        return Tripple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderOffset = new Cache(() -> {
        class_2248 patt6510$temp = this.method_11010().method_26204();
        if (patt6510$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt6510$temp;
            return block.getRenderOffset(this.field_11863, this.method_11010(), this.field_11867);
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderZOffset = new Cache(() -> {
        class_2248 patt6820$temp = this.method_11010().method_26204();
        if (patt6820$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt6820$temp;
            return block.getRenderZOffset(this.field_11863, this.method_11010(), this.field_11867);
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderAspectRatio = new Cache(() -> {
        class_2248 patt7135$temp = this.method_11010().method_26204();
        if (patt7135$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt7135$temp;
            Pair<Float, Float> raw = block.getRenderAspectRatio(this.field_11863, this.method_11010(), this.field_11867);
            float scale = 1.0f / Math.min(((Float)raw.getFirst()).floatValue(), ((Float)raw.getSecond()).floatValue());
            return Pair.of((Object)Float.valueOf(((Float)raw.getFirst()).floatValue() * scale), (Object)Float.valueOf(((Float)raw.getSecond()).floatValue() * scale));
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    });
    public final Cache<Float> renderScale = new Cache(() -> Float.valueOf(1.0f / Math.max(((Float)((Pair)this.renderAspectRatio.get()).getFirst()).floatValue(), ((Float)((Pair)this.renderAspectRatio.get()).getSecond()).floatValue())));

    public AdvancedDisplayBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.reset();
    }

    public TrainDataRequestPacket.TrainData getTrainData() {
        return this.trainData;
    }

    public CarriageData getCarriageData() {
        return this.carriageData;
    }

    public long getLastRefreshedTime() {
        return this.lastRefreshedTime;
    }

    public byte getTrainNameWidth() {
        return this.trainNameWidth;
    }

    public AdvancedDisplaySource.ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    public byte getPlatformWidth() {
        return this.platformWidth;
    }

    public byte getXSize() {
        return this.xSize;
    }

    public byte getXSizeScaled() {
        return (byte)((float)this.getXSize() * ((Float)((Pair)this.renderAspectRatio.get()).getFirst()).floatValue());
    }

    public byte getYSize() {
        return this.ySize;
    }

    public byte getYSizeScaled() {
        return (byte)((float)this.getYSize() * ((Float)((Pair)this.renderAspectRatio.get()).getSecond()).floatValue());
    }

    @Override
    public boolean isController() {
        return this.isController;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isGlowing() {
        return this.glowing;
    }

    public EDisplayInfo getInfoType() {
        return this.infoType;
    }

    public EDisplayType getDisplayType() {
        return this.displayType;
    }

    @Override
    public byte getMaxWidth() {
        return 16;
    }

    @Override
    public byte getMaxHeight() {
        return 16;
    }

    @Override
    public byte getWidth() {
        return this.xSize;
    }

    @Override
    public byte getHeight() {
        return this.ySize;
    }

    @Override
    public Class<AbstractAdvancedDisplayBlock> getBlockType() {
        return AbstractAdvancedDisplayBlock.class;
    }

    @Override
    public Class<AdvancedDisplayBlockEntity> getBlockEntityType() {
        return AdvancedDisplayBlockEntity.class;
    }

    public List<DeparturePrediction.SimpleDeparturePrediction> getPredictions() {
        return this.predictions;
    }

    public List<String> getNextDepartureStopovers() {
        return this.nextDepartureStopovers;
    }

    public boolean isPlatformFixed() {
        return !this.stationNameFilter.contains("*");
    }

    public TrainStationAlias.StationInfo getStationInfo() {
        return this.stationInfo;
    }

    public String getStationNameFilter() {
        return this.stationNameFilter;
    }

    public boolean isSingleLine() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)class_22482;
            return !(!block.isSingleLined() && (this.getDisplayType() == EDisplayType.PASSENGER_INFORMATION && this.getInfoType() == EDisplayInfo.INFORMATIVE || this.getDisplayType() == EDisplayType.PLATFORM && this.getInfoType() == EDisplayInfo.DETAILED || this.getDisplayType() == EDisplayType.PLATFORM && this.getInfoType() == EDisplayInfo.INFORMATIVE));
        }
        return false;
    }

    public int getPlatformInfoLinesCount() {
        switch (this.getInfoType()) {
            default: {
                return 32;
            }
            case DETAILED: {
                return this.getYSize() * 3 - 1;
            }
            case INFORMATIVE: 
        }
        return this.getYSize() * 3 - 2;
    }

    public void setColor(int color) {
        this.color = color;
        if (this.field_11863.field_9236) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
        if (this.field_11863.field_9236) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    public void setInfoType(EDisplayInfo type) {
        this.infoType = type;
        if (this.field_11863.field_9236) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    public void setDisplayType(EDisplayType type) {
        this.displayType = type;
        if (this.field_11863.field_9236) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    public void setDepartureData(List<DeparturePrediction.SimpleDeparturePrediction> predictions, List<String> nextDepartureStopovers, String stationNameFilter, TrainStationAlias.StationInfo staionInfo, long lastRefreshedTime, byte platformWidth, byte trainNameWidth, byte timeDisplayId) {
        this.predictions = predictions.stream().sorted(Comparator.comparingInt(x -> x.departureTicks())).toList();
        this.stationNameFilter = stationNameFilter;
        this.stationInfo = staionInfo;
        this.nextDepartureStopovers = nextDepartureStopovers;
        this.lastRefreshedTime = lastRefreshedTime;
        this.platformWidth = platformWidth;
        this.trainNameWidth = trainNameWidth;
        this.timeDisplay = AdvancedDisplaySource.ETimeDisplay.getById(timeDisplayId);
    }

    @Override
    public boolean connectable(class_1922 getter, class_2338 a, class_2338 b) {
        if (getter == null || a == null || b == null) {
            return false;
        }
        class_2586 class_25862 = getter.method_8321(a);
        if (class_25862 instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity be1 = (AdvancedDisplayBlockEntity)class_25862;
            class_25862 = getter.method_8321(b);
            if (class_25862 instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be2 = (AdvancedDisplayBlockEntity)class_25862;
                class_25862 = be1.method_11010().method_26204();
                if (class_25862 instanceof AbstractAdvancedDisplayBlock) {
                    AbstractAdvancedDisplayBlock block1 = (AbstractAdvancedDisplayBlock)class_25862;
                    class_25862 = be2.method_11010().method_26204();
                    if (class_25862 instanceof AbstractAdvancedDisplayBlock) {
                        AbstractAdvancedDisplayBlock block2 = (AbstractAdvancedDisplayBlock)class_25862;
                        return block1 == block2 && be1.getDisplayType() == be2.getDisplayType() && be1.getInfoType() == be2.getInfoType() && block1.canConnectWithBlock(getter, getter.method_8320(a), getter.method_8320(b)) && block2.canConnectWithBlock(getter, getter.method_8320(b), getter.method_8320(a)) && (!a.method_10084().equals((Object)b) || (Boolean)be1.method_11010().method_11654((class_2769)AbstractAdvancedDisplayBlock.UP) != false && !be1.isSingleLine()) && (!a.method_10074().equals((Object)b) || (Boolean)be1.method_11010().method_11654((class_2769)AbstractAdvancedDisplayBlock.DOWN) != false && !be1.isSingleLine());
                    }
                }
            }
        }
        return false;
    }

    public AdvancedDisplayBlockEntity getController() {
        AdvancedDisplayBlockEntity flap;
        class_2586 found;
        int i;
        if (this.isController()) {
            return this;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof AbstractAdvancedDisplayBlock)) {
            return null;
        }
        class_2338.class_2339 pos = this.method_11016().method_25503();
        class_2350 side = ((class_2350)blockState.method_11654((class_2769)AbstractAdvancedDisplayBlock.FACING)).method_10170();
        for (i = 0; i < this.getMaxWidth(); ++i) {
            if (!this.connectable((class_1922)this.field_11863, (class_2338)pos, pos.method_10093(side))) {
                found = this.field_11863.method_8321((class_2338)pos);
                if (!(found instanceof AdvancedDisplayBlockEntity)) break;
                flap = (AdvancedDisplayBlockEntity)found;
                if (!flap.isController) break;
                return flap;
            }
            pos.method_10098(side);
        }
        for (i = 0; i < this.getMaxHeight(); ++i) {
            if (!this.connectable((class_1922)this.field_11863, (class_2338)pos, pos.method_10093(class_2350.field_11036))) {
                found = this.field_11863.method_8321((class_2338)pos);
                if (!(found instanceof AdvancedDisplayBlockEntity)) break;
                flap = (AdvancedDisplayBlockEntity)found;
                if (!flap.isController) break;
                return flap;
            }
            pos.method_10098(class_2350.field_11036);
        }
        return null;
    }

    public void copyFrom(AdvancedDisplayBlockEntity other) {
        if (this.getColor() == other.getColor() && this.getInfoType() == other.getInfoType() && this.getDisplayType() == other.getDisplayType() && this.isGlowing() == other.isGlowing()) {
            return;
        }
        this.color = other.getColor();
        this.glowing = other.isGlowing();
        this.displayType = other.getDisplayType();
        this.infoType = other.getInfoType();
        this.notifyUpdate();
    }

    public void reset() {
        this.predictions = List.of();
        this.nextDepartureStopovers = List.of();
        this.stationNameFilter = "";
        this.platformWidth = (byte)-1;
        this.trainNameWidth = (byte)16;
        this.xSize = 1;
        this.ySize = 1;
        this.isController = false;
        this.stationInfo = TrainStationAlias.StationInfo.empty();
    }

    public void updateControllerStatus() {
        if (this.field_11863.field_9236) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof AbstractAdvancedDisplayBlock)) {
            return;
        }
        class_2350 leftDirection = ((class_2350)blockState.method_11654((class_2769)AbstractAdvancedDisplayBlock.FACING)).method_10170();
        boolean shouldBeController = !this.connectable((class_1922)this.field_11863, this.field_11867, this.field_11867.method_10093(leftDirection)) && !this.connectable((class_1922)this.field_11863, this.field_11867, this.field_11867.method_10084());
        int newXSize = 1;
        byte newYSize = 1;
        if (shouldBeController) {
            class_2338 relPos;
            for (int xOffset = 1; xOffset < this.getMaxWidth() && this.field_11863.method_8320(relPos = this.field_11867.method_10079(leftDirection.method_10153(), xOffset)) == blockState; ++xOffset) {
                newXSize = (byte)(newXSize + 1);
            }
            if (!this.isSingleLine()) {
                for (int yOffset = 0; yOffset < this.getMaxHeight(); ++yOffset) {
                    class_2338 downPos = this.field_11867.method_10079(class_2350.field_11033, yOffset);
                    for (int i = 0; i < newXSize; ++i) {
                        AdvancedDisplayBlockEntity be;
                        class_2338 relPos2 = downPos.method_10079(leftDirection.method_10153(), i);
                        class_2586 class_25862 = this.field_11863.method_8321(relPos2);
                        if (!(class_25862 instanceof AdvancedDisplayBlockEntity) || (be = (AdvancedDisplayBlockEntity)class_25862) == this) continue;
                        be.copyFrom(this);
                    }
                    if (!this.connectable((class_1922)this.field_11863, downPos, downPos.method_10074())) break;
                    newYSize = (byte)(newYSize + 1);
                }
            }
        }
        if (this.isController == shouldBeController && newXSize == this.xSize && newYSize == this.ySize) {
            return;
        }
        this.isController = shouldBeController;
        this.xSize = newXSize;
        this.ySize = newYSize;
        if (!this.isController) {
            this.reset();
        }
        this.notifyUpdate();
    }

    public void tick() {
        if (this.field_11863.field_9236) {
            this.getRenderer().tick(this.field_11863, this.method_11016(), this.method_11010(), (class_2586)this);
        }
        super.tick();
        if (this.getDisplayType().getSource() != EDisplayType.EDisplayTypeDataSource.PLATFORM) {
            return;
        }
        ++this.syncTicks;
        if ((this.syncTicks %= 100) == 0 && this.field_11863.field_9236) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = this.getPredictions().size() > 0;
            if (shouldUpdate) {
                this.getRenderer().update(this.field_11863, this.method_11016(), this.method_11010(), (class_2586)this, IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED);
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.updateControllerStatus();
    }

    @Override
    public void contraptionTick(class_1937 level, class_2338 pos, class_2680 state, CarriageContraption carriage) {
        this.getRenderer().tick(level, pos, state, (class_2586)this);
        if (!this.isController()) {
            return;
        }
        if (this.getDisplayType().getSource() != EDisplayType.EDisplayTypeDataSource.TRAIN_INFORMATION) {
            return;
        }
        ++this.syncTicks;
        if ((this.syncTicks %= 100) == 0) {
            long id = InstanceManager.registerClientTrainDataResponseAction((data, refreshTime) -> {
                boolean oos;
                if (data == null) {
                    return;
                }
                boolean shouldUpdate = false;
                if (this.trainData != null && this.trainData.getNextStop().isPresent() && data.getNextStop().isPresent()) {
                    DeparturePrediction.SimpleDeparturePrediction prediction = this.trainData.getNextStop().get();
                    shouldUpdate = !this.trainData.trainName().equals(data.trainName()) || !prediction.scheduleTitle().equals(data.predictions().get(0).scheduleTitle()) || !prediction.stationTagName().equals(data.predictions().get(0).stationTagName()) || this.trainData.getNextStop().get().exitSide() != data.getNextStop().get().exitSide() || this.getInfoType() == EDisplayInfo.INFORMATIVE && this.getDisplayType() == EDisplayType.PASSENGER_INFORMATION && (long)this.trainData.getNextStop().get().departureTicks() + this.lastRefreshedTime != (long)data.getNextStop().get().departureTicks() + refreshTime;
                }
                boolean bl = oos = this.trainData != null && !this.trainData.trainId().equals(Constants.ZERO_UUID) && !data.getNextStop().isPresent();
                if (oos) {
                    shouldUpdate = true;
                }
                this.lastRefreshedTime = refreshTime;
                this.trainData = oos ? TrainDataRequestPacket.TrainData.empty(true) : data;
                this.carriageData = new CarriageData(((CarriageContraptionEntity)carriage.entity).carriageIndex, carriage.getAssemblyDirection(), data.isOppositeDirection());
                this.relativeExitDirection.clear();
                if (shouldUpdate) {
                    this.getRenderer().update(level, pos, state, (class_2586)this, IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED);
                }
            });
            CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new TrainDataRequestPacket(id, ((CarriageContraptionEntity)carriage.entity).trainId, true));
        }
    }

    protected void write(class_2487 pTag, boolean clientPacket) {
        super.write(pTag, clientPacket);
        pTag.method_10567(NBT_XSIZE, this.getXSize());
        pTag.method_10567(NBT_YSIZE, this.getYSize());
        pTag.method_10569(NBT_COLOR, this.getColor());
        pTag.method_10556(NBT_CONTROLLER, this.isController());
        pTag.method_10569(NBT_INFO_TYPE, this.getInfoType().getId());
        pTag.method_10569(NBT_DISPLAY_TYPE, this.getDisplayType().getId());
        pTag.method_10582(NBT_FILTER, this.getStationNameFilter());
        pTag.method_10556(NBT_GLOWING, this.isGlowing());
        pTag.method_10544(NBT_LAST_REFRESH_TIME, this.getLastRefreshedTime());
        pTag.method_10567(NBT_PLATFORM_WIDTH, this.getPlatformWidth());
        pTag.method_10567(NBT_TRAIN_NAME_WIDTH, this.getTrainNameWidth());
        pTag.method_10567(NBT_TIME_DISPLAY, this.getTimeDisplay().getId());
        this.getStationInfo().writeNbt(pTag);
        if (this.getPredictions() != null && !this.getPredictions().isEmpty()) {
            class_2499 list = new class_2499();
            list.addAll(this.getPredictions().stream().map(x -> x.toNbt()).toList());
            pTag.method_10566(NBT_PREDICTIONS, (class_2520)list);
        }
        if (this.getNextDepartureStopovers() != null && !this.getNextDepartureStopovers().isEmpty()) {
            class_2499 stopovers = new class_2499();
            stopovers.addAll(this.getNextDepartureStopovers().stream().map(x -> class_2519.method_23256((String)x)).toList());
            pTag.method_10566(NBT_NEXT_DEPARTURE_STOPOVERS, (class_2520)stopovers);
        }
    }

    public void read(class_2487 pTag, boolean clientPacket) {
        boolean updateClient = false;
        if (this.field_11863 != null && this.method_11010() != null && this.field_11863.field_9236 && (this.isController() != pTag.method_10577(NBT_CONTROLLER) || this.getXSize() != pTag.method_10571(NBT_XSIZE) || this.getYSize() != pTag.method_10571(NBT_YSIZE) || this.getPlatformWidth() != pTag.method_10571(NBT_PLATFORM_WIDTH) || this.getTrainNameWidth() != pTag.method_10571(NBT_TRAIN_NAME_WIDTH) || this.getPredictions().isEmpty() ^ !pTag.method_10545(NBT_PREDICTIONS))) {
            updateClient = true;
        }
        super.read(pTag, clientPacket);
        TrainStationAlias.StationInfo info = TrainStationAlias.StationInfo.fromNbt(pTag);
        this.xSize = pTag.method_10571(NBT_XSIZE);
        this.ySize = pTag.method_10571(NBT_YSIZE);
        if (pTag.method_10545(NBT_COLOR)) {
            this.color = pTag.method_10550(NBT_COLOR);
        }
        this.glowing = pTag.method_10577(NBT_GLOWING);
        this.isController = pTag.method_10577(NBT_CONTROLLER);
        this.infoType = EDisplayInfo.getTypeById(pTag.method_10550(NBT_INFO_TYPE));
        this.displayType = EDisplayType.getTypeById(pTag.method_10550(NBT_DISPLAY_TYPE));
        this.setDepartureData(pTag.method_10545(NBT_PREDICTIONS) ? new ArrayList<DeparturePrediction.SimpleDeparturePrediction>(pTag.method_10554(NBT_PREDICTIONS, 10).stream().map(x -> DeparturePrediction.SimpleDeparturePrediction.fromNbt((class_2487)x)).toList()) : new ArrayList(), pTag.method_10545(NBT_NEXT_DEPARTURE_STOPOVERS) ? pTag.method_10554(NBT_NEXT_DEPARTURE_STOPOVERS, 8).stream().map(x -> ((class_2519)x).method_10714()).toList() : new ArrayList(), pTag.method_10558(NBT_FILTER), info, pTag.method_10537(NBT_LAST_REFRESH_TIME), pTag.method_10571(NBT_PLATFORM_WIDTH), pTag.method_10571(NBT_TRAIN_NAME_WIDTH), pTag.method_10571(NBT_TIME_DISPLAY));
        if (updateClient) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    @Override
    public class_2487 serialize() {
        class_2487 nbt = new class_2487();
        nbt.method_10569(NBT_INFO_TYPE, this.getInfoType().getId());
        nbt.method_10569(NBT_DISPLAY_TYPE, this.getDisplayType().getId());
        return nbt;
    }

    @Override
    public void deserialize(class_2487 nbt) {
        this.infoType = EDisplayInfo.getTypeById(nbt.method_10550(NBT_INFO_TYPE));
        this.displayType = EDisplayType.getTypeById(nbt.method_10550(NBT_DISPLAY_TYPE));
    }

    public class_238 getRenderBoundingBox() {
        class_238 aabb = new class_238(this.field_11867);
        if (!this.isController) {
            return aabb;
        }
        class_2382 normal = this.getDirection().method_10170().method_10163();
        return aabb.method_1012((double)(normal.method_10263() * this.getXSize()), (double)(-this.getYSize()), (double)(normal.method_10260() * this.getXSize()));
    }

    public class_2350 getDirection() {
        return this.method_11010().method_28500(FlapDisplayBlock.HORIZONTAL_FACING).orElse(class_2350.field_11035).method_10153();
    }

    public IBlockEntityRendererInstance<AdvancedDisplayBlockEntity> getRenderer() {
        return (IBlockEntityRendererInstance)this.renderer.get();
    }

    protected class_238 createRenderBoundingBox() {
        class_238 aabb = new class_238(this.field_11867);
        if (!this.isController) {
            return aabb;
        }
        class_2382 normal = this.getDirection().method_10170().method_10163();
        return aabb.method_1012((double)(normal.method_10263() * this.xSize), (double)(-this.ySize), (double)(normal.method_10260() * this.xSize));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_39026((class_2586)this, class_2586::method_16887);
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    public void onDataPacket(class_2535 net, class_2622 pkt) {
        this.method_11014(pkt.method_11290());
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 512);
    }
}

