/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.SimpleTrainSchedule;
import de.mrjulsen.crn.data.SimulatedTrainSchedule;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.crn.util.TrainUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class AdvancedDisplayTarget
extends DisplayBoardTarget {
    public void acceptFlapText(int line, List<List<class_5250>> text, DisplayLinkContext context) {
        AdvancedDisplayBlockEntity blockEntity;
        AdvancedDisplayBlockEntity controller;
        class_2487 nbt = context.sourceConfig();
        if (!nbt.method_10545("AdvancedDisplay")) {
            return;
        }
        String filter = context.sourceConfig().method_10558("Filter");
        class_2586 class_25862 = context.getTargetBlockEntity();
        if (class_25862 instanceof AdvancedDisplayBlockEntity && (controller = (blockEntity = (AdvancedDisplayBlockEntity)class_25862).getController()) != null) {
            DeparturePrediction.SimpleDeparturePrediction pred;
            Train train;
            List<DeparturePrediction.SimpleDeparturePrediction> preds = AdvancedDisplayTarget.prepare(filter, controller.getPlatformInfoLinesCount()).stream().map(x -> new DeparturePrediction((GlobalTrainDisplayData.TrainDeparturePrediction)x).simplify()).sorted(Comparator.comparingInt(x -> x.departureTicks())).toList();
            ArrayList<String> stopovers = new ArrayList<String>();
            if (!preds.isEmpty() && (train = TrainUtils.getTrain((pred = preds.iterator().next()).trainId())) != null) {
                SimulatedTrainSchedule sched = SimpleTrainSchedule.of(TrainUtils.getTrainStopsSorted(pred.trainId(), context.blockEntity().method_10997())).simulate(train, 0, pred.stationName());
                ArrayList<TrainStop> stops = new ArrayList<TrainStop>(sched.getAllStops());
                boolean foundStart = false;
                if (!stops.isEmpty()) {
                    for (int i = 0; i < stops.size() - 1; ++i) {
                        TrainStop x2 = (TrainStop)stops.get(i);
                        if (foundStart) {
                            stopovers.add(x2.getStationAlias().getAliasName().get());
                        }
                        foundStart = foundStart || x2.getPrediction().getStationName().equals(pred.stationName());
                    }
                }
            }
            controller.setDepartureData(preds, stopovers, filter, GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(filter).getInfoForStation(filter), context.getTargetBlockEntity().method_10997().method_8532(), (byte)context.sourceConfig().method_10550("PlatformWidth"), (byte)context.sourceConfig().method_10550("TrainNameWidth"), context.sourceConfig().method_10571("TimeDisplay"));
            controller.sendData();
        }
    }

    public static List<GlobalTrainDisplayData.TrainDeparturePrediction> prepare(String filter, int maxLines) {
        String regex = filter.isBlank() ? filter : "\\Q" + filter.replace("*", "\\E.*\\Q") + "\\E";
        return new HashMap(GlobalTrainDisplayData.statusByDestination).entrySet().stream().filter(e -> ((String)e.getKey()).matches(regex)).flatMap(e -> ((Collection)e.getValue()).stream()).sorted().limit(maxLines).toList();
    }

    public boolean isReserved(int line, class_2586 target, DisplayLinkContext context) {
        return super.isReserved(line, target, context) || target instanceof AdvancedDisplayBlockEntity;
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        AdvancedDisplayBlockEntity controller = this.getController(context);
        if (controller == null) {
            return new DisplayTargetStats(1, 1, (DisplayTarget)this);
        }
        return new DisplayTargetStats(1, 1, (DisplayTarget)this);
    }

    private AdvancedDisplayBlockEntity getController(DisplayLinkContext context) {
        class_2586 teIn = context.getTargetBlockEntity();
        if (!(teIn instanceof AdvancedDisplayBlockEntity)) {
            return null;
        }
        AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)teIn;
        return be.getController();
    }

    public class_238 getMultiblockBounds(class_1936 level, class_2338 pos) {
        class_238 baseShape = super.getMultiblockBounds(level, pos);
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof AdvancedDisplayBlockEntity)) {
            return baseShape;
        }
        AdvancedDisplayBlockEntity fdbe = (AdvancedDisplayBlockEntity)be;
        AdvancedDisplayBlockEntity controller = fdbe.getController();
        if (controller == null) {
            return baseShape;
        }
        class_2382 normal = controller.getDirection().method_10170().method_10163();
        return baseShape.method_996(controller.method_11016().method_10059((class_2382)pos)).method_1012((double)(normal.method_10263() * (controller.getXSize() - 1)), (double)(1 - controller.getYSize()), (double)(normal.method_10260() * (controller.getXSize() - 1)));
    }
}

