/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.base.BERText;
import de.mrjulsen.crn.client.ber.variants.IBERRenderSubtype;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.SimpleTrainConnection;
import de.mrjulsen.crn.event.listeners.JourneyListener;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.NextConnectionsRequestPacket;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class BERPassengerInfoInformative
implements IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> {
    private static final class_2960 TEXTURE = new class_2960("createrailwaysnavigator", "textures/gui/overview.png");
    private static final int TEX_ROUTE_PATH_U = 226;
    private static final int TEX_ROUTE_PATH_H = 14;
    private static final float PANEL_LINE_HEIGHT = 2.0f;
    private static final float PANEL_Y_START = 5.75f;
    private static final int NEXT_CONNECTIONS_MAX_ENTRIES_PER_PAGE = 3;
    private static final int NEXT_CONNECTIONS_PAGE_TIMER = 100;
    private BERText timeLabel;
    private BERText titleLabel;
    private JourneyListener.State state = JourneyListener.State.WHILE_TRAVELING;
    private List<SimpleTrainConnection> nextConnections;
    private long nextConnectionsRefreshTime = 0L;
    private int nextConnectionsPage = 0;
    private int nextConnectionsMaxPage = 0;
    private int nextConnectionsTimer = 0;
    private DeparturePrediction.TrainExitSide lastKnownExitSide = DeparturePrediction.TrainExitSide.UNKNOWN;
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final class_2561 textNextConnections = ELanguage.translate("gui.createrailwaysnavigator.route_overview.next_connections").method_27692(class_124.field_1067);

    @Override
    public boolean isSingleLined() {
        return false;
    }

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent) {
        if (pBlockEntity.getTrainData() == null) {
            return;
        }
        boolean dirty = false;
        if (pBlockEntity.getTrainData().getNextStop().isPresent()) {
            if (this.state != JourneyListener.State.WHILE_NEXT_STOP && pBlockEntity.getTrainData().getNextStop().get().departureTicks() <= 0) {
                this.state = JourneyListener.State.WHILE_NEXT_STOP;
                dirty = true;
            } else if (this.state != JourneyListener.State.BEFORE_NEXT_STOP && pBlockEntity.getTrainData().getNextStop().get().departureTicks() <= (Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get() && pBlockEntity.getTrainData().getNextStop().get().departureTicks() > 0) {
                this.state = JourneyListener.State.BEFORE_NEXT_STOP;
                this.nextConnections = null;
                long id = InstanceManager.registerClientNextConnectionsResponseAction((data, refreshTime) -> {
                    this.nextConnections = new ArrayList<SimpleTrainConnection>((Collection<SimpleTrainConnection>)data);
                    this.nextConnectionsPage = 0;
                    this.nextConnectionsTimer = 0;
                    this.nextConnectionsRefreshTime = refreshTime;
                    if (data != null && !data.isEmpty()) {
                        this.nextConnectionsMaxPage = this.nextConnections.size() / 3 + (this.nextConnections.size() % 3 == 0 ? 0 : 1);
                        parent.labels.clear();
                        this.updateNextConnections(level, pos, state, pBlockEntity, parent);
                    }
                });
                CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new NextConnectionsRequestPacket(id, pBlockEntity.getTrainData().trainId(), pBlockEntity.getTrainData().getNextStop().get().stationTagName(), pBlockEntity.getTrainData().getNextStop().get().departureTicks()));
                dirty = true;
            } else if (this.state != JourneyListener.State.WHILE_TRAVELING && pBlockEntity.getTrainData().getNextStop().get().departureTicks() > (Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()) {
                this.state = JourneyListener.State.WHILE_TRAVELING;
                dirty = true;
            }
        }
        if (this.state == JourneyListener.State.BEFORE_NEXT_STOP && this.nextConnections != null && !this.nextConnections.isEmpty()) {
            ++this.nextConnectionsTimer;
            if ((this.nextConnectionsTimer %= 100) == 0) {
                ++this.nextConnectionsPage;
                this.nextConnectionsPage %= this.nextConnectionsMaxPage;
                parent.labels.clear();
                this.updateNextConnections(level, pos, state, pBlockEntity, parent);
            }
        }
        if (this.lastKnownExitSide != pBlockEntity.relativeExitDirection.get()) {
            dirty = true;
        }
        this.lastKnownExitSide = (DeparturePrediction.TrainExitSide)((Object)pBlockEntity.relativeExitDirection.get());
        if (dirty) {
            this.update(level, pos, state, pBlockEntity, parent, IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED);
        } else {
            this.generateTimeLabel(level, pos, state, pBlockEntity, parent);
        }
        if (this.titleLabel != null) {
            this.titleLabel.tick();
        }
    }

    @Override
    public void update(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason) {
        if (blockEntity.getTrainData() == null) {
            return;
        }
        this.generateTitleBar(level, pos, state, blockEntity, parent, reason);
        if (this.state == JourneyListener.State.BEFORE_NEXT_STOP && this.nextConnections != null && !this.nextConnections.isEmpty()) {
            return;
        }
        parent.labels.clear();
        this.updateOverview(level, pos, state, blockEntity, parent);
    }

    @Override
    public void renderAdditional(IBlockEntityRendererInstance.BlockEntityRendererContext context, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent, float pPartialTicks, class_4587 pPoseStack, class_4597 pBufferSource, int pPackedLight, int pOverlay, Boolean backSide) {
        this.timeLabel.render(pPoseStack, pBufferSource, pPackedLight);
        this.titleLabel.render(pPoseStack, pBufferSource, pPackedLight);
        context.renderUtils().initRenderEngine();
        context.renderUtils().fillColor(pBufferSource, (class_2586)pBlockEntity, 0xFF000000 | pBlockEntity.getColor() & 0xFFFFFF, pPoseStack, 2.5f, 4.75f, 0.0f, (float)(pBlockEntity.getXSizeScaled() * 16 - 5), 0.25f, (class_2350)pBlockEntity.method_11010().method_11654((class_2769)class_2383.field_11177), pPackedLight);
        float uv = 0.00390625f;
        float y = 5.0f;
        if (this.notInService(pBlockEntity)) {
            return;
        }
        if (this.state != JourneyListener.State.BEFORE_NEXT_STOP || this.nextConnections == null || this.nextConnections.isEmpty()) {
            float tempH = 1.7142859f;
            context.renderUtils().renderTexture(TEXTURE, pBufferSource, (class_2586)pBlockEntity, pPoseStack, false, 8.0f, y, 0.0f, 1.0f, tempH, uv * 226.0f, uv * 2.0f, uv * 233.0f, uv * 14.0f, (class_2350)pBlockEntity.method_11010().method_11654((class_2769)class_2383.field_11177), -1, pPackedLight);
            y += tempH;
            for (int i = 0; i < 2 && i < pBlockEntity.getTrainData().stopovers().size(); ++i) {
                context.renderUtils().renderTexture(TEXTURE, pBufferSource, (class_2586)pBlockEntity, pPoseStack, false, 8.0f, y, 0.0f, 1.0f, 2.0f, uv * 226.0f, uv * 14.0f * 1.0f, uv * 233.0f, uv * 28.0f, (class_2350)pBlockEntity.method_11010().method_11654((class_2769)class_2383.field_11177), -1, pPackedLight);
                y += 2.0f;
            }
            if (pBlockEntity.getTrainData().predictions().size() > 1) {
                context.renderUtils().renderTexture(TEXTURE, pBufferSource, (class_2586)pBlockEntity, pPoseStack, false, 8.0f, y, 0.0f, 1.0f, 2.0f, uv * 226.0f, uv * 14.0f * 2.0f, uv * 233.0f, uv * 42.0f, (class_2350)pBlockEntity.method_11010().method_11654((class_2769)class_2383.field_11177), -1, pPackedLight);
            }
        }
        DeparturePrediction.TrainExitSide side = (DeparturePrediction.TrainExitSide)((Object)pBlockEntity.relativeExitDirection.get());
        if (backSide.booleanValue()) {
            side = side.getOpposite();
        }
        if (this.state != JourneyListener.State.WHILE_TRAVELING && side != DeparturePrediction.TrainExitSide.UNKNOWN) {
            context.renderUtils().renderTexture(ModGuiIcons.ICON_LOCATION, pBufferSource, (class_2586)pBlockEntity, pPoseStack, false, (float)(pBlockEntity.getXSizeScaled() * 16) - 3.0f - 2.0f, 2.25f, 0.0f, 2.5f, 2.5f, uv * (float)(side == DeparturePrediction.TrainExitSide.RIGHT ? ModGuiIcons.ARROW_RIGHT : ModGuiIcons.ARROW_LEFT).getU(), uv * (float)(side == DeparturePrediction.TrainExitSide.RIGHT ? ModGuiIcons.ARROW_RIGHT : ModGuiIcons.ARROW_LEFT).getV(), uv * (float)((side == DeparturePrediction.TrainExitSide.RIGHT ? ModGuiIcons.ARROW_RIGHT : ModGuiIcons.ARROW_LEFT).getU() + 16), uv * (float)((side == DeparturePrediction.TrainExitSide.RIGHT ? ModGuiIcons.ARROW_RIGHT : ModGuiIcons.ARROW_LEFT).getV() + 16), (class_2350)pBlockEntity.method_11010().method_11654((class_2769)class_2383.field_11177), 0xFF000000 | pBlockEntity.getColor(), pPackedLight);
        }
    }

    private boolean notInService(AdvancedDisplayBlockEntity blockEntity) {
        Optional<DeparturePrediction.SimpleDeparturePrediction> optPred = blockEntity.getTrainData().getNextStop();
        return !optPred.isPresent() || optPred.get().stationTagName() == null || optPred.get().stationTagName().isBlank();
    }

    private float generateTimeLabel(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        float arrowOffset = this.state != JourneyListener.State.WHILE_TRAVELING && blockEntity.relativeExitDirection.get() != DeparturePrediction.TrainExitSide.UNKNOWN ? 4 : 0;
        float maxWidth = (float)(blockEntity.getXSizeScaled() * 16) - arrowOffset;
        class_5250 line = TextUtils.text((String)TimeUtils.parseTime((long)((int)(blockEntity.method_10997().method_8532() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))).method_27692(class_124.field_1067);
        float rawTextWidth = Math.min((float)parent.getFontUtils().font.method_27525((class_5348)line), maxWidth);
        float textWidth = rawTextWidth * 0.25f;
        this.timeLabel = parent.carriageIndexLabel = new BERText(parent.getFontUtils(), (class_2561)(textWidth > (float)parent.getFontUtils().font.method_27525((class_5348)line) * 0.1f ? line : TextUtils.empty()), 0.0f).withIsCentered(false).withMaxWidth(textWidth, true).withStretchScale(0.1f, 0.25f).withColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF).withPredefinedTextTransformation(new BERText.TextTransformation((float)(blockEntity.getXSizeScaled() * 16) - 2.5f - textWidth - (float)(this.state != JourneyListener.State.WHILE_TRAVELING && blockEntity.relativeExitDirection.get() != DeparturePrediction.TrainExitSide.UNKNOWN ? 4 : 0), 2.5f, 0.0f, 1.0f, 0.25f)).build();
        return textWidth;
    }

    private void generateTitleBar(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason) {
        byte displayWidth = blockEntity.getXSizeScaled();
        float maxWidth = displayWidth * 16 - 6 - (this.state != JourneyListener.State.WHILE_TRAVELING && blockEntity.relativeExitDirection.get() != DeparturePrediction.TrainExitSide.UNKNOWN ? 4 : 0);
        float timeWidth = this.generateTimeLabel(level, pos, state, blockEntity, parent);
        class_5250 line = TextUtils.text((String)blockEntity.getTrainData().trainName()).method_27692(class_124.field_1067);
        if (blockEntity.getTrainData().getNextStop().isPresent()) {
            switch (this.state) {
                case BEFORE_NEXT_STOP: {
                    line = ELanguage.translate(keyNextStop, blockEntity.getTrainData().getNextStop().get().stationTagName());
                    break;
                }
                case WHILE_NEXT_STOP: {
                    line = ELanguage.translate(blockEntity.getTrainData().trainName() + " " + blockEntity.getTrainData().getNextStop().get().stationTagName()).method_27692(class_124.field_1067);
                    break;
                }
            }
        }
        if (this.titleLabel != null && line.getString().equals(this.titleLabel.getCurrentText().getString()) && reason == IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED) {
            return;
        }
        this.titleLabel = new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(maxWidth - timeWidth - 1.0f, true).withStretchScale(0.15f, 0.25f).withStencil(0.0f, maxWidth - timeWidth - 1.0f).withCanScroll(true, 0.5f).withColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, 2.5f, 0.0f, 1.0f, 0.25f)).build();
    }

    private void updateOverview(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        byte displayWidth = blockEntity.getXSizeScaled();
        if (this.notInService(blockEntity) || !blockEntity.getTrainData().getNextStop().isPresent()) {
            return;
        }
        float y = 5.75f;
        DeparturePrediction.SimpleDeparturePrediction pred = blockEntity.getTrainData().getNextStop().get();
        float maxWidth = (float)(displayWidth * 16) - 12.5f;
        int rawTime = (int)(blockEntity.getLastRefreshedTime() % 24000L + (long)pred.departureTicks() + 6000L);
        class_5250 line = TextUtils.text((String)TimeUtils.parseTime((long)(rawTime - rawTime % (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())));
        parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(4.0f, true).withStretchScale(0.08f, 0.14f).withStencil(0.0f, 7.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, y + 0.3f, 0.0f, 1.0f, 0.14f)).build());
        line = TextUtils.text((String)pred.stationTagName()).method_27692(class_124.field_1067);
        parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(maxWidth, true).withStretchScale(0.15f, 0.2f).withStencil(0.0f, maxWidth).withCanScroll(true, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(10.0f, y, 0.0f, 1.0f, 0.2f)).build());
        y += 2.0f;
        for (int i = 0; i < 2 && i < blockEntity.getTrainData().stopovers().size(); ++i) {
            pred = blockEntity.getTrainData().stopovers().get(i);
            rawTime = (int)(blockEntity.getLastRefreshedTime() % 24000L + (long)pred.departureTicks() + 6000L);
            line = TextUtils.text((String)TimeUtils.parseTime((long)(rawTime - rawTime % (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())));
            parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(4.0f, true).withStretchScale(0.08f, 0.14f).withStencil(0.0f, 7.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, y + 0.1f, 0.0f, 1.0f, 0.14f)).build());
            line = TextUtils.text((String)pred.stationTagName());
            parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(maxWidth, true).withStretchScale(0.15f, 0.16f).withStencil(0.0f, maxWidth).withCanScroll(true, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(10.0f, y + 0.2f, 0.0f, 1.0f, 0.16f)).build());
            y += 2.0f;
        }
        if (blockEntity.getTrainData().predictions().size() <= 1) {
            return;
        }
        pred = blockEntity.getTrainData().getLastStop().get();
        rawTime = (int)(blockEntity.getLastRefreshedTime() % 24000L + (long)pred.departureTicks() + 6000L);
        line = TextUtils.text((String)TimeUtils.parseTime((long)(rawTime - rawTime % (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())));
        parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(4.0f, true).withStretchScale(0.08f, 0.14f).withStencil(0.0f, 7.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, y + 0.3f, 0.0f, 1.0f, 0.14f)).build());
        line = TextUtils.text((String)pred.stationTagName()).method_27692(class_124.field_1067);
        parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(maxWidth, true).withStretchScale(0.2f, 0.2f).withStencil(0.0f, maxWidth).withCanScroll(true, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(10.0f, y, 0.0f, 1.0f, 0.2f)).build());
    }

    private void updateNextConnections(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        byte displayWidth = blockEntity.getXSizeScaled();
        if (this.notInService(blockEntity)) {
            return;
        }
        float y = 5.75f;
        float maxWidth = displayWidth * 16 - 3;
        class_5250 ln = TextUtils.text((String)this.generatePageIndexString());
        float rawTextWidth = Math.min((float)parent.getFontUtils().font.method_27525((class_5348)ln) * 0.2f, maxWidth - 16.0f);
        parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)ln, 0.0f).withIsCentered(false).withMaxWidth(maxWidth - 16.0f, true).withStretchScale(0.2f, 0.2f).withStencil(0.0f, maxWidth - 16.0f).withCanScroll(false, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(maxWidth - rawTextWidth - 0.25f, y - 0.2f, 0.0f, 1.0f, 0.2f)).build());
        parent.labels.add(new BERText(parent.getFontUtils(), textNextConnections, 0.0f).withIsCentered(false).withMaxWidth(maxWidth - 6.0f - rawTextWidth, true).withStretchScale(0.1f, 0.15f).withStencil(0.0f, maxWidth - 6.0f - rawTextWidth).withCanScroll(true, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, y, 0.0f, 1.0f, 0.15f)).build());
        y += 2.0f;
        if (this.nextConnections == null) {
            return;
        }
        for (int i = this.nextConnectionsPage * 3; i < (this.nextConnectionsPage + 1) * 3 && i < this.nextConnections.size(); ++i) {
            SimpleTrainConnection connection = this.nextConnections.get(i);
            int rawTime = (int)(this.nextConnectionsRefreshTime % 24000L + (long)connection.ticks() + 6000L);
            class_5250 line = TextUtils.text((String)TimeUtils.parseTime((long)(rawTime - rawTime % (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())));
            parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(4.0f, true).withStretchScale(0.08f, 0.14f).withStencil(0.0f, 4.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(4.0f, y + 0.1f, 0.0f, 1.0f, 0.14f)).build());
            line = TextUtils.text((String)connection.trainName());
            parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(5.0f, true).withStretchScale(0.1f, 0.16f).withStencil(0.0f, 5.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(8.5f, y, 0.0f, 1.0f, 0.16f)).build());
            line = TextUtils.text((String)connection.stationDetails().platform());
            rawTextWidth = Math.min((float)parent.getFontUtils().font.method_27525((class_5348)line) * 0.14f, maxWidth - 16.0f);
            parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(maxWidth - 16.0f, true).withStretchScale(0.14f, 0.16f).withStencil(0.0f, maxWidth - 16.0f).withCanScroll(false, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(maxWidth - rawTextWidth, y, 0.0f, 1.0f, 0.16f)).build());
            line = TextUtils.text((String)connection.scheduleTitle());
            parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(false).withMaxWidth(maxWidth - 17.0f - rawTextWidth, true).withStretchScale(0.1f, 0.16f).withStencil(0.0f, maxWidth - 17.0f - rawTextWidth).withCanScroll(true, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(14.0f, y, 0.0f, 1.0f, 0.16f)).build());
            y += 2.0f;
        }
    }

    private String generatePageIndexString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.nextConnectionsPage; ++i) {
            sb.append(" \u25a1");
        }
        sb.append(" \u25a0");
        for (i = this.nextConnectionsPage + 1; i < this.nextConnectionsMaxPage; ++i) {
            sb.append(" \u25a1");
        }
        return sb.toString();
    }
}

