/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public abstract class AbstractBlacklistScreen
extends DLScreen {
    private static final class_2960 GUI = new class_2960("createrailwaysnavigator", "textures/gui/settings.png");
    public static final class_2960 WIDGETS = new class_2960("createrailwaysnavigator", "textures/gui/settings_widgets.png");
    private static final int GUI_WIDTH = 255;
    private static final int GUI_HEIGHT = 247;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final int ENTRIES_START_Y_OFFSET = 10;
    private static final int ENTRY_HEIGHT = 20;
    private final int AREA_X = 16;
    private final int AREA_Y = 72;
    private final int AREA_W = 220;
    private final int AREA_H = 138;
    private int guiLeft;
    private int guiTop;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private final class_1937 level;
    private final class_327 shadowlessFont;
    private final class_437 lastScreen;
    private boolean initialized;
    private DLCreateIconButton backButton;
    private DLEditBox newEntryBox;
    private DLEditBox searchBox;
    private GuiAreaDefinition addButton;
    private ModStationSuggestions suggestions;
    private final Map<String, GuiAreaDefinition> blacklistEntryButton = new HashMap<String, GuiAreaDefinition>();
    private final Map<String, GuiAreaDefinition> entryAreas = new HashMap<String, GuiAreaDefinition>();
    private final class_5250 tooltipAdd = TextUtils.translate((String)"gui.createrailwaysnavigator.blacklist.add.tooltip");
    private final class_5250 tooltipRemove = TextUtils.translate((String)"gui.createrailwaysnavigator.blacklist.delete.tooltip");

    public AbstractBlacklistScreen(class_1937 level, class_437 lastScreen, class_2561 title) {
        super(title);
        this.level = level;
        this.lastScreen = lastScreen;
        this.shadowlessFont = new NoShadowFontWrapper(class_310.method_1551().field_1772);
    }

    protected abstract Collection<String> getSuggestions();

    protected abstract boolean checkIsBlacklisted(String var1);

    protected abstract String[] getBlacklistedNames(String var1);

    protected abstract void addToBlacklist(String var1, Runnable var2);

    protected abstract void removeFromBlacklist(String var1, Runnable var2);

    protected void method_25426() {
        this.initialized = false;
        super.method_25426();
        this.guiLeft = this.field_22789 / 2 - 127;
        this.guiTop = this.field_22790 / 2 - 123;
        this.backButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 21, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_CONFIG_BACK){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                AbstractBlacklistScreen.this.method_25419();
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)Constants.TOOLTIP_GO_BACK).assignedTo((class_339)this.backButton));
        this.newEntryBox = this.addEditBox(this.guiLeft + 16 + 5 + 35, this.guiTop + 72 - 28 + 10, 129, 12, "", (class_2561)TextUtils.empty(), false, s -> this.updateEditorSubwidgets(this.newEntryBox), (box, focus) -> {
            if (!focus.booleanValue()) {
                this.clearSuggestions();
            }
        }, null);
        this.newEntryBox.method_1880(25);
        this.newEntryBox.method_1868(0xFFFFFF);
        this.addButton = new GuiAreaDefinition(this.guiLeft + 16 + 165 + 10, this.guiTop + 72 - 28 + 6, 16, 16);
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipAdd).assignedTo(this.addButton));
        this.searchBox = this.addEditBox(this.guiLeft + 16 + 1, this.guiTop + 16 + 1, 218, 16, "", Constants.TEXT_SEARCH, true, s -> this.initStationDeleteButtons(), null, null);
        this.initialized = true;
        this.initStationDeleteButtons();
    }

    private void initStationDeleteButtons() {
        if (!this.initialized) {
            return;
        }
        this.blacklistEntryButton.clear();
        this.entryAreas.clear();
        String[] names = this.getBlacklistedNames(this.searchBox.method_1882());
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            this.blacklistEntryButton.put(name, new GuiAreaDefinition(this.guiLeft + 16 + 165 + 10, this.guiTop + 72 + i * 20 + 2, 16, 16));
            this.entryAreas.put(name, new GuiAreaDefinition(this.guiLeft + 16 + 35, this.guiTop + 72 + i * 20 + 2, 129, 16));
        }
    }

    private void addToBlacklistInternal() {
        String value = this.newEntryBox.method_1882();
        this.newEntryBox.method_1852("");
        if (value.isBlank()) {
            return;
        }
        this.addToBlacklist(value, this::initStationDeleteButtons);
    }

    private int getMaxScrollHeight() {
        return 10 + 20 * this.getBlacklistedNames(this.searchBox.method_1882()).length;
    }

    private void clearSuggestions() {
        if (this.suggestions != null) {
            this.suggestions.getEditBox().method_1887("");
        }
        this.suggestions = null;
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        if (!this.initialized) {
            return;
        }
        this.clearSuggestions();
        this.suggestions = new ModStationSuggestions(this.field_22787, (class_437)this, (class_342)field, this.field_22787.field_1772, this.getViableStations(field), field.method_25364() + 2 + field.method_46427());
        this.suggestions.setAllowSuggestions(true);
        this.suggestions.updateCommandInfo();
    }

    private List<String> getViableStations(DLEditBox field) {
        return this.getSuggestions().stream().distinct().filter(x -> !this.checkIsBlacklisted((String)x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    public void method_25393() {
        super.method_25393();
        this.scroll.tickChaser();
        float scrollMax = this.getMaxScrollHeight();
        if (this.scroll.getValue() > 0.0f && this.scroll.getValue() > scrollMax) {
            this.scroll.chase((double)Math.max(0.0f, scrollMax), (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        if (this.suggestions != null) {
            this.suggestions.tick();
            if (!this.newEntryBox.method_20315()) {
                this.clearSuggestions();
            }
        }
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = class_310.method_1551().method_1488();
        float scrollOffset = -this.scroll.getValue(pPartialTick);
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((class_2960)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)255, (int)247);
        GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72 - 28), (int)0, (int)110, (int)200, (int)28);
        GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 35), (int)(this.guiTop + 72 - 28 + 5), (int)0, (int)92, (int)139, (int)18);
        GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)this.addButton.getX(), (int)this.addButton.getY(), (int)200, (int)16, (int)16, (int)16);
        if (this.addButton.isInBounds((double)pMouseX, (double)pMouseY)) {
            GuiUtils.fill((Graphics)graphics, (int)this.addButton.getX(), (int)this.addButton.getY(), (int)this.addButton.getWidth(), (int)this.addButton.getHeight(), (int)0x1AFFFFFF);
        }
        GuiUtils.enableScissor((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 72), (int)220, (int)138);
        graphics.poseStack().method_46416(0.0f, scrollOffset, 0.0f);
        String[] blacklist = this.getBlacklistedNames(this.searchBox.method_1882());
        for (int i = 0; i < blacklist.length; ++i) {
            GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72 + i * 20), (int)0, (int)4, (int)200, (int)20);
        }
        GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72 + blacklist.length * 20), (int)0, (int)23, (int)200, (int)3);
        GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72 + blacklist.length * 20 + 3), (int)0, (int)46, (int)200, (int)2);
        for (GuiAreaDefinition def : this.blacklistEntryButton.values()) {
            GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)def.getX(), (int)def.getY(), (int)232, (int)0, (int)16, (int)16);
            if (!def.isInBounds((double)pMouseX, (double)((float)pMouseY - scrollOffset))) continue;
            GuiUtils.fill((Graphics)graphics, (int)def.getX(), (int)def.getY(), (int)def.getWidth(), (int)def.getHeight(), (int)0x1AFFFFFF);
        }
        for (int i = 0; i < blacklist.length; ++i) {
            class_5250 name = TextUtils.text((String)blacklist[i]);
            int maxTextWidth = 129;
            if (this.shadowlessFont.method_27525((class_5348)name) > maxTextWidth) {
                name = TextUtils.text((String)this.shadowlessFont.method_1714((class_5348)name, maxTextWidth).getString()).method_10852(Constants.ELLIPSIS_STRING);
            }
            GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.guiLeft + 16 + 40), (int)(this.guiTop + 72 + i * 20 + 6), (class_5348)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.disableScissor((Graphics)graphics);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 72 - 38), (int)0, (int)220, (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 72 + 138 - 10), (int)0, (int)220, (int)10, (int)0, (int)0x77000000);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72), (int)0, (int)200, (int)10, (int)0x77000000, (int)0);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        double maxHeight = this.getMaxScrollHeight();
        double aH = 139.0;
        if (aH / maxHeight < 1.0) {
            int scrollerHeight = Math.max(10, (int)(aH * (aH / maxHeight)));
            int startY = this.guiTop + 72 + (int)(138.0 * ((double)Math.abs(scrollOffset) / maxHeight));
            GuiUtils.fill((Graphics)graphics, (int)(this.guiLeft + 16 + 220 - 3), (int)startY, (int)3, (int)scrollerHeight, (int)Integer.MAX_VALUE);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.guiLeft + 19), (int)(this.guiTop + 4), (class_5348)this.field_22785, (int)-11579569, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.method_8532() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.guiLeft + 255 - 22 - this.shadowlessFont.method_1727(timeString)), (int)(this.guiTop + 4), (class_5348)TextUtils.text((String)timeString), (int)-11579569, (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.suggestions != null) {
            graphics.poseStack().method_22903();
            graphics.poseStack().method_46416(0.0f, 0.0f, 500.0f);
            this.suggestions.render(graphics.graphics(), mouseX, mouseY);
            graphics.poseStack().method_22909();
        }
        float scrollOffset = this.scroll.getValue(partialTick);
        if (mouseX > this.guiLeft + 16 && mouseX < this.guiLeft + 16 + 220 && mouseY > this.guiTop + 72 && mouseY < this.guiTop + 72 + 138) {
            for (Map.Entry<String, GuiAreaDefinition> entry : this.blacklistEntryButton.entrySet()) {
                if (GuiUtils.renderTooltipWithOffset((class_437)this, (GuiAreaDefinition)entry.getValue(), List.of(this.tooltipRemove), (int)this.field_22789, (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)((int)scrollOffset))) break;
            }
            for (Map.Entry<String, GuiAreaDefinition> entry : this.entryAreas.entrySet()) {
                if (this.shadowlessFont.method_1727(entry.getKey()) > 129 && GuiUtils.renderTooltipAt((class_437)this, (GuiAreaDefinition)entry.getValue(), List.of(TextUtils.text((String)entry.getKey())), (int)this.field_22789, (Graphics)graphics, (int)(entry.getValue().getLeft() + 1), (int)((int)((float)entry.getValue().getTop() - scrollOffset)), (int)mouseX, (int)mouseY, (int)0, (int)((int)scrollOffset))) break;
            }
        }
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.suggestions != null && this.suggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            GuiUtils.playButtonSound();
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        float scrollOffset = this.scroll.getValue();
        if (this.addButton.isInBounds(pMouseX, pMouseY) && !this.newEntryBox.method_1882().isBlank()) {
            this.addToBlacklistInternal();
            GuiUtils.playButtonSound();
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        if (pMouseX > (double)(this.guiLeft + 16) && pMouseX < (double)(this.guiLeft + 16 + 220) && pMouseY > (double)(this.guiTop + 72) && pMouseY < (double)(this.guiTop + 72 + 138) && this.blacklistEntryButton.values().stream().anyMatch(x -> x.isInBounds(pMouseX, pMouseY + (double)scrollOffset))) {
            for (Map.Entry<String, GuiAreaDefinition> entry : this.blacklistEntryButton.entrySet()) {
                if (!entry.getValue().isInBounds(pMouseX, pMouseY + (double)scrollOffset)) continue;
                this.removeFromBlacklist(entry.getKey(), this::initStationDeleteButtons);
                GuiUtils.playButtonSound();
                return super.method_25402(pMouseX, pMouseY + (double)scrollOffset, pButton);
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.suggestions != null && this.suggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.suggestions != null && this.suggestions.mouseScrolled(pMouseX, pMouseY, class_3532.method_15350((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -138 + this.getMaxScrollHeight();
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = class_3532.method_15363((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.method_25401(pMouseX, pMouseY, pDelta);
    }
}

