/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.screen.AbstractEntryListSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.AbstractEntryListOptionWidget;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.data.AliasName;
import de.mrjulsen.crn.data.ClientTrainStationSnapshot;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class AliasEntryWidget
extends AbstractEntryListOptionWidget {
    private static final class_2960 GUI_WIDGETS = new class_2960("createrailwaysnavigator", "textures/gui/settings_widgets.png");
    public static final int WIDTH = 200;
    public static final int HEIGHT = 48;
    private static final int STATION_ENTRY_HEIGHT = 20;
    private final AbstractEntryListSettingsScreen<TrainStationAlias, AliasEntryWidget> parent;
    private final class_327 shadowlessFont;
    private final class_310 minecraft;
    private final Runnable onUpdate;
    private TrainStationAlias alias;
    private boolean expanded = false;
    private final DLEditBox titleBox;
    private final DLEditBox newEntryBox;
    private final DLEditBox newEntryPlatformBox;
    private final Map<String, GuiAreaDefinition> removeStationButtons = new HashMap<String, GuiAreaDefinition>();
    private final Map<String, GuiAreaDefinition> stationInfoAreas = new HashMap<String, GuiAreaDefinition>();
    private final Map<String, GuiAreaDefinition> stationNameAreas = new HashMap<String, GuiAreaDefinition>();
    private GuiAreaDefinition titleBarArea;
    private GuiAreaDefinition deleteButton;
    private GuiAreaDefinition expandButton;
    private GuiAreaDefinition addButton;
    private ModStationSuggestions destinationSuggestions;
    private String selectedStationName = null;
    private final DLEditBox editAliasPlatform;
    private final class_5250 tooltipDeleteAlias = TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.delete_alias.tooltip");
    private final class_5250 tooltipDeleteStation = TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.delete_station.tooltip");
    private final class_5250 tooltipAddStation = TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.add_station.tooltip");
    private final class_5250 tooltipStationName = TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.hint.station_name");
    private final class_5250 tooltipPlatform = TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.hint.platform");

    public AliasEntryWidget(AbstractEntryListSettingsScreen<TrainStationAlias, AliasEntryWidget> parent, int pX, int pY, TrainStationAlias alias, Runnable onUpdate, boolean expanded) {
        super(pX, pY, 200, 48);
        class_310 minecraft = class_310.method_1551();
        this.shadowlessFont = new NoShadowFontWrapper(minecraft.field_1772);
        this.minecraft = class_310.method_1551();
        this.parent = parent;
        this.alias = alias;
        this.expanded = expanded;
        this.onUpdate = onUpdate;
        this.titleBox = new DLEditBox(minecraft.field_1772, pX + 30, pY + 10, 129, 12, (class_2561)TextUtils.empty());
        this.titleBox.method_1858(false);
        this.titleBox.method_1880(32);
        this.titleBox.method_1868(0xFFFFFF);
        this.titleBox.method_1852(alias.getAliasName().get());
        this.titleBox.withOnFocusChanged((box, focused) -> {
            if (!focused.booleanValue() && !this.setAliasName(box.method_1882())) {
                this.titleBox.method_1852(alias.getAliasName().get());
            }
        });
        this.titleBox.field_22764 = expanded;
        this.addRenderableWidget((class_364)this.titleBox);
        this.newEntryBox = new DLEditBox(minecraft.field_1772, pX + 30, pY + 30, 95, 12, (class_2561)TextUtils.empty());
        this.newEntryBox.method_1858(false);
        this.newEntryBox.method_1880(32);
        this.newEntryBox.method_1868(0xFFFFFF);
        this.newEntryBox.field_22764 = expanded;
        this.newEntryBox.method_1863(x -> this.updateEditorSubwidgets(this.newEntryBox));
        this.addRenderableWidget((class_364)this.newEntryBox);
        this.newEntryPlatformBox = new DLEditBox(minecraft.field_1772, pX + 134, pY + 30, 25, 12, (class_2561)TextUtils.empty());
        this.newEntryPlatformBox.method_1858(false);
        this.newEntryPlatformBox.method_1880(10);
        this.newEntryPlatformBox.method_1868(0xFFFFFF);
        this.newEntryPlatformBox.field_22764 = expanded;
        this.addRenderableWidget((class_364)this.newEntryPlatformBox);
        this.editAliasPlatform = new DLEditBox(minecraft.field_1772, pX + 134, 0, 33, 14, (class_2561)TextUtils.empty());
        this.editAliasPlatform.method_1858(true);
        this.editAliasPlatform.method_1880(10);
        this.editAliasPlatform.method_1868(0xFFFFFF);
        this.editAliasPlatform.field_22764 = false;
        this.editAliasPlatform.withOnFocusChanged((box, focus) -> {
            if (!focus.booleanValue()) {
                if (this.selectedStationName != null && !this.selectedStationName.isBlank()) {
                    alias.updateInfoForStation(this.selectedStationName, new TrainStationAlias.StationInfo(box.method_1882()));
                    alias.updateLastEdited(minecraft.field_1724.method_5477().getString());
                    GlobalSettingsManager.getInstance().getSettingsData().updateAlias(alias.getAliasName(), alias, () -> {
                        onUpdate.run();
                        this.initStationDeleteButtons();
                    });
                }
                box.field_22764 = false;
                this.selectedStationName = null;
                box.method_1852("");
            }
        });
        this.addRenderableWidget((class_364)this.editAliasPlatform);
        this.setYPos(pY);
    }

    public TrainStationAlias getAlias() {
        return this.alias;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setYPos(int y) {
        this.y = y;
        this.deleteButton = new GuiAreaDefinition(this.x + 165, y + 6, 16, 16);
        this.expandButton = new GuiAreaDefinition(this.x + 182, y + 6, 16, 16);
        this.addButton = new GuiAreaDefinition(this.x + 165, y + 26 + this.alias.getAllStationNames().size() * 20 + 2, 16, 16);
        this.titleBox.method_46419(y + 10);
        this.initStationDeleteButtons();
    }

    private void initStationDeleteButtons() {
        this.removeStationButtons.clear();
        this.stationInfoAreas.clear();
        this.stationNameAreas.clear();
        String[] names = (String[])this.alias.getAllStationNames().toArray(String[]::new);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            this.removeStationButtons.put(name, new GuiAreaDefinition(this.x + 165, this.y + 26 + i * 20 + 2, 16, 16));
            this.stationNameAreas.put(name, new GuiAreaDefinition(this.x + 25, this.y + 26 + i * 20 + 2, 104, 16));
            this.stationInfoAreas.put(name, new GuiAreaDefinition(this.x + 129, this.y + 26 + i * 20 + 2, 35, 16));
        }
        this.titleBarArea = new GuiAreaDefinition(this.x + 25, this.y + 6, 129, 16);
    }

    @Override
    public void method_1865() {
        super.method_1865();
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.tick();
            if (!this.newEntryBox.method_20315()) {
                this.clearSuggestions();
            }
        }
    }

    private void toggleExpanded() {
        this.titleBox.field_22764 = this.expanded = !this.expanded;
        this.newEntryBox.field_22764 = this.expanded;
        this.newEntryPlatformBox.field_22764 = this.expanded;
    }

    private void deleteAlias() {
        GlobalSettingsManager.getInstance().getSettingsData().unregisterAlias(this.alias, this.onUpdate);
    }

    private void addStation(String name, TrainStationAlias.StationInfo info) {
        AliasName prevName = this.alias.getAliasName();
        if (ClientTrainStationSnapshot.getInstance().getAllTrainStations().stream().noneMatch(x -> x.equals(name)) || this.newEntryPlatformBox.method_1882().isBlank()) {
            return;
        }
        this.alias.add(name, info);
        this.alias.updateLastEdited(this.minecraft.field_1724.method_5477().getString());
        GlobalSettingsManager.getInstance().getSettingsData().updateAlias(prevName, this.alias, () -> {
            this.onUpdate.run();
            this.initStationDeleteButtons();
        });
        this.newEntryBox.method_1852("");
        this.newEntryBox.method_25365(false);
        this.newEntryPlatformBox.method_1852("");
        this.newEntryPlatformBox.method_25365(false);
    }

    private boolean setAliasName(String name) {
        AliasName prevName = this.alias.getAliasName();
        if (name == null || name.isBlank()) {
            return false;
        }
        if (GlobalSettingsManager.getInstance().getSettingsData().getAliasList().stream().anyMatch(x -> x.getAliasName().get().toLowerCase().equals(name.toLowerCase()))) {
            return false;
        }
        this.alias.setName(AliasName.of(name));
        this.alias.updateLastEdited(this.minecraft.field_1724.method_5477().getString());
        GlobalSettingsManager.getInstance().getSettingsData().updateAlias(prevName, this.alias, this.onUpdate);
        return true;
    }

    public int getHeight() {
        return this.height;
    }

    private void removeStation(String name) {
        AliasName prevName = this.alias.getAliasName();
        this.alias.remove(name);
        this.alias.updateLastEdited(this.minecraft.field_1724.method_5477().getString());
        GlobalSettingsManager.getInstance().getSettingsData().updateAlias(prevName, this.alias, () -> {
            this.onUpdate.run();
            this.initStationDeleteButtons();
        });
        this.initStationDeleteButtons();
        this.onUpdate.run();
    }

    @Override
    public int calcHeight() {
        this.height = this.expanded ? 20 * this.alias.getAllStationNames().size() + 50 : 48;
        return this.height;
    }

    private void editStationInfo(String stationName, GuiAreaDefinition buttonArea) {
        this.selectedStationName = stationName;
        this.editAliasPlatform.method_1852(this.alias.getInfoForStation(this.selectedStationName).platform());
        this.editAliasPlatform.method_46421(buttonArea.getLeft() + 1);
        this.editAliasPlatform.method_46419(buttonArea.getTop() + 1);
        this.editAliasPlatform.field_22764 = true;
        this.editAliasPlatform.method_25365(true);
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        block12: {
            block15: {
                block14: {
                    block13: {
                        block11: {
                            GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)this.x, (int)this.y, (int)0, (int)0, (int)200, (int)48);
                            GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)this.deleteButton.getX(), (int)this.deleteButton.getY(), (int)232, (int)0, (int)16, (int)16);
                            GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)this.expandButton.getX(), (int)this.expandButton.getY(), (int)(this.expanded ? 216 : 200), (int)0, (int)16, (int)16);
                            if (this.expanded) {
                                Map<String, TrainStationAlias.StationInfo> names = this.alias.getAllStations();
                                GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)(this.x + 25), (int)(this.y + 5), (int)0, (int)92, (int)139, (int)18);
                                this.newEntryBox.method_46419(this.y + 26 + names.size() * 20 + 6);
                                this.newEntryPlatformBox.method_46419(this.y + 26 + names.size() * 20 + 6);
                                for (int i = 0; i < names.size(); ++i) {
                                    GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)this.x, (int)(this.y + 26 + i * 20), (int)0, (int)48, (int)200, (int)20);
                                }
                                GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)this.x, (int)(this.y + 26 + names.size() * 20), (int)0, (int)68, (int)200, (int)24);
                                GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)(this.x + 25), (int)(this.y + 26 + names.size() * 20 + 1), (int)0, (int)92, (int)103, (int)18);
                                GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)(this.x + 25 + 102), (int)(this.y + 26 + names.size() * 20 + 1), (int)138, (int)92, (int)1, (int)18);
                                GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)(this.x + 129), (int)(this.y + 26 + names.size() * 20 + 1), (int)0, (int)92, (int)35, (int)18);
                                GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)(this.x + 129 + 34), (int)(this.y + 26 + names.size() * 20 + 1), (int)138, (int)92, (int)1, (int)18);
                                GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)this.addButton.getX(), (int)this.addButton.getY(), (int)200, (int)16, (int)16, (int)16);
                                for (GuiAreaDefinition guiAreaDefinition : this.removeStationButtons.values()) {
                                    GuiUtils.drawTexture((class_2960)GUI_WIDGETS, (Graphics)graphics, (int)guiAreaDefinition.getX(), (int)guiAreaDefinition.getY(), (int)232, (int)0, (int)16, (int)16);
                                }
                                int i = 0;
                                for (Map.Entry<String, TrainStationAlias.StationInfo> entry : names.entrySet()) {
                                    class_5250 name = TextUtils.text((String)entry.getKey());
                                    int maxTextWidth = 92;
                                    if (this.shadowlessFont.method_27525((class_5348)name) > maxTextWidth) {
                                        name = TextUtils.text((String)this.shadowlessFont.method_1714((class_5348)name, maxTextWidth).getString()).method_10852(Constants.ELLIPSIS_STRING);
                                    }
                                    GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.x + 30), (int)(this.y + 26 + i * 20 + 6), (class_5348)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
                                    TrainStationAlias.StationInfo info = entry.getValue();
                                    class_5250 platform = TextUtils.text((String)info.platform());
                                    int maxPlatformWidth = 28;
                                    if (this.shadowlessFont.method_27525((class_5348)platform) > maxPlatformWidth) {
                                        platform = TextUtils.text((String)this.shadowlessFont.method_1714((class_5348)platform, maxPlatformWidth - 3).getString()).method_10852(Constants.ELLIPSIS_STRING);
                                    }
                                    int platformTextWidth = this.shadowlessFont.method_27525((class_5348)platform);
                                    GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.x + 30 + 130 - platformTextWidth), (int)(this.y + 26 + i * 20 + 6), (class_5348)platform, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
                                    ++i;
                                }
                            } else {
                                class_5250 name = TextUtils.text((String)this.alias.getAliasName().get());
                                int maxTextWidth = 129;
                                if (this.shadowlessFont.method_27525((class_5348)name) > maxTextWidth) {
                                    name = TextUtils.text((String)this.shadowlessFont.method_1714((class_5348)name, maxTextWidth).getString()).method_10852(Constants.ELLIPSIS_STRING);
                                }
                                GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.x + 30), (int)(this.y + 10), (class_5348)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
                                graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
                                GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(this.x + 5) / 0.75f)), (int)((int)((float)(this.y + 30) / 0.75f)), (class_5348)TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.summary", (Object[])new Object[]{this.alias.getAllStationNames().size()}), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
                                if (this.alias.getLastEditorName() != null && !this.alias.getLastEditorName().isBlank()) {
                                    GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(this.x + 5) / 0.75f)), (int)((int)((float)(this.y + 38) / 0.75f)), (class_5348)TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.editor", (Object[])new Object[]{this.alias.getLastEditorName(), this.alias.getLastEditedTimeFormatted()}), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
                                }
                                float f = 1.3333334f;
                                graphics.poseStack().method_22905(f, f, f);
                            }
                            super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
                            if (!this.deleteButton.isInBounds((double)pMouseX, (double)pMouseY)) break block11;
                            GuiUtils.fill((Graphics)graphics, (int)this.deleteButton.getX(), (int)this.deleteButton.getY(), (int)this.deleteButton.getWidth(), (int)this.deleteButton.getHeight(), (int)0x1AFFFFFF);
                            break block12;
                        }
                        if (!this.expandButton.isInBounds((double)pMouseX, (double)pMouseY)) break block13;
                        GuiUtils.fill((Graphics)graphics, (int)this.expandButton.getX(), (int)this.expandButton.getY(), (int)this.expandButton.getWidth(), (int)this.expandButton.getHeight(), (int)0x1AFFFFFF);
                        break block12;
                    }
                    if (!this.expanded || !this.addButton.isInBounds((double)pMouseX, (double)pMouseY)) break block14;
                    GuiUtils.fill((Graphics)graphics, (int)this.addButton.getX(), (int)this.addButton.getY(), (int)this.addButton.getWidth(), (int)this.addButton.getHeight(), (int)0x1AFFFFFF);
                    break block12;
                }
                if (!this.expanded || !this.removeStationButtons.values().stream().anyMatch(x -> x.isInBounds((double)pMouseX, (double)pMouseY))) break block15;
                for (Map.Entry<String, GuiAreaDefinition> entry : this.removeStationButtons.entrySet()) {
                    if (!entry.getValue().isInBounds((double)pMouseX, (double)pMouseY)) continue;
                    GuiUtils.fill((Graphics)graphics, (int)entry.getValue().getX(), (int)entry.getValue().getY(), (int)entry.getValue().getWidth(), (int)entry.getValue().getHeight(), (int)0x1AFFFFFF);
                }
                break block12;
            }
            if (!this.expanded || !this.stationInfoAreas.values().stream().anyMatch(x -> x.isInBounds((double)pMouseX, (double)pMouseY))) break block12;
            for (Map.Entry<String, GuiAreaDefinition> entry : this.stationInfoAreas.entrySet()) {
                if (!entry.getValue().isInBounds((double)pMouseX, (double)pMouseY)) continue;
                GuiUtils.fill((Graphics)graphics, (int)entry.getValue().getX(), (int)entry.getValue().getY(), (int)entry.getValue().getWidth(), (int)entry.getValue().getHeight(), (int)0x1AFFFFFF);
            }
        }
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.renderTooltipWithOffset(this.parent, (class_339)this.newEntryBox, List.of(this.tooltipStationName), (int)(this.width / 2), (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
        GuiUtils.renderTooltipWithOffset(this.parent, (class_339)this.newEntryPlatformBox, List.of(this.tooltipPlatform), (int)(this.width / 2), (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
        GuiUtils.renderTooltipWithOffset(this.parent, (GuiAreaDefinition)this.deleteButton, List.of(this.tooltipDeleteAlias), (int)(this.width / 2), (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
        GuiUtils.renderTooltipWithOffset(this.parent, (GuiAreaDefinition)this.expandButton, List.of(this.expanded ? Constants.TOOLTIP_COLLAPSE : Constants.TOOLTIP_EXPAND), (int)(this.width / 2), (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
        if (this.expanded) {
            GuiUtils.renderTooltipWithOffset(this.parent, (GuiAreaDefinition)this.addButton, List.of(this.tooltipAddStation), (int)(this.width / 2), (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
            for (Map.Entry<String, GuiAreaDefinition> entry : this.removeStationButtons.entrySet()) {
                if (GuiUtils.renderTooltipWithOffset(this.parent, (GuiAreaDefinition)entry.getValue(), List.of(this.tooltipDeleteStation), (int)(this.width / 2), (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks))) break;
            }
            for (Map.Entry<String, GuiAreaDefinition> entry : this.stationNameAreas.entrySet()) {
                if (this.shadowlessFont.method_1727(entry.getKey()) > 92 && GuiUtils.renderTooltipAt(this.parent, (GuiAreaDefinition)entry.getValue(), List.of(TextUtils.text((String)entry.getKey())), (int)this.width, (Graphics)graphics, (int)(entry.getValue().getLeft() + 1), (int)(entry.getValue().getTop() - this.parent.getScrollOffset(partialTicks)), (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks))) break;
            }
            for (Map.Entry<String, GuiAreaDefinition> entry : this.stationInfoAreas.entrySet()) {
                class_5250 text = TextUtils.text((String)this.alias.getInfoForStation(entry.getKey()).platform());
                if (this.selectedStationName != null && entry.getKey().equals(this.selectedStationName) || this.shadowlessFont.method_27525((class_5348)text) <= 28 || !GuiUtils.renderTooltipAt(this.parent, (GuiAreaDefinition)entry.getValue(), List.of(text), (int)this.width, (Graphics)graphics, (int)entry.getValue().getLeft(), (int)(entry.getValue().getTop() - this.parent.getScrollOffset(partialTicks)), (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks))) continue;
                break;
            }
        } else if (this.titleBarArea.isInBounds((double)mouseX, (double)(mouseY + this.parent.getScrollOffset(partialTicks))) && this.shadowlessFont.method_1727(this.alias.getAliasName().get()) > 129) {
            GuiUtils.renderTooltipAt(this.parent, (GuiAreaDefinition)this.titleBarArea, List.of(TextUtils.text((String)this.alias.getAliasName().get())), (int)this.width, (Graphics)graphics, (int)(this.titleBarArea.getLeft() + 1), (int)(this.titleBarArea.getTop() - this.parent.getScrollOffset(partialTicks)), (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
        }
    }

    @Override
    public void renderSuggestions(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.destinationSuggestions != null) {
            graphics.poseStack().method_22903();
            graphics.poseStack().method_46416(0.0f, (float)(-this.parent.getScrollOffset(partialTicks)), 500.0f);
            this.destinationSuggestions.render(graphics.graphics(), mouseX, mouseY + this.parent.getScrollOffset(partialTicks));
            graphics.poseStack().method_22909();
        }
    }

    @Override
    public boolean mouseClickedLoop(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        return false;
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.expanded && this.stationInfoAreas.values().stream().anyMatch(x -> x.isInBounds(pMouseX, pMouseY))) {
            for (Map.Entry<String, GuiAreaDefinition> entry : this.stationInfoAreas.entrySet()) {
                if (!entry.getValue().isInBounds(pMouseX, pMouseY)) continue;
                this.editStationInfo(entry.getKey(), entry.getValue());
                return super.method_25402(pMouseX, pMouseY, pButton);
            }
        }
        this.editAliasPlatform.method_25365(false);
        if (this.deleteButton.isInBounds(pMouseX, pMouseY)) {
            this.deleteAlias();
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        if (this.expandButton.isInBounds(pMouseX, pMouseY)) {
            this.toggleExpanded();
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        if (this.expanded && this.addButton.isInBounds(pMouseX, pMouseY)) {
            this.addStation(this.newEntryBox.method_1882(), new TrainStationAlias.StationInfo(this.newEntryPlatformBox.method_1882()));
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        if (this.expanded && this.removeStationButtons.values().stream().anyMatch(x -> x.isInBounds(pMouseX, pMouseY))) {
            for (Map.Entry<String, GuiAreaDefinition> entry : this.removeStationButtons.entrySet()) {
                if (!entry.getValue().isInBounds(pMouseX, pMouseY)) continue;
                this.removeStation(entry.getKey());
                return super.method_25402(pMouseX, pMouseY, pButton);
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean mouseScrolledLoop(double pMouseX, double pMouseY, double pDelta) {
        return this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(pMouseX, pMouseY, MathUtils.clamp((double)pDelta, (double)-1.0, (double)1.0));
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().method_1887("");
        }
        this.destinationSuggestions = null;
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModStationSuggestions(this.minecraft, (class_437)this.parent, (class_342)field, this.minecraft.field_1772, this.getViableStations(field), field.method_25364() + 2 + field.method_46427());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<String> getViableStations(DLEditBox field) {
        return ClientTrainStationSnapshot.getInstance().getAllTrainStations().stream().distinct().filter(x -> !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted((String)x) && !this.alias.contains((String)x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }
}

