/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.NavigatorScreen;
import de.mrjulsen.crn.client.gui.screen.RouteDetailsScreen;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.event.listeners.JourneyListener;
import de.mrjulsen.crn.event.listeners.JourneyListenerManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RouteEntryOverviewWidget
extends DLButton {
    public static final int WIDTH = 200;
    public static final int HEIGHT = 54;
    private static final int DISPLAY_WIDTH = 190;
    private final SimpleRoute route;
    private final NavigatorScreen parent;
    private final class_1937 level;
    private final long lastRefreshedTime;
    private final class_5250 transferText = ELanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.transfer");
    private final class_5250 connectionInPast = ELanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final class_5250 trainCanceled = ELanguage.translate("gui.createrailwaysnavigator.route_overview.stop_canceled");

    public RouteEntryOverviewWidget(NavigatorScreen parent, class_1937 level, long lastRefreshedTime, int pX, int pY, SimpleRoute route, Consumer<RouteEntryOverviewWidget> onClick) {
        super(pX, pY, 200, 54, (class_2561)TextUtils.text((String)route.getName()), onClick);
        this.route = route;
        this.parent = parent;
        this.level = level;
        this.lastRefreshedTime = lastRefreshedTime;
    }

    public void method_25348(double pMouseX, double pMouseY) {
        super.method_25348(pMouseX, pMouseY);
        class_310 minecraft = class_310.method_1551();
        minecraft.method_1507((class_437)new RouteDetailsScreen((class_437)this.parent, this.level, this.route, this.route.getListenerId()));
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int i;
        float scale = 0.75f;
        float l = this.method_25405(pMouseX, pMouseY) ? 0.1f : 0.0f;
        boolean isActive = JourneyListenerManager.getInstance().get(this.route.getListenerId(), null) != null;
        boolean beforeJourney = isActive && JourneyListenerManager.getInstance().get(this.route.getListenerId(), null).getCurrentState() == JourneyListener.State.BEFORE_JOURNEY;
        int color = ColorUtils.lightenColor((int)CreateDynamicWidgets.ColorShade.DARK.getColor(), (float)l);
        if (!beforeJourney) {
            color = ColorUtils.applyTint((int)color, (int)0x663300);
        }
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.method_46426(), this.method_46427(), 200, 54, color);
        CreateDynamicWidgets.renderHorizontalSeparator(graphics, this.method_46426() + 6, this.method_46427() + 22, 188);
        class_310 minecraft = class_310.method_1551();
        SimpleRoute.SimpleRoutePart[] parts = (SimpleRoute.SimpleRoutePart[])this.route.getParts().toArray(SimpleRoute.SimpleRoutePart[]::new);
        NoShadowFontWrapper shadowlessFont = new NoShadowFontWrapper(minecraft.field_1772);
        String timeStart = TimeUtils.parseTime((long)((int)((this.lastRefreshedTime + 6000L) % 24000L) + this.route.getStartStation().getTicks()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        String timeEnd = TimeUtils.parseTime((long)((int)((this.lastRefreshedTime + 6000L) % 24000L) + this.route.getEndStation().getTicks()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        String dash = " - ";
        class_5250 line = TextUtils.text((String)String.format("%s%s%s | %s %s | %s", timeStart, dash, timeEnd, this.route.getTransferCount(), this.transferText.getString(), TimeUtils.parseDurationShort((int)this.route.getTotalDuration())));
        if (!this.route.isValid()) {
            line = line.method_27692(class_124.field_1061).method_27692(class_124.field_1055);
        }
        float localScale = shadowlessFont.method_27525((class_5348)line) > 188 ? 0.75f : 1.0f;
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(localScale, 1.0f, 1.0f);
        GuiUtils.drawString((Graphics)graphics, (class_327)minecraft.field_1772, (int)((int)((float)(this.method_46426() + 6) / localScale)), (int)(this.method_46427() + 5), (class_5348)line, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().method_22909();
        int routePartWidth = 190 / parts.length;
        String end = this.route.getEndStation().getStationName();
        int textW = shadowlessFont.method_1727(end);
        for (i = 0; i < parts.length; ++i) {
            GuiUtils.fill((Graphics)graphics, (int)(this.method_46426() + 5 + i * routePartWidth + 1), (int)(this.method_46427() + 27), (int)(routePartWidth - 2), (int)11, (int)-13027015);
        }
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
        if (this.route.getStartStation().shouldRenderRealtime()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)(((float)(this.method_46426() + 6) + (float)shadowlessFont.method_1727(timeStart) * localScale / 2.0f) / 0.75f) - shadowlessFont.method_1727(timeStart) / 2), (int)((int)((float)(this.method_46427() + 15) / 0.75f)), (class_5348)TextUtils.text((String)TimeUtils.parseTime((long)((int)(this.route.getStartStation().getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(this.route.getStartStation().isDelayed() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        if (this.route.getEndStation().shouldRenderRealtime()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)(((float)(this.method_46426() + 6) + (float)shadowlessFont.method_1727(timeEnd) * localScale * 1.5f + (float)shadowlessFont.method_1727(dash) * localScale) / 0.75f) - shadowlessFont.method_1727(timeEnd) / 2), (int)((int)((float)(this.method_46427() + 15) / 0.75f)), (class_5348)TextUtils.text((String)TimeUtils.parseTime((long)((int)(this.route.getEndStation().getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(this.route.getEndStation().isDelayed() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        if (!this.route.isValid()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)((float)(this.method_46426() + 200 - 5) / 0.75f) - shadowlessFont.method_27525((class_5348)this.trainCanceled)), (int)((int)((float)(this.method_46427() + 15) / 0.75f)), (class_5348)this.trainCanceled, (int)0xFF4242, (EAlignment)EAlignment.LEFT, (boolean)false);
        } else if (!beforeJourney) {
            GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)((float)(this.method_46426() + 200 - 5) / 0.75f) - shadowlessFont.method_27525((class_5348)this.connectionInPast)), (int)((int)((float)(this.method_46427() + 15) / 0.75f)), (class_5348)this.connectionInPast, (int)0xFF4242, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        for (i = 0; i < parts.length; ++i) {
            GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)((float)(this.method_46426() + 5 + i * routePartWidth + routePartWidth / 2) / 0.75f)), (int)((int)((float)(this.method_46427() + 30) / 0.75f)), (class_5348)TextUtils.text((String)parts[i].getTrainName()), (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)((float)(this.method_46426() + 6) / 0.75f)), (int)((int)((float)(this.method_46427() + 43) / 0.75f)), (class_5348)TextUtils.text((String)this.route.getStartStation().getStationName()), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)((float)(this.method_46426() + 200 - 6) / 0.75f) - textW), (int)((int)((float)(this.method_46427() + 43) / 0.75f)), (class_5348)TextUtils.text((String)end), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().method_22909();
    }
}

