/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.crn.event.listeners.TrainListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SimulatedTrainSchedule {
    private final Collection<TrainStop> stationOrder;
    private final SimulationData data;

    public SimulatedTrainSchedule(Collection<TrainStop> stations, SimulationData data) {
        this.stationOrder = this.makeDiractional(stations);
        this.data = data;
    }

    private List<TrainStop> makeDiractional(Collection<TrainStop> raw) {
        ArrayList<TrainStop> newList = new ArrayList<TrainStop>();
        boolean isRepeating = false;
        for (TrainStop stop : raw) {
            if (newList.contains(stop)) {
                isRepeating = true;
                continue;
            }
            if (isRepeating) {
                newList.add(0, stop);
                continue;
            }
            newList.add(stop);
        }
        return newList;
    }

    public Collection<TrainStop> getAllStops() {
        return this.stationOrder;
    }

    public Optional<TrainStop> getFirstStopOf(TrainStationAlias station) {
        return this.getAllStops().stream().filter(x -> x.getStationAlias().equals(station)).findFirst();
    }

    public boolean hasStation(GlobalStation station) {
        return this.getAllStops().stream().anyMatch(x -> x.getStationAlias().contains(station.name));
    }

    public boolean hasStationAlias(TrainStationAlias station) {
        return this.getAllStops().stream().anyMatch(x -> x.getStationAlias().equals(station));
    }

    public SimulationData getSimulationData() {
        return this.data;
    }

    public boolean isInDirection(TrainStationAlias start, TrainStationAlias end) {
        for (TrainStop stop : this.getAllStops()) {
            if (stop.getStationAlias().equals(start)) {
                return true;
            }
            if (!stop.getStationAlias().equals(end)) continue;
            return false;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimulatedTrainSchedule) {
            SimulatedTrainSchedule other = (SimulatedTrainSchedule)obj;
            HashSet<TrainStop> thisStops = new HashSet<TrainStop>(this.getAllStops());
            HashSet<TrainStop> otherStops = new HashSet<TrainStop>(other.getAllStops());
            if (thisStops.size() != otherStops.size()) {
                return false;
            }
            return thisStops.containsAll(otherStops);
        }
        return false;
    }

    public boolean exactEquals(Object obj) {
        if (obj instanceof SimulatedTrainSchedule) {
            SimulatedTrainSchedule other = (SimulatedTrainSchedule)obj;
            if (this.getAllStops().size() != other.getAllStops().size()) {
                return false;
            }
            TrainStop[] a = (TrainStop[])this.getAllStops().toArray(TrainStop[]::new);
            TrainStop[] b = (TrainStop[])other.getAllStops().toArray(TrainStop[]::new);
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 17 * Objects.hash(this.getAllStops());
    }

    public String toString() {
        return Arrays.toString(this.getAllStops().toArray());
    }

    public static int getTrainCycleDuration(Train train) {
        return TrainListener.getInstance().getApproximatedTrainDuration(train);
    }

    public record SimulationData(Train train, int simulationTime, int simulationCorrection) {
    }
}

