/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.data.EDisplayInfo;
import de.mrjulsen.crn.data.EDisplayType;
import de.mrjulsen.crn.data.ESide;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class AdvancedDisplayUpdatePacket
implements IPacketBase<AdvancedDisplayUpdatePacket> {
    private class_2338 pos;
    private EDisplayType type;
    private EDisplayInfo info;
    private boolean doubleSided;

    public AdvancedDisplayUpdatePacket() {
    }

    public AdvancedDisplayUpdatePacket(class_1937 level, class_2338 pos, EDisplayType type, EDisplayInfo info, boolean doubleSided) {
        this.pos = pos;
        this.info = info;
        this.type = type;
        this.doubleSided = doubleSided;
        this.apply(level, this);
    }

    protected AdvancedDisplayUpdatePacket(class_2338 pos, EDisplayType type, EDisplayInfo info, boolean doubleSided) {
        this.pos = pos;
        this.info = info;
        this.type = type;
        this.doubleSided = doubleSided;
    }

    public void encode(AdvancedDisplayUpdatePacket packet, class_2540 buffer) {
        buffer.method_10807(packet.pos);
        buffer.writeInt(packet.info.getId());
        buffer.writeInt(packet.type.getId());
        buffer.writeBoolean(packet.doubleSided);
    }

    public AdvancedDisplayUpdatePacket decode(class_2540 buffer) {
        class_2338 pos = buffer.method_10811();
        EDisplayInfo info = EDisplayInfo.getTypeById(buffer.readInt());
        EDisplayType type = EDisplayType.getTypeById(buffer.readInt());
        boolean doubleSided = buffer.readBoolean();
        return new AdvancedDisplayUpdatePacket(pos, type, info, doubleSided);
    }

    private void apply(class_1937 level, AdvancedDisplayUpdatePacket packet) {
        class_2586 class_25862;
        if (level.method_8477(packet.pos) && (class_25862 = level.method_8321(packet.pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity = (AdvancedDisplayBlockEntity)class_25862;
            blockEntity.applyToAll(be -> {
                be.setDisplayType(packet.type);
                be.setInfoType(packet.info);
                if (level.method_8320(be.method_11016()).method_26204() instanceof AbstractAdvancedSidedDisplayBlock) {
                    class_2680 state = level.method_8320(be.method_11016());
                    state = (class_2680)state.method_11657(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                    level.method_8501(be.method_11016(), state);
                }
                be.notifyUpdate();
            });
        }
    }

    public void handle(AdvancedDisplayUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_1657 player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null) {
                class_1937 level = player.method_37908();
                this.apply(level, packet);
            }
        });
    }
}

