/*
 * Decompiled with CFR 0.152.
 */
package fabric.dev.rdh.createunlimited.fabric;

import fabric.dev.rdh.createunlimited.CreateUnlimited;
import fabric.dev.rdh.createunlimited.command.CUCommands;
import fabric.dev.rdh.createunlimited.config.CUConfigs;
import fabric.dev.rdh.createunlimited.multiversion.SupportedMinecraftVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.minecraftforge.fml.config.ModConfig;

public class CreateUnlimitedFabric
implements ModInitializer {
    public void onInitialize() {
        CreateUnlimitedFabric.registerConfigEvents();
        CreateUnlimited.init();
        CommandRegistrationCallback.EVENT.register(CUCommands::register);
    }

    private static <L, R> void registerConfigEvents() {
        Object t;
        Event event;
        Class<?> clazz = CreateUnlimitedFabric.getModConfigEventsClass();
        try {
            event = (Event)clazz.getMethod("loading", String.class).invoke(null, "createunlimited");
            t = CreateUnlimitedFabric.createHandlerProxy(CUConfigs::onLoad, clazz, "Loading", "onModConfigLoading");
            event.register(t);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw SupportedMinecraftVersion.unchecked(reflectiveOperationException);
        }
        try {
            event = (Event)clazz.getMethod("reloading", String.class).invoke(null, "createunlimited");
            t = CreateUnlimitedFabric.createHandlerProxy(CUConfigs::onReload, clazz, "Reloading", "onModConfigReloading");
            event.register(t);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw SupportedMinecraftVersion.unchecked(reflectiveOperationException);
        }
    }

    private static <T> T createHandlerProxy(Consumer<ModConfig> consumer, Class<?> clazz, String string, String string2) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{CreateUnlimitedFabric.findNestedClass(clazz, string)}, (object, method, objectArray) -> {
            Object object2;
            if (method.getName().equals(string2) && objectArray.length == 1 && (object2 = objectArray[0]) instanceof ModConfig) {
                ModConfig modConfig = (ModConfig)object2;
                consumer.accept(modConfig);
                return null;
            }
            throw new UnsupportedOperationException("Unexpected method: " + method);
        });
    }

    private static Class<?> findNestedClass(Class<?> clazz, String string) {
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!clazz2.getSimpleName().equals(string)) continue;
            return clazz2;
        }
        throw new IllegalArgumentException("Nested class " + string + " not found in " + clazz.getName());
    }

    private static Class<?> getModConfigEventsClass() {
        try {
            if (SupportedMinecraftVersion.v1_19_2.compareTo(SupportedMinecraftVersion.CURRENT) >= 0) {
                return Class.forName("net.minecraftforge.api.fml.event.config.ModConfigEvents");
            }
            if (SupportedMinecraftVersion.v1_20_1.compareTo(SupportedMinecraftVersion.CURRENT) <= 0) {
                return Class.forName("fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents");
            }
            throw new IllegalStateException("Unsupported Minecraft version: " + SupportedMinecraftVersion.CURRENT);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw SupportedMinecraftVersion.unchecked(classNotFoundException);
        }
    }
}

