/*
 * Decompiled with CFR 0.152.
 */
package fabric.dev.rdh.createunlimited.fabric;

import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import com.mojang.brigadier.arguments.ArgumentType;
import fabric.dev.rdh.createunlimited.multiversion.SupportedMinecraftVersion;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1320;
import net.minecraft.class_2314;
import net.minecraft.class_2960;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class UtilImpl {
    private static MethodHandle modLoadingContextRegisterConfig;
    private static MethodHandle forgeConfigRegistryRegister;
    private static Object forgeConfigRegistryInstance;

    private static void setupConfigRegistry() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> clazz;
            if (SupportedMinecraftVersion.v1_19_2.compareTo(SupportedMinecraftVersion.CURRENT) >= 0) {
                clazz = Class.forName("net.minecraftforge.api.ModLoadingContext");
                modLoadingContextRegisterConfig = lookup.findStatic(clazz, "registerConfig", MethodType.methodType(ModConfig.class, String.class, ModConfig.Type.class, IConfigSpec.class));
            }
            if (SupportedMinecraftVersion.v1_20_1.compareTo(SupportedMinecraftVersion.CURRENT) <= 0) {
                clazz = Class.forName("fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry");
                forgeConfigRegistryRegister = lookup.findVirtual(clazz, "register", MethodType.methodType(ModConfig.class, String.class, ModConfig.Type.class, IConfigSpec.class));
                forgeConfigRegistryInstance = clazz.getField("INSTANCE").get(null);
            }
        }
        catch (Throwable throwable) {
            throw SupportedMinecraftVersion.unchecked(throwable);
        }
    }

    public static void registerConfig(ModConfig.Type type, IConfigSpec<?> iConfigSpec) {
        if (modLoadingContextRegisterConfig == null && forgeConfigRegistryRegister == null) {
            UtilImpl.setupConfigRegistry();
        }
        try {
            if (SupportedMinecraftVersion.v1_19_2.compareTo(SupportedMinecraftVersion.CURRENT) >= 0) {
                ModConfig modConfig = modLoadingContextRegisterConfig.invokeExact("createunlimited", type, iConfigSpec);
            }
            if (SupportedMinecraftVersion.v1_20_1.compareTo(SupportedMinecraftVersion.CURRENT) <= 0) {
                forgeConfigRegistryRegister.invoke(forgeConfigRegistryInstance, "createunlimited", type, iConfigSpec);
            }
        }
        catch (Throwable throwable) {
            throw SupportedMinecraftVersion.unchecked(throwable);
        }
    }

    public static <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> void registerArgument(Class<A> clazz, I i, class_2960 class_29602) {
        ArgumentTypeRegistry.registerArgumentType((class_2960)class_29602, clazz, i);
    }

    public static String getVersion(String string) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(string).orElseThrow(() -> new IllegalArgumentException("Mod container for \"" + string + "\" not found"))).getMetadata().getVersion().getFriendlyString();
    }

    public static boolean isDevEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static class_1320 getReachAttribute() {
        return ReachEntityAttributes.REACH;
    }

    public static String platformName() {
        return FabricLoader.getInstance().isModLoaded("quilt_loader") ? "Quilt" : "Fabric";
    }
}

