/*
 * Decompiled with CFR 0.152.
 */
package forge.dev.rdh.createunlimited.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.foundation.config.ConfigBase;
import forge.dev.rdh.createunlimited.CreateUnlimited;
import forge.dev.rdh.createunlimited.asm.mixin.accessor.CValueAccessor;
import forge.dev.rdh.createunlimited.command.CUCommands;
import forge.dev.rdh.createunlimited.command.EnumArgument;
import forge.dev.rdh.createunlimited.config.CUConfigs;
import forge.dev.rdh.createunlimited.config.CUServer;
import java.lang.reflect.Field;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraftforge.common.ForgeConfigSpec;

public final class CUConfigCommand
extends CUCommands {
    private final boolean integrated;

    public CUConfigCommand(boolean bl) {
        this.integrated = bl;
    }

    public ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder literalArgumentBuilder = Commands.m_82127_((String)"config");
        LiteralArgumentBuilder literalArgumentBuilder2 = null;
        for (Field field : CUServer.class.getDeclaredFields()) {
            ConfigBase.CValue cValue;
            if (!ConfigBase.CValue.class.isAssignableFrom(field.getType())) continue;
            String string = field.getName();
            if (field.getType() == ConfigBase.ConfigGroup.class) {
                if (literalArgumentBuilder2 != null) {
                    literalArgumentBuilder.then((ArgumentBuilder)literalArgumentBuilder2);
                }
                literalArgumentBuilder2 = Commands.m_82127_((String)string);
                literalArgumentBuilder.then(Commands.m_82127_((String)string).executes(commandContext -> {
                    CUConfigCommand.message((CommandContext<CommandSourceStack>)commandContext, CUServer.getComment(string));
                    return 1;
                }));
                continue;
            }
            if (literalArgumentBuilder2 == null) {
                literalArgumentBuilder2 = literalArgumentBuilder;
            }
            try {
                cValue = (ConfigBase.CValue)field.get((Object)CUConfigs.server);
            }
            catch (ClassCastException | IllegalAccessException exception) {
                CreateUnlimited.LOGGER.error("Failed to get config value for " + string, (Throwable)exception);
                continue;
            }
            this.configure((LiteralArgumentBuilder<CommandSourceStack>)literalArgumentBuilder2, string, ((CValueAccessor)cValue).getValue());
        }
        if (literalArgumentBuilder2 != null) {
            literalArgumentBuilder.then(literalArgumentBuilder2);
        }
        return literalArgumentBuilder;
    }

    private boolean perms(CommandSourceStack commandSourceStack) {
        return this.integrated || commandSourceStack.m_6761_(2);
    }

    private <T> void configure(LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder, String string, ForgeConfigSpec.ConfigValue<T> configValue) {
        Class<?> clazz = configValue.getDefault().getClass();
        literalArgumentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)string).executes(commandContext -> {
            CUConfigCommand.message((CommandContext<CommandSourceStack>)commandContext, string + ": " + CUServer.getComment(string));
            CUConfigCommand.message((CommandContext<CommandSourceStack>)commandContext, "Current value: " + configValue.get());
            CUConfigCommand.message((CommandContext<CommandSourceStack>)commandContext, "Default value: " + configValue.getDefault());
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(this::perms)).executes(commandContext -> {
            if (configValue.get().equals(configValue.getDefault())) {
                CUConfigCommand.error((CommandContext<CommandSourceStack>)commandContext, "Value is already default!");
                return 0;
            }
            configValue.set(configValue.getDefault());
            CUConfigCommand.message((CommandContext<CommandSourceStack>)commandContext, string + " reset to: " + configValue.get());
            return 1;
        }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", this.getArgument(configValue)).requires(this::perms)).executes(commandContext -> {
            Object object = commandContext.getArgument("value", clazz);
            if (object == configValue.get()) {
                CUConfigCommand.error((CommandContext<CommandSourceStack>)commandContext, "Value is already set to " + object);
                return 0;
            }
            configValue.set(object);
            CUConfigCommand.message((CommandContext<CommandSourceStack>)commandContext, "Value set to: " + object);
            return 1;
        })));
    }

    private <T> ArgumentType<T> getArgument(ForgeConfigSpec.ConfigValue<T> configValue) {
        if (configValue instanceof ForgeConfigSpec.BooleanValue) {
            return BoolArgumentType.bool();
        }
        if (configValue instanceof ForgeConfigSpec.DoubleValue) {
            return DoubleArgumentType.doubleArg();
        }
        if (configValue instanceof ForgeConfigSpec.IntValue) {
            return IntegerArgumentType.integer();
        }
        Class<?> clazz = configValue.getDefault().getClass();
        if (configValue instanceof ForgeConfigSpec.EnumValue && clazz.isEnum()) {
            return EnumArgument.enumArg(clazz, true);
        }
        throw new IllegalArgumentException("Unsupported class for argument: " + clazz);
    }
}

