/*
 * Decompiled with CFR 0.152.
 */
package forge.dev.rdh.createunlimited.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forge.dev.rdh.createunlimited.CreateUnlimited;
import forge.dev.rdh.createunlimited.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class EnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((object, object2) -> Component.m_237113_((String)String.format("Invalid enum value '%s', expected one of: %s", object, object2)));
    private final Class<T> enumClass;
    private final boolean lowercase;

    public static void init() {
        Util.registerArgument(EnumArgument.class, new Info(), CreateUnlimited.asResource("enumargument"));
    }

    public static <R extends Enum<R>> EnumArgument<R> enumArg(Class<R> clazz, boolean bl) {
        return new EnumArgument<R>(clazz, bl);
    }

    private EnumArgument(Class<T> clazz, boolean bl) {
        this.enumClass = clazz;
        this.lowercase = bl;
    }

    public T parse(StringReader stringReader) throws CommandSyntaxException {
        String string = stringReader.readUnquotedString();
        try {
            return Enum.valueOf(this.enumClass, this.unlowercase(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)stringReader, (Object)string, (Object)Arrays.toString(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(this::lowercase).toArray()));
        }
    }

    public static <R extends Enum<R>> R getEnum(CommandContext<?> commandContext, String string, Class<R> clazz) {
        return (R)((Enum)commandContext.getArgument(string, clazz));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return SharedSuggestionProvider.m_82981_(Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(this::lowercase), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(this::lowercase).collect(Collectors.toList());
    }

    private String lowercase(String string) {
        return this.lowercase ? string.toLowerCase() : string;
    }

    private String unlowercase(String string) {
        if (!this.lowercase) {
            return string;
        }
        return Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).filter(string2 -> string2.equalsIgnoreCase(string)).findFirst().orElse(string);
    }

    public static class Info<T extends Enum<T>>
    implements ArgumentTypeInfo<EnumArgument<T>, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_130070_(template.enumClass.getName());
            friendlyByteBuf.writeBoolean(template.lowercase);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            try {
                String string = friendlyByteBuf.m_130277_();
                boolean bl = friendlyByteBuf.readBoolean();
                return new Template(Class.forName(string), bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
            jsonObject.addProperty("enum", template.enumClass.getName());
        }

        public @NotNull Template unpack(EnumArgument<T> enumArgument) {
            return new Template(enumArgument.enumClass, enumArgument.lowercase);
        }

        public class Template
        implements ArgumentTypeInfo.Template<EnumArgument<T>> {
            final Class<T> enumClass;
            final boolean lowercase;

            Template(Class<T> clazz, boolean bl) {
                this.enumClass = clazz;
                this.lowercase = bl;
            }

            public @NotNull EnumArgument<T> instantiate(@NotNull CommandBuildContext commandBuildContext) {
                return new EnumArgument(this.enumClass, this.lowercase);
            }

            public @NotNull ArgumentTypeInfo<EnumArgument<T>, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

