/*
 * Decompiled with CFR 0.152.
 */
package forge.dev.rdh.createunlimited.forge;

import com.mojang.brigadier.arguments.ArgumentType;
import forge.dev.rdh.createunlimited.CreateUnlimited;
import forge.dev.rdh.createunlimited.forge.CreateUnlimitedForge;
import forge.dev.rdh.createunlimited.multiversion.SupportedMinecraftVersion;
import java.util.List;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.RegistryObject;

public class UtilImpl {
    private static RegistryObject<Attribute> reachAttribute = null;

    public static void registerConfig(ModConfig.Type type, IConfigSpec<?> iConfigSpec) {
        ModLoadingContext.get().registerConfig(type, iConfigSpec);
    }

    public static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> void registerArgument(Class<A> clazz, I i, ResourceLocation resourceLocation) {
        CreateUnlimitedForge.ARGUMENTS.register(resourceLocation.m_135815_(), () -> ArgumentTypeInfos.registerByClass((Class)clazz, (ArgumentTypeInfo)i));
    }

    public static String getVersion(String string) {
        String string2 = "UNKNOWN";
        List list = ModList.get().getModFileById(string).getMods();
        if (list.size() > 1) {
            CreateUnlimited.LOGGER.error("Multiple mods for ID: " + string);
        }
        for (IModInfo iModInfo : list) {
            if (!iModInfo.getModId().equals(string)) continue;
            string2 = iModInfo.getVersion().toString();
            break;
        }
        return string2;
    }

    public static boolean isDevEnv() {
        return !FMLLoader.isProduction();
    }

    private static RegistryObject<Attribute> makeReachAttribute() {
        try {
            if (SupportedMinecraftVersion.v1_20_1.compareTo(SupportedMinecraftVersion.CURRENT) <= 0) {
                return (RegistryObject)ForgeMod.class.getField("BLOCK_REACH").get(null);
            }
            if (SupportedMinecraftVersion.v1_19_2.compareTo(SupportedMinecraftVersion.CURRENT) <= 0) {
                return (RegistryObject)ForgeMod.class.getField("REACH_DISTANCE").get(null);
            }
            throw new IllegalStateException("Unsupported minecraft version: " + SupportedMinecraftVersion.CURRENT);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new RuntimeException("Failed to get reach attribute for minecraft version " + SupportedMinecraftVersion.CURRENT, reflectiveOperationException);
        }
    }

    public static Attribute getReachAttribute() {
        if (reachAttribute == null) {
            reachAttribute = UtilImpl.makeReachAttribute();
        }
        return (Attribute)reachAttribute.get();
    }

    public static String platformName() {
        return "Forge";
    }
}

