/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards;

import de.markusbordihn.dailyrewards.data.RewardData;
import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.data.SpecialRewardUserData;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerSetup {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");

    protected ServerSetup() {
    }

    public static void handleServerStartingEvent(MinecraftServer server) {
        log.info("{} Server Starting setup on {} ...", (Object)"\ud83d\udcb0 Register Daily Rewards", (Object)server);
        RewardData.prepare(server);
        RewardUserData.prepare(server);
        SpecialRewardUserData.prepare(server);
        List<class_1799> rewardItems = RewardData.get().getRewardsForCurrentMonth();
        if (rewardItems.isEmpty()) {
            log.warn("No rewards found for this month!");
        } else {
            log.info("Rewards for this Month: {}", rewardItems);
        }
        List<class_1799> specialRewardItems = RewardData.get().getSpecialRewardsForCurrentMonth();
        if (specialRewardItems.isEmpty()) {
            log.info("No special rewards found for this month!");
        } else {
            log.info("Special Rewards for this Month: {}", specialRewardItems);
        }
    }
}

