/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.dailyrewards.Constants;
import de.markusbordihn.dailyrewards.client.screen.RewardScreen;
import de.markusbordihn.dailyrewards.item.ModItems;
import de.markusbordihn.dailyrewards.menu.RewardCompactMenu;
import de.markusbordihn.dailyrewards.menu.slots.DailyRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.EmptyRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.HiddenRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.RewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.TakeableRewardSlot;
import de.markusbordihn.dailyrewards.rewards.Rewards;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RewardCompactScreen
extends RewardScreen<RewardCompactMenu> {
    private final class_5250 rewardScreenTitle = class_2561.method_43469((String)"text.daily_rewards.reward_screen_none", (Object[])new Object[]{this.rewardedDays});
    private final class_2960 rewardScreenBackground = this.hasSpecialReward ? Constants.TEXTURE_COMPACT_SCREEN_COMBINED : Constants.TEXTURE_COMPACT_SCREEN;
    private int updateTicker = 0;
    private int updateSpecialTicker = 0;
    private String nextRewardTimeString;
    private String nextRewardSpecialTimeString;
    private boolean reloadToClaim = false;

    public RewardCompactScreen(RewardCompactMenu menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    public void rendererTakeableRewardSlot(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_25302(Constants.TEXTURE_GENERIC_54, x - 1, y - 1, 7, 17, 18, 18);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_25302(Constants.TEXTURE_ICONS, x + 12, y - 5, 0, 0, 8, 8);
        guiGraphics.method_51448().method_22909();
    }

    public void renderRewardSlot(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_25302(Constants.TEXTURE_GENERIC_54, x - 1, y - 1, 7, 17, 18, 18);
        guiGraphics.method_51448().method_22909();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.method_51739(class_1921.method_51785(), x - 1, y - 1, x + 17, y + 17, -2136298838);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    protected void renderNextTimeForReward(class_332 guiGraphics, int x, int y) {
        class_5250 component;
        if (this.reloadToClaim) {
            class_5250 component2;
            int componentWidth = this.field_22793.method_27525((class_5348)(component2 = class_2561.method_43471((String)"text.daily_rewards.next_reward.reload")));
            guiGraphics.method_51439(this.field_22793, (class_2561)component2, x + (componentWidth < this.field_2792 ? (this.field_2792 - componentWidth) / 2 : 0), y, 0xFF0000, false);
            return;
        }
        if ((this.updateTicker++ & 0x13) == 0) {
            int localPlayerTickCount = this.localPlayer != null ? this.localPlayer.field_6012 : 0;
            String lastRewardedDay = ((RewardCompactMenu)this.field_2797).getLastRewardedDay();
            long nextRewardTime = Rewards.getCurrentYearMonthDay().equals(lastRewardedDay) ? Duration.between(LocalDateTime.now(), LocalDateTime.now().withHour(23).withMinute(59).withSecond(59)).toSeconds() + (long)this.rewardTimePerDayInSeconds : (long)(this.rewardTimePerDayInSeconds - localPlayerTickCount / 20);
            this.nextRewardTimeString = LocalTime.MIN.plusSeconds(nextRewardTime + 60L).toString();
            if (this.nextRewardTimeString.length() == 5) {
                this.nextRewardTimeString = this.nextRewardTimeString + ":00";
            }
            if ("00:00:00".equals(this.nextRewardTimeString)) {
                log.debug("Reload screen to be able to claim for day {} ...", (Object)(this.rewardedDays + 1));
                this.reloadToClaim = true;
            }
            if (this.updateTicker >= 20) {
                this.updateTicker = 0;
            }
        }
        this.nextRewardTimeString = RewardCompactScreen.mergeComponentStyleCodeWithText((class_2561)class_2561.method_43471((String)"text.daily_rewards.next_reward.in"), this.nextRewardTimeString);
        int componentWidth = this.field_22793.method_27525((class_5348)(component = class_2561.method_43469((String)"text.daily_rewards.next_reward.in", (Object[])new Object[]{this.nextRewardTimeString})));
        guiGraphics.method_51439(this.field_22793, (class_2561)component, x + (componentWidth < this.field_2792 ? (this.field_2792 - componentWidth) / 2 : 0), y, 0x666666, false);
    }

    protected void renderNextTimeForSpecialReward(class_332 guiGraphics, int x, int y) {
        class_5250 component;
        if (this.reloadToClaim) {
            class_5250 component2;
            int componentWidth = this.field_22793.method_27525((class_5348)(component2 = class_2561.method_43471((String)"text.daily_rewards.next_special_reward.reload")));
            guiGraphics.method_51439(this.field_22793, (class_2561)component2, x + (componentWidth < this.field_2792 ? (this.field_2792 - componentWidth) / 2 : 0), y, 0xFF0000, false);
            return;
        }
        if ((this.updateSpecialTicker++ & 0x13) == 0) {
            int localPlayerTickCount = this.localPlayer != null ? this.localPlayer.field_6012 : 0;
            String lastRewardedSpecialDay = ((RewardCompactMenu)this.field_2797).getLastRewardedSpecialDay();
            long nextRewardTime = Rewards.getCurrentYearMonthDay().equals(lastRewardedSpecialDay) ? Duration.between(LocalDateTime.now(), LocalDateTime.now().withHour(23).withMinute(59).withSecond(59)).toSeconds() + (long)this.rewardTimePerDayInSeconds : (long)(this.rewardTimePerDayInSeconds - localPlayerTickCount / 20);
            this.nextRewardSpecialTimeString = LocalTime.MIN.plusSeconds(nextRewardTime + 60L).toString();
            if (this.nextRewardSpecialTimeString.length() == 5) {
                this.nextRewardSpecialTimeString = this.nextRewardSpecialTimeString + ":00";
            }
            if ("00:00:00".equals(this.nextRewardSpecialTimeString)) {
                log.debug("Reload screen to be able to claim for day {} ...", (Object)(this.rewardedDays + 1));
                this.reloadToClaim = true;
            }
            if (this.updateSpecialTicker >= 20) {
                this.updateSpecialTicker = 0;
            }
        }
        this.nextRewardSpecialTimeString = RewardCompactScreen.mergeComponentStyleCodeWithText((class_2561)class_2561.method_43471((String)"text.daily_rewards.next_special_reward.in"), this.nextRewardSpecialTimeString);
        int componentWidth = this.field_22793.method_27525((class_5348)(component = class_2561.method_43469((String)"text.daily_rewards.next_special_reward.in", (Object[])new Object[]{this.nextRewardSpecialTimeString})));
        guiGraphics.method_51439(this.field_22793, (class_2561)component, x + (componentWidth < this.field_2792 ? (this.field_2792 - componentWidth) / 2 : 0), y, 0x666666, false);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        int shiftTopPos = this.hasSpecialReward ? 0 : 30;
        for (int k = 0; k < ((RewardCompactMenu)this.field_2797).field_7761.size(); ++k) {
            class_1735 slot = (class_1735)((RewardCompactMenu)this.field_2797).field_7761.get(k);
            if (!(slot instanceof DailyRewardSlot)) continue;
            if (slot instanceof TakeableRewardSlot) {
                if (slot.method_7677().method_31574((class_1792)ModItems.TAKEN_REWARD.get())) continue;
                this.rendererTakeableRewardSlot(guiGraphics, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872);
                continue;
            }
            if (!(slot instanceof RewardSlot) && !(slot instanceof EmptyRewardSlot) && !(slot instanceof HiddenRewardSlot)) continue;
            this.renderRewardSlot(guiGraphics, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872);
        }
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"text.daily_rewards.daily_rewards.title", (Object[])new Object[]{this.rewardedDays}), this.field_2776 + 50, this.field_2800 + 29 + shiftTopPos, 0x404040, false);
        if (this.hasSpecialReward) {
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"text.daily_rewards.special_rewards.title", (Object[])new Object[]{this.rewardedSpecialDays}), this.field_2776 + 30, this.field_2800 + 94, 0x404040, false);
        }
        if (this.automaticRewardPlayers) {
            this.renderNextTimeForReward(guiGraphics, this.field_2776 + 2, this.field_2800 + 67 + shiftTopPos);
        }
        if (this.automaticRewardSpecialPlayers && this.hasSpecialReward) {
            this.renderNextTimeForSpecialReward(guiGraphics, this.field_2776, this.field_2800 + 133);
        }
        this.method_2380(guiGraphics, x, y);
    }

    protected void method_2388(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51439(this.field_22793, (class_2561)this.rewardScreenTitle, this.field_25267 + 42, this.field_25268 - 1, 0xFFFFFF, true);
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    @Override
    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_25302(this.rewardScreenBackground, this.field_2776 + 1, this.field_2800, 0, 0, 256, 256);
        guiGraphics.method_51448().method_22909();
    }
}

