/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.client.screen;

import de.markusbordihn.dailyrewards.Constants;
import de.markusbordihn.dailyrewards.client.screen.RewardScreen;
import de.markusbordihn.dailyrewards.item.ModItems;
import de.markusbordihn.dailyrewards.menu.RewardMenu;
import de.markusbordihn.dailyrewards.menu.slots.DailyRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.EmptyRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.HiddenRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.RewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.TakeableRewardSlot;
import de.markusbordihn.dailyrewards.rewards.Rewards;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RewardOverviewScreen<T extends RewardMenu>
extends RewardScreen<T> {
    private final class_5250 rewardScreenTitle = this.rewardedDays > 0 ? class_2561.method_43469((String)"text.daily_rewards.reward_screen", (Object[])new Object[]{this.rewardedDays}) : class_2561.method_43469((String)"text.daily_rewards.reward_screen_none", (Object[])new Object[]{this.rewardedDays});
    private int updateTicker = 0;
    private String nextRewardTimeString;
    private boolean reloadToClaim = false;

    public RewardOverviewScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    public void rendererTakeableRewardSlot(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_25302(Constants.TEXTURE_ICONS, x + 12, y - 5, 0, 0, 9, 9);
        guiGraphics.method_51448().method_22909();
    }

    public void renderRewardSlot(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51739(class_1921.method_51785(), x - 1, y - 1, x + 17, y + 19 + 8, -2136298838);
    }

    protected void renderNextTimeForReward(class_332 guiGraphics, int x, int y) {
        class_5250 component;
        if (this.reloadToClaim) {
            class_5250 component2;
            int componentWidth = this.field_22793.method_27525((class_5348)(component2 = class_2561.method_43471((String)"text.daily_rewards.next_reward.reload")));
            guiGraphics.method_51439(this.field_22793, (class_2561)component2, x + (componentWidth < this.field_2792 ? (this.field_2792 - componentWidth) / 2 : 0), y, 0xFF0000, false);
            return;
        }
        if ((this.updateTicker++ & 0x13) == 0) {
            int localPlayerTickCount = this.localPlayer != null ? this.localPlayer.field_6012 : 0;
            String lastRewardedDay = ((RewardMenu)this.field_2797).getLastRewardedDay();
            long nextRewardTime = Rewards.getCurrentYearMonthDay().equals(lastRewardedDay) ? Duration.between(LocalDateTime.now(), LocalDateTime.now().withHour(23).withMinute(59).withSecond(59)).toSeconds() + (long)this.rewardTimePerDayInSeconds : (long)(this.rewardTimePerDayInSeconds - localPlayerTickCount / 20);
            this.nextRewardTimeString = LocalTime.MIN.plusSeconds(nextRewardTime + 60L).toString();
            if (this.nextRewardTimeString.length() == 5) {
                this.nextRewardTimeString = this.nextRewardTimeString + ":00";
            }
            if ("00:00:00".equals(this.nextRewardTimeString)) {
                log.debug("Reload screen to be able to claim for day {} ...", (Object)(this.rewardedDays + 1));
                this.reloadToClaim = true;
            }
            if (this.updateTicker >= 20) {
                this.updateTicker = 0;
            }
        }
        this.nextRewardTimeString = RewardOverviewScreen.mergeComponentStyleCodeWithText((class_2561)class_2561.method_43471((String)"text.daily_rewards.next_reward.in"), this.nextRewardTimeString);
        int componentWidth = this.field_22793.method_27525((class_5348)(component = class_2561.method_43469((String)"text.daily_rewards.next_reward.in", (Object[])new Object[]{this.nextRewardTimeString})));
        guiGraphics.method_51439(this.field_22793, (class_2561)component, x + (componentWidth < this.field_2792 ? (this.field_2792 - componentWidth) / 2 : 0), y, 0x666666, false);
    }

    protected void renderIcons(class_332 guiGraphics, int x, int y) {
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        for (int k = 0; k < ((RewardMenu)this.field_2797).field_7761.size(); ++k) {
            class_1735 slot = (class_1735)((RewardMenu)this.field_2797).field_7761.get(k);
            if (!(slot instanceof DailyRewardSlot)) continue;
            if (slot instanceof TakeableRewardSlot && !slot.method_7677().method_31574((class_1792)ModItems.TAKEN_REWARD.get())) {
                this.rendererTakeableRewardSlot(guiGraphics, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872);
                continue;
            }
            if (!(slot instanceof RewardSlot) && !(slot instanceof EmptyRewardSlot) && !(slot instanceof HiddenRewardSlot)) continue;
            this.renderRewardSlot(guiGraphics, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872);
        }
        this.renderIcons(guiGraphics, x, y);
        if (this.automaticRewardPlayers) {
            this.renderNextTimeForReward(guiGraphics, this.field_2776 + 2, this.field_2800 + 140);
        }
        this.method_2380(guiGraphics, x, y);
    }

    protected void method_2388(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51439(this.field_22793, (class_2561)this.rewardScreenTitle, this.field_25267 + 5, this.field_25268 - 1, 0xFFFFFF, true);
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    @Override
    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_25302(Constants.TEXTURE_OVERVIEW_SCREEN, this.field_2776 + 1, this.field_2800, 0, 0, 256, 256);
        guiGraphics.method_51448().method_22909();
        int dayCounter = 1;
        for (int i = 0; i < 4; ++i) {
            int slotTopPos = this.field_2800 + i * 30 + 2;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (dayCounter > this.rewardDaysForCurrentMonth) continue;
                int slotLeftPos = this.field_2776 + 7 + Math.round((float)i2 * 20.5f);
                guiGraphics.method_25302(Constants.TEXTURE_ICONS, slotLeftPos - 1, slotTopPos + 17, 0, 11, 20, 29);
                guiGraphics.method_51433(this.field_22793, "" + dayCounter, slotLeftPos + (dayCounter < 10 ? 6 : 4), slotTopPos + 36, 0x404040, false);
                ++dayCounter;
            }
        }
    }
}

