/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.dailyrewards.commands.CustomCommand;
import de.markusbordihn.dailyrewards.config.ModConfigs;
import de.markusbordihn.dailyrewards.data.RewardData;
import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.data.SpecialRewardUserData;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class ConfigCommand
extends CustomCommand {
    private static final ConfigCommand command = new ConfigCommand();

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(cs -> cs.method_9259(3))).executes((Command)command)).then(class_2170.method_9247((String)"reload").executes(command::reloadConfig))).then(class_2170.method_9247((String)"reset").executes(command::resetConfig))).then(class_2170.method_9247((String)"clear").executes(command::clearConfig));
    }

    public int run(CommandContext<class_2168> context) {
        ConfigCommand.sendFeedback(context, "Usage: /dailyrewards config [OPTION]\n\n- reload   Reloads the config file!\n- reset    Resets the config file and clean the data!!.\n- clear    Cleans the config file and clear all data!!!\n");
        return 0;
    }

    public int reloadConfig(CommandContext<class_2168> context) {
        ConfigCommand.sendFeedback(context, "Reset caching after reload config ...\nIf your changes are not visible, please try to save the file 2-3 times again to trigger the automatic reload!\nIf this is still not working, please restart the game / server instead.");
        ModConfigs.registerConfigs();
        return 0;
    }

    public int resetConfig(CommandContext<class_2168> context) {
        ConfigCommand.sendFeedback(context, "Reset reward and reward user config for current month!");
        RewardData.get().resetRewardDataForCurrentMonth();
        RewardUserData.get().resetRewardUserDataForCurrentMonth();
        SpecialRewardUserData.get().resetRewardUserDataForCurrentMonth();
        ConfigCommand.sendFeedback(context, "Regenerate reward for current month!");
        List<class_1799> rewardsForCurrentMonth = RewardData.get().getRewardsForCurrentMonth();
        List<class_1799> specialRewardsForCurrentMonth = RewardData.get().getSpecialRewardsForCurrentMonth();
        if (!rewardsForCurrentMonth.isEmpty()) {
            ConfigCommand.sendFeedback(context, "Rewards for this Month: " + rewardsForCurrentMonth);
        }
        if (!specialRewardsForCurrentMonth.isEmpty()) {
            ConfigCommand.sendFeedback(context, "Special Rewards for this Month: " + specialRewardsForCurrentMonth);
        }
        return 0;
    }

    public int clearConfig(CommandContext<class_2168> context) {
        ConfigCommand.sendFeedback(context, "Reset all reward and reward user data!");
        RewardData.get().clearRewardData();
        RewardUserData.get().clearRewardUserData();
        SpecialRewardUserData.get().clearRewardUserData();
        ConfigCommand.sendFeedback(context, "Regenerate reward for current month!");
        List<class_1799> rewardsForCurrentMonth = RewardData.get().getRewardsForCurrentMonth();
        List<class_1799> specialRewardsForCurrentMonth = RewardData.get().getSpecialRewardsForCurrentMonth();
        if (!rewardsForCurrentMonth.isEmpty()) {
            ConfigCommand.sendFeedback(context, "Rewards for this Month: " + rewardsForCurrentMonth);
        }
        if (!specialRewardsForCurrentMonth.isEmpty()) {
            ConfigCommand.sendFeedback(context, "Special Rewards for this Month: " + specialRewardsForCurrentMonth);
        }
        return 0;
    }
}

