/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.dailyrewards.commands.CustomCommand;
import de.markusbordihn.dailyrewards.data.RewardData;
import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.rewards.Rewards;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class RewardCommand
extends CustomCommand {
    private static final RewardCommand command = new RewardCommand();
    private static final String PLAYER_ARGUMENT = "player";
    private static final class_5250 claimCommand = class_2561.method_43470((String)"/DailyRewards claim").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/DailyRewards claim")));

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reward").requires(cs -> cs.method_9259(2))).executes((Command)command)).then(class_2170.method_9247((String)"today").then(class_2170.method_9244((String)PLAYER_ARGUMENT, (ArgumentType)class_2186.method_9305()).executes(context -> RewardCommand.rewardPlayerToday((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)PLAYER_ARGUMENT)))))).executes((Command)command)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)PLAYER_ARGUMENT, (ArgumentType)class_2186.method_9305()).executes(context -> RewardCommand.addRewardForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)PLAYER_ARGUMENT)))))).executes((Command)command)).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)PLAYER_ARGUMENT, (ArgumentType)class_2186.method_9305()).executes(context -> RewardCommand.listRewardForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)PLAYER_ARGUMENT)))))).executes((Command)command)).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)PLAYER_ARGUMENT, (ArgumentType)class_2186.method_9305()).executes(context -> RewardCommand.removeRewardForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)PLAYER_ARGUMENT)))))).executes((Command)command)).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)PLAYER_ARGUMENT, (ArgumentType)class_2186.method_9305()).executes(context -> RewardCommand.clearRewardForPlayer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)PLAYER_ARGUMENT)))));
    }

    private static int listRewardForPlayer(class_2168 context, class_3222 player) {
        RewardData rewardData = RewardData.get();
        RewardUserData rewardUserData = RewardUserData.get();
        UUID playerUUID = player.method_5667();
        int daysCurrentMonth = Rewards.getDaysCurrentMonth();
        int rewardedDays = rewardUserData.getRewardedDaysForCurrentMonth(playerUUID);
        String lastRewardedDay = rewardUserData.getLastRewardedDayForCurrentMonth(playerUUID);
        List<class_1799> rewards = rewardUserData.getRewardsForCurrentMonth(playerUUID);
        class_5250 textComponent = class_2561.method_43470((String)"Rewards for ").method_10852(player.method_5477()).method_27693(" (").method_27693(rewardedDays + " of " + daysCurrentMonth + " days").method_27693(" / ").method_27693(lastRewardedDay).method_27693(")");
        context.method_9226(() -> textComponent, true);
        class_5250 rewardComponent = class_2561.method_43470((String)"");
        int rewardDay = 0;
        for (class_1799 reward : rewards) {
            rewardComponent.method_10852((class_2561)class_2561.method_43470((String)("[" + ++rewardDay + "] ")).method_27696(class_2583.field_24360.method_10977(rewardDay == rewards.size() ? class_124.field_1061 : class_124.field_1065))).method_10852((class_2561)class_2561.method_43470((String)("" + reward)).method_27696(class_2583.field_24360.method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)(" (" + reward.method_7909() + ")\n")).method_27696(class_2583.field_24360.method_10977(class_124.field_1080)));
        }
        List<class_1799> previewRewards = rewardData.getRewardsForTheNextDays(rewardedDays, 3);
        for (class_1799 previewReward : previewRewards) {
            rewardComponent.method_10852((class_2561)class_2561.method_43470((String)("[" + ++rewardDay + "] ")).method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)("" + previewReward)).method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)(" (" + previewReward.method_7909() + ")\n")).method_27696(class_2583.field_24360.method_10977(class_124.field_1080)));
        }
        rewardComponent.method_10852((class_2561)class_2561.method_43470((String)"..."));
        context.method_9226(() -> rewardComponent, true);
        return 0;
    }

    private static int rewardPlayerToday(class_2168 context, class_3222 player) {
        UUID playerUUID;
        RewardUserData rewardUserData = RewardUserData.get();
        if (rewardUserData.hasRewardedToday(playerUUID = player.method_5667())) {
            context.method_9213((class_2561)class_2561.method_43469((String)"text.daily_rewards.player_already_rewarded_today", (Object[])new Object[]{player.method_5477()}));
            return 0;
        }
        return RewardCommand.addRewardForPlayer(context, player);
    }

    private static int addRewardForPlayer(class_2168 context, class_3222 player) {
        UUID playerUUID;
        RewardUserData rewardUserData = RewardUserData.get();
        if (!rewardUserData.hasRewardedToday(playerUUID = player.method_5667())) {
            rewardUserData.setLastRewardedDayForCurrentMonth(playerUUID);
        }
        int rewardedDays = rewardUserData.increaseRewardedDaysForCurrentMonth(playerUUID);
        class_1799 itemStack = RewardData.get().getRewardForCurrentMonth(rewardedDays);
        if (itemStack.method_7960()) {
            context.method_9213((class_2561)class_2561.method_43469((String)"text.daily_rewards.rewarded_item_empty", (Object[])new Object[]{player.method_5477(), rewardedDays, itemStack}));
        } else {
            rewardUserData.addRewardForCurrentMonth(rewardedDays, playerUUID, itemStack);
            player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.rewarded_item", (Object[])new Object[]{player.method_5477(), itemStack, rewardedDays}));
            player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.claim_rewards", (Object[])new Object[]{claimCommand}));
        }
        context.method_9226(() -> class_2561.method_43470((String)"Reward granted for ").method_10852(player.method_5477()).method_27693(" (").method_27693("" + rewardedDays).method_27693(" / ").method_27693(rewardUserData.getLastRewardedDayForCurrentMonth(playerUUID)).method_27693(")"), true);
        return 0;
    }

    private static int removeRewardForPlayer(class_2168 context, class_3222 player) {
        UUID playerUUID;
        RewardUserData rewardUserData = RewardUserData.get();
        if (!rewardUserData.hasRewardedToday(playerUUID = player.method_5667())) {
            rewardUserData.setLastRewardedDayForCurrentMonth(playerUUID);
        }
        int rewardedDays = rewardUserData.decreaseRewardedDaysForCurrentMonth(playerUUID);
        class_1799 itemStack = RewardData.get().getRewardForCurrentMonth(rewardedDays);
        if (itemStack.method_7960()) {
            context.method_9213((class_2561)class_2561.method_43469((String)"text.daily_rewards.rewarded_item_empty", (Object[])new Object[]{player.method_5477(), rewardedDays, itemStack}));
        } else if (rewardedDays >= 0) {
            rewardUserData.removeRewardForCurrentMonth(++rewardedDays, playerUUID);
        }
        int finalRewardedDays = rewardedDays;
        context.method_9226(() -> class_2561.method_43470((String)"Reward removed for ").method_10852(player.method_5477()).method_27693(" (").method_27693("" + finalRewardedDays).method_27693(" / ").method_27693(rewardUserData.getLastRewardedDayForCurrentMonth(playerUUID)).method_27693(")"), true);
        return 0;
    }

    private static int clearRewardForPlayer(class_2168 context, class_3222 player) {
        RewardUserData rewardUserData = RewardUserData.get();
        UUID playerUUID = player.method_5667();
        rewardUserData.clearRewardsForCurrentMonth(playerUUID);
        context.method_9226(() -> class_2561.method_43470((String)"Rewards cleared for ").method_10852(player.method_5477()), true);
        return 0;
    }

    public int run(CommandContext<class_2168> context) {
        return 0;
    }
}

