/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Config {
    protected static final String root = "config%s%s%s".formatted(File.separator, "daily_rewards", File.separator);
    protected static final String extension = ".json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger log = LogManager.getLogger((String)"Daily Rewards");

    public abstract String getPath();

    protected abstract void reset();

    private File getConfigFile() {
        return new File(root + this.getPath() + extension);
    }

    public void write() throws IOException {
        File dir = new File(root);
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        if (!this.getConfigFile().exists() && !this.getConfigFile().createNewFile()) {
            return;
        }
        FileWriter writer = new FileWriter(this.getConfigFile());
        GSON.toJson((Object)this, (Appendable)writer);
        writer.flush();
        writer.close();
    }

    public <T extends Config> T read() {
        try {
            return (T)((Config)GSON.fromJson((Reader)new FileReader(this.getConfigFile()), this.getClass()));
        }
        catch (FileNotFoundException ignored) {
            this.reset();
            try {
                this.write();
            }
            catch (IOException e) {
                log.error("Failed to write default config file: {}", (Object)this.getConfigFile(), (Object)e);
            }
            return (T)this;
        }
    }
}

