/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.data;

import de.markusbordihn.dailyrewards.rewards.Rewards;
import de.markusbordihn.dailyrewards.rewards.SpecialRewards;
import dev.architectury.utils.GameInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardData
extends class_18 {
    public static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    public static final String SPECIAL_REWARDS_TAG = "SpecialRewards";
    public static final String ITEMS_TAG = "RewardItems";
    public static final String ITEM_LIST_TAG = "ItemList";
    public static final String REWARDS_TAG = "Rewards";
    public static final String YEAR_MONTH_TAG = "YearMonth";
    private static final String FILE_ID = "daily_rewards";
    private static final ConcurrentHashMap<String, List<class_1799>> rewardItemsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<class_1799>> specialRewardItemsMap = new ConcurrentHashMap();
    private static MinecraftServer server;
    private static RewardData data;

    public RewardData() {
        this.method_80();
    }

    public static void prepare(MinecraftServer server) {
        if (server == null || server == RewardData.server && data != null) {
            return;
        }
        log.info("{} preparing reward data for {}", (Object)"Daily Rewards", (Object)server);
        RewardData.server = server;
        class_3218 serverLevel = server.method_3847(class_1937.field_25179);
        if (serverLevel != null) {
            data = (RewardData)serverLevel.method_17983().method_17924(RewardData::load, RewardData::new, RewardData.getFileId());
        } else {
            log.error("{} unable to get server level {} for storing data!", (Object)"Daily Rewards", (Object)serverLevel);
        }
    }

    public static boolean available() {
        RewardData.get();
        return data != null;
    }

    public static RewardData get() {
        if (data == null) {
            RewardData.prepare(GameInstance.getServer());
        }
        return data;
    }

    public static String getFileId() {
        return FILE_ID;
    }

    public static String getKeyId(int year, int month) {
        return year + "-" + month;
    }

    public static List<class_1799> getRewardsForCurrentMonthSyncData(class_2487 compoundTag) {
        ArrayList<class_1799> rewardItems = new ArrayList<class_1799>();
        if (compoundTag.method_10545(ITEM_LIST_TAG)) {
            class_2499 itemListTag = compoundTag.method_10554(ITEM_LIST_TAG, 10);
            for (int i = 0; i < itemListTag.size(); ++i) {
                class_1799 itemStack = class_1799.method_7915((class_2487)itemListTag.method_10602(i));
                rewardItems.add(itemStack);
            }
        } else {
            log.error("Unable to load rewards for current month data from {}!", (Object)compoundTag);
        }
        return rewardItems;
    }

    public static List<class_1799> getSpecialRewardsForCurrentMonthSyncData(class_2487 compoundTag) {
        ArrayList<class_1799> rewardItems = new ArrayList<class_1799>();
        if (compoundTag.method_10545(ITEM_LIST_TAG)) {
            class_2499 itemListTag = compoundTag.method_10554(ITEM_LIST_TAG, 10);
            for (int i = 0; i < itemListTag.size(); ++i) {
                class_1799 itemStack = class_1799.method_7915((class_2487)itemListTag.method_10602(i));
                rewardItems.add(itemStack);
            }
        } else {
            log.error("Unable to load special rewards for current month data from {}!", (Object)compoundTag);
        }
        return rewardItems;
    }

    public static RewardData load(class_2487 compoundTag) {
        class_1799 itemStack;
        int i2;
        String yearMonthKey;
        class_2499 itemListTag;
        ArrayList<class_1799> rewardItems;
        class_2487 rewardTag;
        int i;
        class_2499 listTag;
        RewardData rewardData = new RewardData();
        log.info("{} loading reward data ... {}", (Object)"Daily Rewards", (Object)compoundTag);
        if (compoundTag.method_10545(REWARDS_TAG)) {
            listTag = compoundTag.method_10554(REWARDS_TAG, 10);
            for (i = 0; i < listTag.size(); ++i) {
                rewardTag = listTag.method_10602(i);
                rewardItems = new ArrayList<class_1799>();
                itemListTag = rewardTag.method_10554(ITEMS_TAG, 10);
                yearMonthKey = rewardTag.method_10558(YEAR_MONTH_TAG);
                for (i2 = 0; i2 < itemListTag.size(); ++i2) {
                    itemStack = class_1799.method_7915((class_2487)itemListTag.method_10602(i2));
                    rewardItems.add(itemStack);
                }
                rewardItemsMap.put(yearMonthKey, rewardItems);
            }
        }
        if (rewardItemsMap.isEmpty()) {
            log.warn("{} No stored rewards data found! This could be ignored on the first start.", (Object)"Daily Rewards");
        } else {
            log.debug("{} Loaded stored rewards data from disk: {}", (Object)"Daily Rewards", rewardItemsMap);
        }
        if (compoundTag.method_10545(SPECIAL_REWARDS_TAG)) {
            listTag = compoundTag.method_10554(SPECIAL_REWARDS_TAG, 10);
            for (i = 0; i < listTag.size(); ++i) {
                rewardTag = listTag.method_10602(i);
                rewardItems = new ArrayList();
                itemListTag = rewardTag.method_10554(ITEMS_TAG, 10);
                yearMonthKey = rewardTag.method_10558(YEAR_MONTH_TAG);
                for (i2 = 0; i2 < itemListTag.size(); ++i2) {
                    itemStack = class_1799.method_7915((class_2487)itemListTag.method_10602(i2));
                    rewardItems.add(itemStack);
                }
                specialRewardItemsMap.put(yearMonthKey, rewardItems);
            }
        }
        if (!specialRewardItemsMap.isEmpty()) {
            log.debug("{} Loaded stored special rewards data from disk: {}", (Object)"Daily Rewards", specialRewardItemsMap);
        }
        return rewardData;
    }

    public List<class_1799> getRewardsFor(int year, int month) {
        String key = RewardData.getKeyId(year, month);
        List<class_1799> rewards = rewardItemsMap.get(key);
        if (rewards != null && rewards.isEmpty()) {
            rewardItemsMap.remove(key);
        }
        return rewardItemsMap.computeIfAbsent(key, id -> Rewards.calculateRewardItemsForMonth(month));
    }

    public List<class_1799> getRewardsForMonth(int month) {
        return this.getRewardsFor(Rewards.getCurrentYear(), month);
    }

    public List<class_1799> getRewardsForCurrentMonth() {
        return this.getRewardsFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth());
    }

    public List<class_1799> getRewardsForTheNextDays(int rewardedDay, int nextDays) {
        List<class_1799> rewardItems = this.getRewardsForCurrentMonth();
        ArrayList<class_1799> rewardItemsForNextDays = new ArrayList<class_1799>();
        for (int i = rewardedDay; i < rewardedDay + nextDays && i < rewardItems.size(); ++i) {
            rewardItemsForNextDays.add(rewardItems.get(i));
        }
        return rewardItemsForNextDays;
    }

    public class_2487 getRewardsForCurrentMonthSyncData() {
        List<class_1799> rewardItems = this.getRewardsForCurrentMonth();
        class_2487 syncData = new class_2487();
        class_2499 itemListTag = new class_2499();
        for (class_1799 itemStack : rewardItems) {
            class_2487 itemStackTag = new class_2487();
            itemStack.method_7953(itemStackTag);
            itemListTag.add((Object)itemStackTag);
        }
        syncData.method_10566(ITEM_LIST_TAG, (class_2520)itemListTag);
        return syncData;
    }

    public class_1799 getRewardForCurrentMonth(int day) {
        int rewardIndex;
        List<class_1799> rewards = this.getRewardsForCurrentMonth();
        if ((rewardIndex = --day) >= 0 && rewards.size() > rewardIndex) {
            return rewards.get(rewardIndex).method_7972();
        }
        return class_1799.field_8037;
    }

    public List<class_1799> getSpecialRewardsFor(int year, int month) {
        String key = RewardData.getKeyId(year, month);
        List<class_1799> specialRewards = specialRewardItemsMap.get(key);
        if (specialRewards != null && specialRewards.isEmpty()) {
            specialRewardItemsMap.remove(key);
        }
        return specialRewardItemsMap.computeIfAbsent(key, id -> SpecialRewards.calculateSpecialRewardItemsForMonth(month));
    }

    public List<class_1799> getSpecialRewardsForMonth(int month) {
        return this.getSpecialRewardsFor(Rewards.getCurrentYear(), month);
    }

    public List<class_1799> getSpecialRewardsForCurrentMonth() {
        return this.getSpecialRewardsFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth());
    }

    public class_2487 getSpecialRewardsForCurrentMonthSyncData() {
        List<class_1799> rewardItems = this.getSpecialRewardsForCurrentMonth();
        class_2487 syncData = new class_2487();
        class_2499 itemListTag = new class_2499();
        for (class_1799 itemStack : rewardItems) {
            class_2487 itemStackTag = new class_2487();
            itemStack.method_7953(itemStackTag);
            itemListTag.add((Object)itemStackTag);
        }
        syncData.method_10566(ITEM_LIST_TAG, (class_2520)itemListTag);
        return syncData;
    }

    public class_1799 getSpecialRewardForCurrentMonth(int day) {
        int rewardIndex;
        List<class_1799> rewards = this.getSpecialRewardsForCurrentMonth();
        if ((rewardIndex = --day) >= 0 && rewards.size() > rewardIndex) {
            return rewards.get(rewardIndex).method_7972();
        }
        return class_1799.field_8037;
    }

    public List<class_1799> getSpecialRewardsForTheNextDays(int rewardedDay, int nextDays) {
        List<class_1799> rewardItems = this.getSpecialRewardsForCurrentMonth();
        ArrayList<class_1799> rewardItemsForNextDays = new ArrayList<class_1799>();
        for (int i = rewardedDay; i < rewardedDay + nextDays && i < rewardItems.size(); ++i) {
            rewardItemsForNextDays.add(rewardItems.get(i));
        }
        return rewardItemsForNextDays;
    }

    public void resetRewardDataFor(int year, int month) {
        log.debug("{} Resetting reward data for {}-{} ...", (Object)"Daily Rewards", (Object)year, (Object)month);
        rewardItemsMap.get(RewardData.getKeyId(year, month)).clear();
        specialRewardItemsMap.get(RewardData.getKeyId(year, month)).clear();
    }

    public void resetRewardDataForCurrentMonth() {
        this.resetRewardDataFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth());
    }

    public void clearRewardData() {
        log.debug("{} Clearing reward data ...", (Object)"Daily Rewards");
        rewardItemsMap.clear();
        specialRewardItemsMap.clear();
        this.method_80();
    }

    public class_2487 method_75(class_2487 compoundTag) {
        log.info("{} saving reward data ... {}", (Object)"Daily Rewards", rewardItemsMap);
        class_2499 listTag = new class_2499();
        for (Map.Entry<String, List<class_1799>> reward : rewardItemsMap.entrySet()) {
            class_2487 rewardTag = new class_2487();
            List<class_1799> rewardItems = reward.getValue();
            class_2499 itemListTag = new class_2499();
            for (int i = 0; i < rewardItems.size(); ++i) {
                class_1799 itemStack = rewardItems.get(i);
                if (itemStack.method_7960()) {
                    log.error("Reward item for month {} and day {} is empty, will fill item!", (Object)reward.getKey(), (Object)i);
                    itemStack = Rewards.getNormalFillItem();
                }
                class_2487 itemStackTag = new class_2487();
                itemStack.method_7953(itemStackTag);
                itemListTag.add((Object)itemStackTag);
            }
            if (itemListTag.isEmpty()) continue;
            rewardTag.method_10582(YEAR_MONTH_TAG, reward.getKey());
            rewardTag.method_10566(ITEMS_TAG, (class_2520)itemListTag);
            listTag.add((Object)rewardTag);
        }
        compoundTag.method_10566(REWARDS_TAG, (class_2520)listTag);
        if (specialRewardItemsMap.isEmpty()) {
            log.info("{} No special rewards data found.", (Object)"Daily Rewards");
            return compoundTag;
        }
        log.info("{} saving special reward data ... {}", (Object)"Daily Rewards", specialRewardItemsMap);
        class_2499 specialListTag = new class_2499();
        for (Map.Entry<String, List<class_1799>> reward : specialRewardItemsMap.entrySet()) {
            class_2487 rewardTag = new class_2487();
            List<class_1799> rewardItems = reward.getValue();
            class_2499 itemListTag = new class_2499();
            for (int i = 0; i < rewardItems.size(); ++i) {
                class_1799 itemStack = rewardItems.get(i);
                if (itemStack.method_7960()) {
                    log.info("Special reward item for month {} and day {} is empty.", (Object)reward.getKey(), (Object)i);
                }
                class_2487 itemStackTag = new class_2487();
                itemStack.method_7953(itemStackTag);
                itemListTag.add((Object)itemStackTag);
            }
            if (itemListTag.isEmpty()) continue;
            rewardTag.method_10582(YEAR_MONTH_TAG, reward.getKey());
            rewardTag.method_10566(ITEMS_TAG, (class_2520)itemListTag);
            specialListTag.add((Object)rewardTag);
        }
        compoundTag.method_10566(SPECIAL_REWARDS_TAG, (class_2520)specialListTag);
        return compoundTag;
    }
}

