/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.data;

import de.markusbordihn.dailyrewards.item.ModItems;
import de.markusbordihn.dailyrewards.rewards.Rewards;
import dev.architectury.utils.GameInstance;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardUserData
extends class_18 {
    public static final String ITEMS_TAG = "RewardItems";
    public static final String ITEM_LIST_TAG = "ItemList";
    public static final String LAST_REWARDED_DAY_TAG = "LastRewardedDay";
    public static final String REWARDED_DAYS_TAG = "RewardedDays";
    public static final String USER_REWARDS_TAG = "UserRewards";
    public static final String YEAR_MONTH_TAG = "YearMonth";
    public static final String YEAR_MONTH_USER_TAG = "YearMonthUser";
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    private static final String FILE_ID = "daily_rewards_user";
    private static final HashSet<UUID> rewardPlayers = new HashSet();
    private static final ConcurrentHashMap<String, List<class_1799>> rewardItemsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Integer> rewardedDaysMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> lastRewardedDayMap = new ConcurrentHashMap();
    private static MinecraftServer server;
    private static RewardUserData data;

    public RewardUserData() {
        this.method_80();
    }

    public static void prepare(MinecraftServer server) {
        if (server == null || server == RewardUserData.server && data != null) {
            return;
        }
        log.info("{} preparing reward user data for {}", (Object)"Daily Rewards", (Object)server);
        RewardUserData.server = server;
        class_3218 serverLevel = server.method_3847(class_1937.field_25179);
        if (serverLevel != null) {
            data = (RewardUserData)serverLevel.method_17983().method_17924(RewardUserData::load, RewardUserData::new, RewardUserData.getFileId());
        } else {
            log.error("{} unable to get server level {} for storing data!", (Object)"Daily Rewards", (Object)serverLevel);
        }
    }

    public static boolean available() {
        RewardUserData.get();
        return data != null;
    }

    public static RewardUserData get() {
        if (data == null) {
            RewardUserData.prepare(GameInstance.getServer());
        }
        return data;
    }

    public static String getFileId() {
        return FILE_ID;
    }

    public static String getKeyId(int year, int month, UUID uuid) {
        return year + "-" + month + ":" + uuid.toString();
    }

    public static UUID getUUIDfromKeyId(String key) {
        String[] keyParts;
        if (key != null && key.contains(":") && (keyParts = key.split(":")).length == 2) {
            return UUID.fromString(keyParts[1]);
        }
        return null;
    }

    public static List<class_1799> getRewardsForCurrentMonthSyncData(class_2487 compoundTag) {
        ArrayList<class_1799> rewardItems = new ArrayList<class_1799>();
        if (compoundTag.method_10545(ITEM_LIST_TAG)) {
            class_2499 itemListTag = compoundTag.method_10554(ITEM_LIST_TAG, 10);
            for (int i = 0; i < itemListTag.size(); ++i) {
                class_1799 itemStack = class_1799.method_7915((class_2487)itemListTag.method_10602(i));
                rewardItems.add(itemStack);
            }
        }
        return rewardItems;
    }

    public static RewardUserData load(class_2487 compoundTag) {
        RewardUserData rewardData = new RewardUserData();
        log.info("{} loading reward user data ... {}", (Object)"Daily Rewards", (Object)compoundTag);
        if (compoundTag.method_10545(USER_REWARDS_TAG)) {
            class_2499 listTag = compoundTag.method_10554(USER_REWARDS_TAG, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 rewardUserTag = listTag.method_10602(i);
                String rewardKey = rewardUserTag.method_10558(YEAR_MONTH_USER_TAG);
                int rewardedDays = rewardUserTag.method_10550(REWARDED_DAYS_TAG);
                String lastRewardedDay = rewardUserTag.method_10558(LAST_REWARDED_DAY_TAG);
                UUID uuid = RewardUserData.getUUIDfromKeyId(rewardKey);
                if (uuid != null) {
                    rewardPlayers.add(uuid);
                }
                ArrayList<class_1799> rewardItems = new ArrayList<class_1799>();
                class_2499 itemListTag = rewardUserTag.method_10554(ITEMS_TAG, 10);
                for (int i2 = 0; i2 < itemListTag.size(); ++i2) {
                    class_1799 itemStack = class_1799.method_7915((class_2487)itemListTag.method_10602(i2));
                    rewardItems.add(itemStack);
                }
                rewardItemsMap.put(rewardKey, rewardItems);
                if (rewardedDays > itemListTag.size()) {
                    log.error("{} Invalid rewarded days {} for {}! Resetting to {}.", (Object)"Daily Rewards", (Object)rewardedDays, (Object)rewardKey, (Object)itemListTag.size());
                    rewardedDays = itemListTag.size();
                }
                if (rewardedDays == 0 && !lastRewardedDay.isEmpty()) {
                    log.error("{} Invalid last rewarded day {} for {}! Resetting to empty.", (Object)"Daily Rewards", (Object)lastRewardedDay, (Object)rewardKey);
                    lastRewardedDay = "";
                }
                rewardedDaysMap.put(rewardKey, rewardedDays);
                lastRewardedDayMap.put(rewardKey, lastRewardedDay);
            }
        }
        log.debug("{} Loaded stored rewards user data from disk: {}", (Object)"Daily Rewards", (Object)rewardData);
        return rewardData;
    }

    public void addRewardFor(int year, int month, int day, UUID uuid, class_1799 itemStack) {
        int rewardIndex;
        List<class_1799> rewards = this.getRewardsFor(year, month, uuid);
        if ((rewardIndex = --day) >= 0 && rewards.size() > rewardIndex) {
            rewards.add(rewardIndex, itemStack);
        } else {
            rewards.add(itemStack);
        }
        rewardPlayers.add(uuid);
        this.method_80();
    }

    public void addRewardForCurrentMonth(int day, UUID uuid, class_1799 itemStack) {
        this.addRewardFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), day, uuid, itemStack);
    }

    public List<class_1799> getRewardsFor(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        rewardPlayers.add(uuid);
        return rewardItemsMap.computeIfAbsent(key, id -> new ArrayList());
    }

    public void removeRewardFor(int year, int month, int day, UUID uuid) {
        int rewardIndex;
        List<class_1799> rewards = this.getRewardsFor(year, month, uuid);
        if ((rewardIndex = --day) >= 0 && rewards.size() > rewardIndex) {
            rewards.remove(rewardIndex);
        }
        this.method_80();
    }

    public void removeRewardForCurrentMonth(int day, UUID uuid) {
        this.removeRewardFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), day, uuid);
    }

    public List<class_1799> getRewardsForCurrentMonth(UUID uuid) {
        return this.getRewardsFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public boolean hasUnclaimedRewardsForCurrentMonth(UUID uuid) {
        List<class_1799> rewardItemStack = this.getRewardsForCurrentMonth(uuid);
        for (class_1799 itemStack : rewardItemStack) {
            if (itemStack.method_7960() || itemStack.method_31574((class_1792)ModItems.TAKEN_REWARD.get())) continue;
            return true;
        }
        return false;
    }

    public class_2487 getRewardsForCurrentMonthSyncData(UUID uuid) {
        List<class_1799> rewardItems = this.getRewardsForCurrentMonth(uuid);
        class_2487 syncData = new class_2487();
        class_2499 itemListTag = new class_2499();
        for (class_1799 itemStack : rewardItems) {
            class_2487 itemStackTag = new class_2487();
            itemStack.method_7953(itemStackTag);
            itemListTag.add((Object)itemStackTag);
        }
        syncData.method_10566(ITEM_LIST_TAG, (class_2520)itemListTag);
        return syncData;
    }

    public void setRewardsForCurrentMonth(UUID uuid, List<class_1799> rewardItems) {
        this.setRewardsFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid, rewardItems);
    }

    public void setRewardsFor(int year, int month, UUID uuid, List<class_1799> rewardItems) {
        log.debug("Set rewards for {}-{} and player {} to: {}", (Object)year, (Object)month, (Object)uuid, rewardItems);
        String key = RewardUserData.getKeyId(year, month, uuid);
        rewardPlayers.add(uuid);
        rewardItemsMap.put(key, rewardItems);
        this.method_80();
    }

    public String getLastRewardedDay(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        return lastRewardedDayMap.computeIfAbsent(key, id -> "");
    }

    public String getLastRewardedDayForCurrentMonth(UUID uuid) {
        return this.getLastRewardedDay(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public void setLastRewardedDay(int year, int month, UUID uuid, String lastRewardedDay) {
        log.debug("Set last rewarded day for {}-{} and player {} to {}", (Object)year, (Object)month, (Object)uuid, (Object)lastRewardedDay);
        String key = RewardUserData.getKeyId(year, month, uuid);
        rewardPlayers.add(uuid);
        lastRewardedDayMap.put(key, lastRewardedDay);
        this.method_80();
    }

    public void setLastRewardedDayForCurrentMonth(UUID uuid) {
        this.setLastRewardedDay(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid, Rewards.getCurrentYearMonthDay());
    }

    public boolean hasRewardedToday(UUID uuid) {
        String lastRewardedDay = this.getLastRewardedDayForCurrentMonth(uuid);
        return Rewards.getCurrentYearMonthDay().equals(lastRewardedDay);
    }

    public int getRewardedDays(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        return rewardedDaysMap.getOrDefault(key, 0);
    }

    public int getRewardedDaysForCurrentMonth(UUID uuid) {
        return this.getRewardedDays(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public int increaseRewardedDays(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        int daysPerMonth = Rewards.getDaysPerMonth(year, month);
        int rewardedDays = rewardedDaysMap.getOrDefault(key, 0);
        if (rewardedDays < daysPerMonth) {
            rewardedDaysMap.put(key, ++rewardedDays);
            rewardPlayers.add(uuid);
            this.method_80();
        }
        return rewardedDays;
    }

    public int increaseRewardedDaysForCurrentMonth(UUID uuid) {
        return this.increaseRewardedDays(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public int decreaseRewardedDays(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        int rewardedDays = rewardedDaysMap.getOrDefault(key, 0);
        if (rewardedDays > 0) {
            rewardedDaysMap.put(key, --rewardedDays);
            rewardPlayers.add(uuid);
            this.method_80();
        }
        return rewardedDays;
    }

    public int decreaseRewardedDaysForCurrentMonth(UUID uuid) {
        return this.decreaseRewardedDays(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public void clearRewards(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        rewardItemsMap.remove(key);
        rewardedDaysMap.remove(key);
        lastRewardedDayMap.remove(key);
        this.method_80();
    }

    public void clearRewardsForCurrentMonth(UUID uuid) {
        this.clearRewards(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public void resetRewardUserDataForCurrentMonth() {
        this.resetRewardUserDataFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth());
    }

    public void resetRewardUserDataFor(int year, int month) {
        log.info("{} Resetting reward user data for {}-{} ...", (Object)"Daily Rewards", (Object)year, (Object)month);
        for (UUID uuid : rewardPlayers) {
            this.clearRewards(year, month, uuid);
        }
        this.method_80();
    }

    public void clearRewardUserData() {
        log.info("{} Clearing reward user data ...", (Object)"Daily Rewards");
        rewardPlayers.clear();
        rewardItemsMap.clear();
        rewardedDaysMap.clear();
        lastRewardedDayMap.clear();
        this.method_80();
    }

    public class_2487 method_75(class_2487 compoundTag) {
        HashSet rewardKeys = new HashSet();
        rewardKeys.addAll(rewardItemsMap.keySet());
        rewardKeys.addAll(rewardedDaysMap.keySet());
        rewardKeys.addAll(lastRewardedDayMap.keySet());
        if (rewardKeys.isEmpty()) {
            log.warn("{} unable to save reward user data, because data are empty!", (Object)"Daily Rewards");
            return compoundTag;
        }
        log.info("{} saving reward user data for {} ...", (Object)"Daily Rewards", rewardKeys);
        class_2499 listTag = new class_2499();
        compoundTag.method_10566(USER_REWARDS_TAG, (class_2520)listTag);
        for (String rewardKey : rewardKeys) {
            class_2487 rewardUserTag = new class_2487();
            rewardUserTag.method_10582(YEAR_MONTH_USER_TAG, rewardKey);
            class_2499 itemListTag = new class_2499();
            List<class_1799> rewardItems = rewardItemsMap.get(rewardKey);
            for (class_1799 itemStack : rewardItems) {
                class_2487 itemStackTag = new class_2487();
                itemStack.method_7953(itemStackTag);
                itemListTag.add((Object)itemStackTag);
            }
            rewardUserTag.method_10566(ITEMS_TAG, (class_2520)itemListTag);
            rewardUserTag.method_10569(REWARDED_DAYS_TAG, rewardedDaysMap.getOrDefault(rewardKey, 0).intValue());
            rewardUserTag.method_10582(LAST_REWARDED_DAY_TAG, lastRewardedDayMap.getOrDefault(rewardKey, ""));
            listTag.add((Object)rewardUserTag);
        }
        return compoundTag;
    }
}

