/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.menu;

import de.markusbordihn.dailyrewards.config.ModConfigs;
import de.markusbordihn.dailyrewards.data.RewardData;
import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.data.SpecialRewardUserData;
import de.markusbordihn.dailyrewards.menu.ModMenuTypes;
import de.markusbordihn.dailyrewards.menu.RewardMenu;
import de.markusbordihn.dailyrewards.menu.slots.EmptyRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.HiddenRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.RewardSlot;
import de.markusbordihn.dailyrewards.rewards.Rewards;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class RewardCompactMenu
extends RewardMenu {
    public static final int PLAYER_SLOT_START = 9;
    public static final int PLAYER_INVENTORY_SLOT_START = 9;
    public static final int PLAYER_SLOT_STOP = 44;
    public static final float REWARD_SLOT_SIZE_X = 20.5f;
    public static final int REWARD_SLOT_SIZE_Y = 31;
    public static final int REWARD_SLOT_START_POSITION_X = 10;
    public static final int REWARD_SLOT_START_POSITION_Y = 45;
    public static final int REWARD_SLOT_SPACE_X = 2;
    private static final int containerSize = 32;
    private static final int slotSize = 18;
    private final class_1263 rewardsContainer = new class_1277(32);
    private final class_1263 rewardsUserContainer = new class_1277(32);
    private final class_1263 specialRewardsContainer = new class_1277(32);
    private final class_1263 specialRewardsUserContainer = new class_1277(32);
    private List<class_1799> rewardsForCurrentMonth = new ArrayList<class_1799>();
    private List<class_1799> userRewardsForCurrentMonth = new ArrayList<class_1799>();
    private List<class_1799> specialRewardsForCurrentMonth = new ArrayList<class_1799>();
    private List<class_1799> userSpecialRewardsForCurrentMonth = new ArrayList<class_1799>();

    public RewardCompactMenu(int windowId, class_1661 playerInventory) {
        this(windowId, playerInventory, (class_3917)ModMenuTypes.REWARD_COMPACT_MENU.get(), playerInventory.field_7546.method_5667(), RewardUserData.get().getRewardedDaysForCurrentMonth(playerInventory.field_7546.method_5667()), RewardUserData.get().getLastRewardedDayForCurrentMonth(playerInventory.field_7546.method_5667()), RewardUserData.get().getRewardsForCurrentMonthSyncData(playerInventory.field_7546.method_5667()), RewardData.get().getRewardsForCurrentMonthSyncData(), SpecialRewardUserData.get().getRewardedDaysForCurrentMonth(playerInventory.field_7546.method_5667()), SpecialRewardUserData.get().getLastRewardedDayForCurrentMonth(playerInventory.field_7546.method_5667()), SpecialRewardUserData.get().getRewardsForCurrentMonthSyncData(playerInventory.field_7546.method_5667()), RewardData.get().getSpecialRewardsForCurrentMonthSyncData());
    }

    public RewardCompactMenu(int windowId, class_1661 playerInventory, class_2540 data) {
        this(windowId, playerInventory, (class_3917)ModMenuTypes.REWARD_COMPACT_MENU.get(), data.method_10790(), data.readInt(), data.method_19772(), data.method_10798(), data.method_10798(), data.readInt(), data.method_19772(), data.method_10798(), data.method_10798());
    }

    public RewardCompactMenu(int windowId, class_1661 playerInventory, class_3917<?> menuType, UUID playerUUID, int rewardedDays, String lastRewardedDay, class_2487 userRewardsForCurrentMonth, class_2487 rewardsForCurrentMonth, int specialRewardedDays, String lastSpecialRewardedDay, class_2487 specialUserRewardsForCurrentMonth, class_2487 specialRewardsForCurrentMonth) {
        super(menuType, windowId, playerInventory);
        class_1799 itemStack;
        int slotIndex;
        int index;
        this.playerUUID = playerUUID;
        if (this.playerUUID == null || this.player.method_5667() == null || !this.playerUUID.equals(this.player.method_5667())) {
            log.error("{} Unable to verify player {} with UUID {}!", (Object)"Daily Rewards", (Object)this.player, (Object)this.playerUUID);
            return;
        }
        this.rewardedDays = rewardedDays;
        this.lastRewardedDay = lastRewardedDay;
        this.rewardsForCurrentMonth = RewardData.getRewardsForCurrentMonthSyncData(rewardsForCurrentMonth);
        if (!rewardsForCurrentMonth.method_33133()) {
            for (index = 0; index < this.rewardsForCurrentMonth.size(); ++index) {
                this.rewardsContainer.method_5447(index, this.rewardsForCurrentMonth.get(index));
            }
        }
        this.userRewardsForCurrentMonth = RewardUserData.getRewardsForCurrentMonthSyncData(userRewardsForCurrentMonth);
        if (!this.userRewardsForCurrentMonth.isEmpty()) {
            for (index = 0; index < this.userRewardsForCurrentMonth.size(); ++index) {
                this.rewardsUserContainer.method_5447(index, this.userRewardsForCurrentMonth.get(index));
            }
        }
        this.rewardedSpecialDays = specialRewardedDays;
        this.lastRewardedSpecialDay = lastSpecialRewardedDay;
        this.specialRewardsForCurrentMonth = RewardData.getSpecialRewardsForCurrentMonthSyncData(specialRewardsForCurrentMonth);
        if (!specialRewardsForCurrentMonth.method_33133()) {
            for (index = 0; index < this.specialRewardsForCurrentMonth.size(); ++index) {
                this.specialRewardsContainer.method_5447(index, this.specialRewardsForCurrentMonth.get(index));
            }
        }
        this.userSpecialRewardsForCurrentMonth = SpecialRewardUserData.getRewardsForCurrentMonthSyncData(specialUserRewardsForCurrentMonth);
        if (!this.userSpecialRewardsForCurrentMonth.isEmpty()) {
            for (index = 0; index < this.userSpecialRewardsForCurrentMonth.size(); ++index) {
                this.specialRewardsUserContainer.method_5447(index, this.userSpecialRewardsForCurrentMonth.get(index));
            }
        }
        int numberOfDays = Rewards.getDaysCurrentMonth();
        int slotStartPositionX = 10;
        int slotStartPositionY = 45;
        int specialSlotStartPositionX = 10;
        int specialSlotStartPositionY = 110;
        int rewardIndexStart = Math.max(0, rewardedDays - 4);
        int rewardIndexStop = Math.min(numberOfDays, rewardedDays + 2);
        int specialRewardIndexStart = Math.max(0, specialRewardedDays - 4);
        int specialRewardIndexStop = Math.min(numberOfDays, specialRewardedDays + 2);
        if (!this.specialRewardAvailable) {
            slotStartPositionY += 30;
        }
        if (rewardIndexStop - rewardIndexStart == 5) {
            slotStartPositionX = 32;
        } else if (rewardIndexStop - rewardIndexStart == 4) {
            slotStartPositionX = 55;
        } else if (rewardIndexStop - rewardIndexStart == 3) {
            slotStartPositionX = 77;
        } else if (rewardIndexStop - rewardIndexStart == 2) {
            slotStartPositionX = 100;
        } else if (rewardIndexStop - rewardIndexStart == 1) {
            slotStartPositionX = 122;
        }
        for (slotIndex = rewardIndexStart; slotIndex <= rewardIndexStop; ++slotIndex) {
            if (this.userRewardsForCurrentMonth.size() > slotIndex) {
                try {
                    itemStack = this.userRewardsForCurrentMonth.get(slotIndex);
                }
                catch (Exception e) {
                    itemStack = class_1799.field_8037;
                }
                this.method_7621(this.createRewardSlot(itemStack, rewardedDays, this.rewardsUserContainer, slotIndex, slotStartPositionX, slotStartPositionY));
            } else if (this.rewardsForCurrentMonth.size() > slotIndex) {
                if (Boolean.TRUE.equals(ModConfigs.COMMON.previewRewardsItems)) {
                    this.method_7621(new RewardSlot(this.rewardsContainer, slotIndex, slotStartPositionX, slotStartPositionY));
                } else {
                    this.method_7621(new HiddenRewardSlot(this.rewardsContainer, slotIndex, slotStartPositionX, slotStartPositionY));
                }
            } else if (numberOfDays > slotIndex) {
                this.method_7621(new EmptyRewardSlot(this.rewardsContainer, slotIndex, slotStartPositionX, slotStartPositionY));
            }
            slotStartPositionX += 22;
        }
        if (this.specialRewardAvailable) {
            if (specialRewardIndexStop - specialRewardIndexStart == 5) {
                specialSlotStartPositionX = 32;
            } else if (specialRewardIndexStop - specialRewardIndexStart == 4) {
                specialSlotStartPositionX = 55;
            } else if (specialRewardIndexStop - specialRewardIndexStart == 3) {
                specialSlotStartPositionX = 77;
            } else if (specialRewardIndexStop - specialRewardIndexStart == 2) {
                specialSlotStartPositionX = 100;
            } else if (specialRewardIndexStop - specialRewardIndexStart == 1) {
                specialSlotStartPositionX = 122;
            }
            for (slotIndex = specialRewardIndexStart; slotIndex <= specialRewardIndexStop; ++slotIndex) {
                if (this.userSpecialRewardsForCurrentMonth.size() > slotIndex) {
                    try {
                        itemStack = this.userSpecialRewardsForCurrentMonth.get(slotIndex);
                    }
                    catch (Exception e) {
                        itemStack = class_1799.field_8037;
                    }
                    this.method_7621(this.createRewardSlot(itemStack, rewardedDays, this.specialRewardsUserContainer, slotIndex, specialSlotStartPositionX, specialSlotStartPositionY));
                } else if (this.rewardsForCurrentMonth.size() > slotIndex) {
                    if (Boolean.TRUE.equals(ModConfigs.COMMON.previewRewardsSpecialItems)) {
                        this.method_7621(new RewardSlot(this.specialRewardsContainer, slotIndex, specialSlotStartPositionX, specialSlotStartPositionY));
                    } else {
                        this.method_7621(new HiddenRewardSlot(this.specialRewardsContainer, slotIndex, specialSlotStartPositionX, specialSlotStartPositionY));
                    }
                } else if (numberOfDays > slotIndex) {
                    this.method_7621(new EmptyRewardSlot(this.specialRewardsContainer, slotIndex, specialSlotStartPositionX, specialSlotStartPositionY));
                }
                specialSlotStartPositionX += 22;
            }
        }
        int playerInventoryStartPositionY = 160;
        int playerInventoryStartPositionX = 8;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.method_7621(new class_1735((class_1263)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + inventoryColumn * 18, playerInventoryStartPositionY + inventoryRow * 18));
            }
        }
        int hotbarStartPositionY = 218;
        int hotbarStartPositionX = 8;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.method_7621(new class_1735((class_1263)playerInventory, playerInventorySlot, hotbarStartPositionX + playerInventorySlot * 18, hotbarStartPositionY));
        }
    }

    @Override
    public class_1263 getRewardsContainer() {
        return this.rewardsContainer;
    }

    @Override
    public class_1263 getRewardsUserContainer() {
        return this.rewardsUserContainer;
    }

    @Override
    public List<class_1799> getRewardsForCurrentMonth() {
        return this.rewardsForCurrentMonth;
    }

    @Override
    public List<class_1799> getUserRewardsForCurrentMonth() {
        return this.userRewardsForCurrentMonth;
    }

    @Override
    public class_1263 getSpecialRewardsContainer() {
        return this.specialRewardsContainer;
    }

    @Override
    public class_1263 getSpecialRewardsUserContainer() {
        return this.specialRewardsUserContainer;
    }

    @Override
    public List<class_1799> getSpecialRewardsForCurrentMonth() {
        return this.specialRewardsForCurrentMonth;
    }

    @Override
    public List<class_1799> getUserSpecialRewardsForCurrentMonth() {
        return this.userSpecialRewardsForCurrentMonth;
    }
}

