/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.menu;

import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.data.SpecialRewardUserData;
import de.markusbordihn.dailyrewards.item.ModItems;
import de.markusbordihn.dailyrewards.menu.slots.DailyRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.LockedDaySlot;
import de.markusbordihn.dailyrewards.menu.slots.SkipDaySlot;
import de.markusbordihn.dailyrewards.menu.slots.SkippedDaySlot;
import de.markusbordihn.dailyrewards.menu.slots.TakeableRewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.UnlockedDaySlot;
import de.markusbordihn.dailyrewards.rewards.SpecialRewards;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3917;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardMenu
extends class_1703 {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    private static final class_1263 REWARD_CONTAINER = new class_1277(0);
    private static final class_1263 REWARD_USER_CONTAINER = new class_1277(0);
    private static final class_1263 SPECIAL_REWARD_CONTAINER = new class_1277(0);
    private static final class_1263 SPECIAL_REWARD_USER_CONTAINER = new class_1277(0);
    private static final List<class_1799> REWARDS_FOR_CURRENT_MONTH = new ArrayList<class_1799>();
    private static final List<class_1799> USER_REWARDS_FOR_CURRENT_MONTH = new ArrayList<class_1799>();
    private static final List<class_1799> SPECIAL_REWARDS_FOR_CURRENT_MONTH = new ArrayList<class_1799>();
    private static final List<class_1799> USER_SPECIAL_REWARDS_FOR_CURRENT_MONTH = new ArrayList<class_1799>();
    protected final class_1937 level;
    protected final class_1657 player;
    protected final boolean specialRewardAvailable;
    protected int rewardedDays = 0;
    protected String lastRewardedDay;
    protected int rewardedSpecialDays = 0;
    protected String lastRewardedSpecialDay;
    protected UUID playerUUID;

    public RewardMenu(class_3917<?> menuType, int windowId, class_1661 playerInventory) {
        super(menuType, windowId);
        this.player = playerInventory.field_7546;
        this.level = this.player.method_37908();
        this.specialRewardAvailable = SpecialRewards.hasSpecialRewardItemsForCurrentMonth() && SpecialRewards.isSpecialRewardUserForCurrentMonth(this.player.method_5477().getString());
    }

    public void syncRewardContainer(class_1657 player) {
        if (this.getRewardsForCurrentMonth() != null && !this.getRewardsForCurrentMonth().isEmpty()) {
            this.syncRewardsUserContainer(player);
        }
        if (this.getSpecialRewardsForCurrentMonth() != null && !this.getSpecialRewardsForCurrentMonth().isEmpty()) {
            this.syncSpecialRewardsUserContainer(player);
        }
    }

    public void syncRewardsUserContainer(class_1657 player) {
        if (this.level.field_9236) {
            return;
        }
        ArrayList<class_1799> userRewards = new ArrayList<class_1799>();
        for (int index = 0; index < this.getRewardsUserContainer().method_5439(); ++index) {
            class_1799 itemStack = this.getRewardsUserContainer().method_5438(index);
            if (itemStack == null || itemStack.method_7960()) continue;
            userRewards.add(itemStack);
        }
        RewardUserData.get().setRewardsForCurrentMonth(player.method_5667(), userRewards);
    }

    public void syncSpecialRewardsUserContainer(class_1657 player) {
        if (this.level.field_9236) {
            return;
        }
        ArrayList<class_1799> userRewards = new ArrayList<class_1799>();
        for (int index = 0; index < this.getSpecialRewardsUserContainer().method_5439(); ++index) {
            class_1799 itemStack = this.getSpecialRewardsUserContainer().method_5438(index);
            if (itemStack == null || itemStack.method_7960()) continue;
            userRewards.add(itemStack);
        }
        SpecialRewardUserData.get().setRewardsForCurrentMonth(player.method_5667(), userRewards);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int getRewardedDays() {
        return this.rewardedDays;
    }

    public String getLastRewardedDay() {
        return this.lastRewardedDay;
    }

    public class_1263 getRewardsContainer() {
        return REWARD_CONTAINER;
    }

    public class_1263 getRewardsUserContainer() {
        return REWARD_USER_CONTAINER;
    }

    public List<class_1799> getRewardsForCurrentMonth() {
        return REWARDS_FOR_CURRENT_MONTH;
    }

    public List<class_1799> getUserRewardsForCurrentMonth() {
        return USER_REWARDS_FOR_CURRENT_MONTH;
    }

    public int getRewardedSpecialDays() {
        return this.rewardedSpecialDays;
    }

    public String getLastRewardedSpecialDay() {
        return this.lastRewardedSpecialDay;
    }

    public boolean isSpecialRewardAvailable() {
        return this.specialRewardAvailable;
    }

    public class_1263 getSpecialRewardsContainer() {
        return SPECIAL_REWARD_CONTAINER;
    }

    public class_1263 getSpecialRewardsUserContainer() {
        return SPECIAL_REWARD_USER_CONTAINER;
    }

    public List<class_1799> getSpecialRewardsForCurrentMonth() {
        return SPECIAL_REWARDS_FOR_CURRENT_MONTH;
    }

    public List<class_1799> getUserSpecialRewardsForCurrentMonth() {
        return USER_SPECIAL_REWARDS_FOR_CURRENT_MONTH;
    }

    public DailyRewardSlot createRewardSlot(class_1799 itemStack, int rewardedDays, class_1263 container, int index, int x, int y) {
        if (itemStack.method_31574((class_1792)ModItems.SKIP_DAY.get())) {
            if (index < rewardedDays) {
                return new SkippedDaySlot(container, index, x, y, this);
            }
            return new SkipDaySlot(container, index, x, y, this);
        }
        if (itemStack.method_31574((class_1792)ModItems.SKIPPED_DAY.get())) {
            return new SkippedDaySlot(container, index, x, y, this);
        }
        if (itemStack.method_31574((class_1792)ModItems.LOCK_DAY.get())) {
            if (index < rewardedDays) {
                return new UnlockedDaySlot(container, index, x, y, this);
            }
            return new LockedDaySlot(container, index, x, y, this);
        }
        if (itemStack.method_31574((class_1792)ModItems.UNLOCK_DAY.get())) {
            return new LockedDaySlot(container, index, x, y, this);
        }
        return new TakeableRewardSlot(container, index, x, y, this);
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = slot.method_7677();
        if (itemStack.method_7960()) {
            slot.method_7673(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return player != null && player.method_5805();
    }
}

