/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.network.message;

import de.markusbordihn.dailyrewards.data.RewardScreenType;
import de.markusbordihn.dailyrewards.network.message.ModMessage;
import de.markusbordihn.dailyrewards.rewards.RewardsScreen;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageOpenRewardScreen
extends ModMessage<class_3244> {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    protected RewardScreenType rewardScreenType;

    public MessageOpenRewardScreen() {
    }

    public MessageOpenRewardScreen(RewardScreenType rewardScreenType) {
        this.rewardScreenType = rewardScreenType;
    }

    public void method_11052(class_2540 buffer) {
        buffer.method_10817((Enum)this.rewardScreenType);
    }

    @Override
    public void read(class_2540 buffer) {
        this.rewardScreenType = (RewardScreenType)buffer.method_10818(RewardScreenType.class);
    }

    @Override
    public void onReceive(class_3244 listener) {
        class_3222 player = listener.method_32311();
        RewardScreenType rewardScreenType = this.rewardScreenType;
        if (rewardScreenType == null) {
            log.warn("Unable to open reward screen for player {} due to missing reward screen type!", (Object)player);
            return;
        }
        log.debug("Opening reward screen for player {} with type {} ...", (Object)player, (Object)rewardScreenType);
        switch (rewardScreenType) {
            case COMPACT: {
                RewardsScreen.openRewardCompactMenuForPlayer(player);
                break;
            }
            case DEFAULT_OVERVIEW: {
                RewardsScreen.openRewardOverviewMenuForPlayer(player);
                break;
            }
            case SPECIAL_OVERVIEW: {
                RewardsScreen.openRewardSpecialOverviewMenuForPlayer(player);
                break;
            }
            default: {
                log.warn("Unable to open reward screen for player {} due to unknown reward screen type {}!", (Object)player, (Object)rewardScreenType);
            }
        }
    }
}

