/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.player;

import de.markusbordihn.dailyrewards.config.ModConfigs;
import de.markusbordihn.dailyrewards.data.RewardData;
import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.data.SpecialRewardUserData;
import de.markusbordihn.dailyrewards.rewards.Rewards;
import de.markusbordihn.dailyrewards.rewards.RewardsScreen;
import de.markusbordihn.dailyrewards.rewards.SpecialRewards;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerRewardManager {
    private static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    private static final short REWARD_CHECK_TICK = 1200;
    private static final class_5250 claimCommand = class_2561.method_43470((String)"/DailyRewards claim").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/DailyRewards claim")));
    private static short ticker = 0;
    private static Set<class_3222> playerList = ConcurrentHashMap.newKeySet();

    protected PlayerRewardManager() {
    }

    public static void onServerAboutToStartEvent(MinecraftServer server) {
        playerList = ConcurrentHashMap.newKeySet();
        int rewardTimePerDay = ModConfigs.COMMON.rewardTimePerDay;
        int rewardTimePerDayTicks = rewardTimePerDay * 60 * 20;
        if (Boolean.TRUE.equals(ModConfigs.COMMON.automaticRewardPlayers)) {
            log.info("Daily rewards will be automatically granted after {} min ({} ticks) a player is online.", (Object)rewardTimePerDay, (Object)rewardTimePerDayTicks);
        } else {
            log.warn("Daily rewards will not be automatically granted. Use `/DailyRewards reward today <player>` to manually grant rewards.");
        }
        if (Boolean.TRUE.equals(ModConfigs.COMMON.automaticRewardSpecialPlayers)) {
            log.info("Special daily rewards will be automatically granted after {} min ({} ticks) a player is online.", (Object)rewardTimePerDay, (Object)rewardTimePerDayTicks);
        } else {
            log.warn("Special daily rewards will not be automatically granted. Use `/DailyRewards reward_special today <player>` to manually grant rewards.");
        }
    }

    public static void handlePlayerLoggedInEvent(class_3222 player) {
        playerList.add(player);
        boolean hasUnclaimedRewards = false;
        UUID uuid = player.method_5667();
        if (uuid == null) {
            log.error("{} Unable to get UUID for player {}", (Object)"Daily Rewards", (Object)player);
            return;
        }
        int daysLeftCurrentMonth = Rewards.getDaysLeftCurrentMonth();
        if (ModConfigs.COMMON.showUnclaimedRewardsOnPlayerJoin && RewardUserData.get().hasUnclaimedRewardsForCurrentMonth(uuid)) {
            if (daysLeftCurrentMonth > 0) {
                player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.unclaimed_rewarded_item", (Object[])new Object[]{player.method_5477(), daysLeftCurrentMonth}));
            } else {
                player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.unclaimed_rewarded_item_today", (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1061));
            }
            hasUnclaimedRewards = true;
        }
        if (ModConfigs.COMMON.showUnclaimedRewardsSpecialOnPlayerJoin && SpecialRewardUserData.get().hasUnclaimedRewardsForCurrentMonth(uuid)) {
            if (daysLeftCurrentMonth > 0) {
                player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.unclaimed_special_rewarded_item", (Object[])new Object[]{player.method_5477(), daysLeftCurrentMonth}));
            } else {
                player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.unclaimed_special_rewarded_item_today", (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1061));
            }
            hasUnclaimedRewards = true;
        }
        if (hasUnclaimedRewards && Boolean.TRUE.equals(ModConfigs.COMMON.showRewardMenuOnPlayerJoin)) {
            switch (ModConfigs.COMMON.getRewardScreenType()) {
                case COMPACT: {
                    RewardsScreen.openRewardCompactMenuForPlayer(player);
                    break;
                }
                case DEFAULT_OVERVIEW: {
                    RewardsScreen.openRewardOverviewMenuForPlayer(player);
                    break;
                }
                case SPECIAL_OVERVIEW: {
                    RewardsScreen.openRewardSpecialOverviewMenuForPlayer(player);
                    break;
                }
                default: {
                    RewardsScreen.openRewardOverviewMenuForPlayer(player);
                    break;
                }
            }
        } else if ((ModConfigs.COMMON.showUnclaimedRewardsOnPlayerJoin || ModConfigs.COMMON.showUnclaimedRewardsSpecialOnPlayerJoin) && ModConfigs.COMMON.showRewardClaimCommandMessage && hasUnclaimedRewards) {
            player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.claim_rewards", (Object[])new Object[]{claimCommand}));
        }
    }

    public static void handlePlayerLoggedOutEvent(class_3222 player) {
        if (playerList.isEmpty()) {
            return;
        }
        if (player != null) {
            playerList.remove(player);
        }
    }

    public static void handleServerTickEvent(MinecraftServer server) {
        block17: {
            block16: {
                if (!ModConfigs.COMMON.automaticRewardPlayers && !ModConfigs.COMMON.automaticRewardSpecialPlayers) break block16;
                short s = ticker;
                ticker = (short)(s + 1);
                if (s >= 1200 && !playerList.isEmpty()) break block17;
            }
            return;
        }
        for (class_3222 player : playerList) {
            if (player.field_6012 <= ModConfigs.COMMON.rewardTimePerDay * 60 * 20) continue;
            UUID uuid = player.method_5667();
            String username = player.method_5477().getString();
            boolean showRewardClaimCommand = false;
            RewardUserData rewardUserData = RewardUserData.get();
            if (Boolean.FALSE.equals(ModConfigs.COMMON.automaticRewardPlayers)) {
                log.debug("Player {} will not be automatically rewarded.", (Object)player);
            } else if (!rewardUserData.hasRewardedToday(uuid)) {
                rewardUserData.setLastRewardedDayForCurrentMonth(uuid);
                int rewardedDays = rewardUserData.increaseRewardedDaysForCurrentMonth(uuid);
                class_1799 itemStack = RewardData.get().getRewardForCurrentMonth(rewardedDays);
                if (itemStack.method_7960()) {
                    log.error("Reward {} for day {} for current month was empty!", (Object)itemStack, (Object)rewardedDays);
                } else {
                    rewardUserData.addRewardForCurrentMonth(rewardedDays, uuid, itemStack);
                    if (ModConfigs.COMMON.showReceivedRewardMessage) {
                        player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.rewarded_item", (Object[])new Object[]{player.method_5477(), itemStack, rewardedDays}));
                    }
                    showRewardClaimCommand = true;
                }
                log.info("Reward player {} daily reward for {} days with {} ...", (Object)player, (Object)rewardedDays, (Object)itemStack);
            }
            SpecialRewardUserData specialRewardUserData = SpecialRewardUserData.get();
            if (Boolean.FALSE.equals(ModConfigs.COMMON.automaticRewardSpecialPlayers)) {
                log.debug("Player {} will not be automatically special rewarded for today.", (Object)player);
            } else if (!specialRewardUserData.hasRewardedToday(uuid) && SpecialRewards.isSpecialRewardUserForCurrentMonth(username)) {
                specialRewardUserData.setLastRewardedDayForCurrentMonth(uuid);
                int rewardedDays = specialRewardUserData.increaseRewardedDaysForCurrentMonth(uuid);
                class_1799 itemStack = RewardData.get().getSpecialRewardForCurrentMonth(rewardedDays);
                if (itemStack.method_7960()) {
                    log.error("Special Reward {} for day {} for current month was empty!", (Object)itemStack, (Object)rewardedDays);
                } else {
                    specialRewardUserData.addRewardForCurrentMonth(rewardedDays, uuid, itemStack);
                    if (ModConfigs.COMMON.showReceivedRewardSpecialMessage) {
                        player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.rewarded_item", (Object[])new Object[]{player.method_5477(), itemStack, rewardedDays}));
                    }
                    showRewardClaimCommand = true;
                }
                log.info("Special Reward player {} daily reward for {} days with {} ...", (Object)player, (Object)rewardedDays, (Object)itemStack);
            }
            if (!ModConfigs.COMMON.showRewardClaimCommandMessage || !showRewardClaimCommand) continue;
            player.method_43496((class_2561)class_2561.method_43469((String)"text.daily_rewards.claim_rewards", (Object[])new Object[]{claimCommand}));
        }
        ticker = 0;
    }
}

