/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.rewards;

import de.markusbordihn.dailyrewards.config.ModConfigs;
import de.markusbordihn.dailyrewards.rewards.RewardsItems;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Rewards {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    protected static final Random random = new Random();

    protected Rewards() {
    }

    public static void handleServerAboutToStartEvent(MinecraftServer server) {
        if (Boolean.TRUE.equals(ModConfigs.COMMON.useFillItems)) {
            log.info("Will use the following normal fill items: {}", Rewards.getNormalFillItems());
            log.info("Will use the following rare fill items: {}", Rewards.getRareFillItems());
        } else {
            log.info("Fill items are disabled, will use only reward items.");
        }
    }

    public static List<class_1799> calculateRewardItemsForMonth(int month) {
        YearMonth yearMonth = YearMonth.of(Rewards.getCurrentYear(), month);
        int numberOfDays = yearMonth.lengthOfMonth();
        log.info("Calculate Reward items for month {} with {} days ...", (Object)month, (Object)numberOfDays);
        List<class_1799> rewardItemsForMonth = Rewards.getRewardItemForMonth(month);
        if (Boolean.TRUE.equals(!ModConfigs.COMMON.useFillItems) || rewardItemsForMonth.size() >= numberOfDays) {
            if (Boolean.FALSE.equals(ModConfigs.COMMON.useFillItems)) {
                log.info("Fill items are disabled, will use {} reward items for month {} with {} days ...", (Object)rewardItemsForMonth.size(), (Object)month, (Object)numberOfDays);
            } else {
                log.info("Found {} reward items for month {} with {} days ...", (Object)rewardItemsForMonth.size(), (Object)month, (Object)numberOfDays);
            }
            List<class_1799> rewardItems = rewardItemsForMonth.stream().limit(numberOfDays).collect(Collectors.toList());
            if (Boolean.TRUE.equals(ModConfigs.COMMON.shuffleRewardsItems)) {
                log.info("Shuffle reward items for month {} ...", (Object)month);
                Collections.shuffle(rewardItems);
            }
            return rewardItems;
        }
        int numRewardItems = rewardItemsForMonth.size();
        int numMissingRewardItems = numberOfDays - numRewardItems;
        List<class_1799> normalFillItems = Rewards.getNormalFillItems();
        List<class_1799> rareFillItems = Rewards.getRareFillItems();
        List<class_1799> lootBagFillItems = Rewards.getLootBagFillItems();
        HashSet<class_1799> rareDuplicates = new HashSet<class_1799>();
        HashSet<class_1799> lootBagDuplicates = new HashSet<class_1799>();
        int rareFillItemsChance = rareFillItems.isEmpty() ? 0 : ModConfigs.COMMON.rareFillItemsChance;
        int lootBackFillItemChance = lootBagFillItems.isEmpty() ? 0 : ModConfigs.COMMON.lootBagFillItemsChance;
        log.warn("Found {} missing days without any items, will try to use fill items ...", (Object)numMissingRewardItems);
        for (int i = 0; i < numMissingRewardItems; ++i) {
            class_1799 lootBagFillItem;
            class_1799 fillItem = null;
            if (rareFillItemsChance > 0 && random.nextInt(rareFillItemsChance) == 0) {
                class_1799 rareFillItem = rareFillItems.get(random.nextInt(rareFillItems.size()));
                if (!rareDuplicates.contains(rareFillItem)) {
                    fillItem = rareFillItem;
                    rareDuplicates.add(rareFillItem);
                }
            } else if (lootBackFillItemChance > 0 && random.nextInt(lootBackFillItemChance) == 0 && !lootBagDuplicates.contains(lootBagFillItem = lootBagFillItems.get(random.nextInt(lootBagFillItems.size())))) {
                fillItem = lootBagFillItem;
                lootBagDuplicates.add(lootBagFillItem);
            }
            if (fillItem == null) {
                if (!normalFillItems.isEmpty()) {
                    fillItem = normalFillItems.get(random.nextInt(normalFillItems.size()));
                } else {
                    log.error("Unable to find any fill item for {} of {} missing days, will use {} instead!", (Object)(i + 1), (Object)numMissingRewardItems, (Object)class_1802.field_8831);
                    fillItem = new class_1799((class_1935)class_1802.field_8831);
                }
            }
            rewardItemsForMonth.add(fillItem);
        }
        if (Boolean.TRUE.equals(ModConfigs.COMMON.shuffleRewardsItems)) {
            log.info("Shuffle reward items for month {} ...", (Object)month);
            Collections.shuffle(rewardItemsForMonth);
        }
        return rewardItemsForMonth;
    }

    public static List<class_1799> getRewardItemForMonth(int month) {
        return switch (month) {
            case 1 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsJanuaryItems);
            case 2 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsFebruaryItems);
            case 3 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsMarchItems);
            case 4 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsAprilItems);
            case 5 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsMayItems);
            case 6 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsJuneItems);
            case 7 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsJulyItems);
            case 8 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsAugustItems);
            case 9 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsSeptemberItems);
            case 10 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsOctoberItems);
            case 11 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsNovemberItems);
            case 12 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsDecemberItems);
            default -> new ArrayList();
        };
    }

    public static List<class_1799> getNormalFillItems() {
        return RewardsItems.parseConfigItems(ModConfigs.COMMON.normalFillItems);
    }

    public static class_1799 getNormalFillItem() {
        List<class_1799> normalFillItems = Rewards.getNormalFillItems();
        return normalFillItems.get(random.nextInt(normalFillItems.size()));
    }

    public static List<class_1799> getRareFillItems() {
        return RewardsItems.parseConfigItems(ModConfigs.COMMON.rareFillItems);
    }

    public static class_1799 getRareFillItem() {
        List<class_1799> rareFillItems = Rewards.getRareFillItems();
        return rareFillItems.get(random.nextInt(rareFillItems.size()));
    }

    public static List<class_1799> getLootBagFillItems() {
        return RewardsItems.parseConfigItems(ModConfigs.COMMON.lootBagFillItems);
    }

    public static class_1799 getLootBagFillItem() {
        List<class_1799> lootBagFillItems = Rewards.getRareFillItems();
        return lootBagFillItems.get(random.nextInt(lootBagFillItems.size()));
    }

    public static int getCurrentDay() {
        return LocalDate.now().getDayOfMonth();
    }

    public static int getCurrentMonth() {
        return LocalDate.now().getMonthValue();
    }

    public static int getCurrentYear() {
        return LocalDate.now().getYear();
    }

    public static String getCurrentYearMonthDay() {
        return Rewards.getCurrentYear() + "-" + Rewards.getCurrentMonth() + "-" + Rewards.getCurrentDay();
    }

    public static int getDaysPerMonth(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        return yearMonth.lengthOfMonth();
    }

    public static int getDaysCurrentMonth() {
        return Rewards.getDaysPerMonth(Rewards.getCurrentYear(), Rewards.getCurrentMonth());
    }

    public static int getDaysLeftCurrentMonth() {
        return Rewards.getDaysCurrentMonth() - Rewards.getCurrentDay();
    }
}

