/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.rewards;

import de.markusbordihn.dailyrewards.config.ModConfigs;
import de.markusbordihn.dailyrewards.rewards.RewardsItems;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpecialRewards {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    protected static final Random random = new Random();

    protected SpecialRewards() {
    }

    public static List<class_1799> calculateSpecialRewardItemsForMonth(int month) {
        YearMonth yearMonth = YearMonth.of(SpecialRewards.getCurrentYear(), month);
        int numberOfDays = yearMonth.lengthOfMonth();
        List<class_1799> rewardItemsForMonth = SpecialRewards.getSpecialRewardItemForMonth(month);
        if (rewardItemsForMonth.isEmpty()) {
            log.info("No special reward items for month {} with {} days ...", (Object)month, (Object)numberOfDays);
            return new ArrayList<class_1799>();
        }
        if (rewardItemsForMonth.size() >= numberOfDays) {
            log.info("Found {} special reward items for month {} with {} days ...", (Object)rewardItemsForMonth.size(), (Object)month, (Object)numberOfDays);
            List<class_1799> rewardItems = rewardItemsForMonth.stream().limit(numberOfDays).collect(Collectors.toList());
            if (Boolean.TRUE.equals(ModConfigs.COMMON.shuffleRewardsSpecialItems)) {
                log.info("Shuffle special reward items for month {} ...", (Object)month);
                Collections.shuffle(rewardItems);
            }
            return rewardItems;
        }
        if (rewardItemsForMonth.size() == 1) {
            log.info("Found only one special reward item for month {} with {} days ...", (Object)month, (Object)numberOfDays);
            ArrayList<class_1799> rewardItems = new ArrayList<class_1799>();
            for (int i = 0; i < numberOfDays; ++i) {
                rewardItems.add(rewardItemsForMonth.get(0));
            }
            return rewardItems;
        }
        log.info("Found only {} special reward items for month {} with {} days ...", (Object)rewardItemsForMonth.size(), (Object)month, (Object)numberOfDays);
        ArrayList<class_1799> rewardItems = new ArrayList<class_1799>();
        for (int i = 0; i < numberOfDays; ++i) {
            rewardItems.add(rewardItemsForMonth.get(i % rewardItemsForMonth.size()));
        }
        if (Boolean.TRUE.equals(ModConfigs.COMMON.shuffleRewardsSpecialItems)) {
            log.info("Shuffle special reward items for month {} ...", (Object)month);
            Collections.shuffle(rewardItems);
        }
        return rewardItems;
    }

    public static List<class_1799> getSpecialRewardItemForMonth(int month) {
        return switch (month) {
            case 1 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsJanuarySpecialItems);
            case 2 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsFebruarySpecialItems);
            case 3 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsMarchSpecialItems);
            case 4 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsAprilSpecialItems);
            case 5 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsMaySpecialItems);
            case 6 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsJuneSpecialItems);
            case 7 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsJulySpecialItems);
            case 8 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsAugustSpecialItems);
            case 9 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsSeptemberSpecialItems);
            case 10 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsOctoberSpecialItems);
            case 11 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsNovemberSpecialItems);
            case 12 -> RewardsItems.parseConfigItems(ModConfigs.COMMON.rewardsDecemberSpecialItems);
            default -> new ArrayList();
        };
    }

    public static boolean hasSpecialRewardItemsForMonth(int month) {
        return !SpecialRewards.getSpecialRewardItemForMonth(month).isEmpty();
    }

    public static boolean hasSpecialRewardItemsForCurrentMonth() {
        return SpecialRewards.hasSpecialRewardItemsForMonth(SpecialRewards.getCurrentMonth());
    }

    public static int getCurrentDay() {
        return LocalDate.now().getDayOfMonth();
    }

    public static int getCurrentMonth() {
        return LocalDate.now().getMonthValue();
    }

    public static int getCurrentYear() {
        return LocalDate.now().getYear();
    }

    public static String getCurrentYearMonthDay() {
        return SpecialRewards.getCurrentYear() + "-" + SpecialRewards.getCurrentMonth() + "-" + SpecialRewards.getCurrentDay();
    }

    public static int getDaysCurrentMonth() {
        YearMonth yearMonth = YearMonth.of(SpecialRewards.getCurrentYear(), SpecialRewards.getCurrentMonth());
        return yearMonth.lengthOfMonth();
    }

    public static int getDaysLeftCurrentMonth() {
        return SpecialRewards.getDaysCurrentMonth() - SpecialRewards.getCurrentDay();
    }

    public static List<String> getSpecialRewardUsersForMonth(int month) {
        return switch (month) {
            case 1 -> ModConfigs.COMMON.rewardsJanuarySpecialUsers;
            case 2 -> ModConfigs.COMMON.rewardsFebruarySpecialUsers;
            case 3 -> ModConfigs.COMMON.rewardsMarchSpecialUsers;
            case 4 -> ModConfigs.COMMON.rewardsAprilSpecialUsers;
            case 5 -> ModConfigs.COMMON.rewardsMaySpecialUsers;
            case 6 -> ModConfigs.COMMON.rewardsJuneSpecialUsers;
            case 7 -> ModConfigs.COMMON.rewardsJulySpecialUsers;
            case 8 -> ModConfigs.COMMON.rewardsAugustSpecialUsers;
            case 9 -> ModConfigs.COMMON.rewardsSeptemberSpecialUsers;
            case 10 -> ModConfigs.COMMON.rewardsOctoberSpecialUsers;
            case 11 -> ModConfigs.COMMON.rewardsNovemberSpecialUsers;
            case 12 -> ModConfigs.COMMON.rewardsDecemberSpecialUsers;
            default -> new ArrayList<String>();
        };
    }

    public static List<String> getSpecialRewardUsersForCurrentMonth() {
        return SpecialRewards.getSpecialRewardUsersForMonth(SpecialRewards.getCurrentMonth());
    }

    public static boolean isSpecialRewardUserForCurrentMonth(String playerName) {
        List<String> specialRewardUsersForCurrentMonth = SpecialRewards.getSpecialRewardUsersForCurrentMonth();
        return specialRewardUsersForCurrentMonth == null || specialRewardUsersForCurrentMonth.isEmpty() || SpecialRewards.getSpecialRewardUsersForCurrentMonth().size() == 1 && specialRewardUsersForCurrentMonth.get(0).isEmpty() || specialRewardUsersForCurrentMonth.contains(playerName);
    }
}

