/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.data_trades.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.possible_triangle.data_trades.data.ProfessionReloader;
import com.possible_triangle.data_trades.data.Trader;
import com.possible_triangle.data_trades.data.TraderReloader;
import com.possible_triangle.data_trades.mixin.AbstractVillagerAccessor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1916;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3850;
import net.minecraft.class_3853;
import net.minecraft.class_3988;
import net.minecraft.class_3989;
import net.minecraft.class_5575;
import net.minecraft.server.MinecraftServer;

public class VillagersCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"villagers").requires(it -> it.method_9259(3))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"refresh").executes(VillagersCommand::resetAllVillagers)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).executes(VillagersCommand::resetTargetedVillagers))));
    }

    private static int resetVillagers(Stream<class_3988> villagers) {
        return (int)villagers.filter(VillagersCommand::reset).count();
    }

    private static int resetTargetedVillagers(CommandContext<class_2168> context) throws CommandSyntaxException {
        Stream<class_3988> targets = class_2186.method_9317(context, (String)"target").stream().filter(class_3988.class::isInstance).map(it -> (class_3988)it);
        return VillagersCommand.resetVillagers(targets);
    }

    private static int resetAllVillagers(CommandContext<class_2168> context) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        return VillagersCommand.resetVillagers(StreamSupport.stream(server.method_3738().spliterator(), false).flatMap(level -> level.method_18198(class_5575.method_31795(class_3988.class), $ -> true).stream()));
    }

    private static boolean reset(class_3988 entity) {
        if (entity instanceof class_3989) {
            class_3989 trader = (class_3989)entity;
            return VillagersCommand.resetTrader(trader);
        }
        if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            return VillagersCommand.resetVillager(villager);
        }
        return false;
    }

    private static boolean resetTrader(class_3989 trader) {
        class_1916 offers = new class_1916();
        class_3853.class_1652[] trades = (class_3853.class_1652[])class_3853.field_17724.get(1);
        int tradeCount = TraderReloader.INSTANCE.takeTradesAmount(trader, Trader::genericTrades).orElse(5);
        List<class_3853.class_1652> shuffled = Arrays.asList(trades);
        Collections.shuffle(shuffled, new Random(trader.method_6051().method_43055()));
        shuffled.subList(0, Math.min(shuffled.size(), tradeCount)).stream().map(it -> it.method_7246((class_1297)trader, trader.method_6051())).filter(Objects::nonNull).forEach(arg_0 -> offers.add(arg_0));
        trades = (class_3853.class_1652[])class_3853.field_17724.get(2);
        tradeCount = TraderReloader.INSTANCE.takeTradesAmount(trader, Trader::rareTrades).orElse(1);
        shuffled = Arrays.asList(trades);
        Collections.shuffle(shuffled, new Random(trader.method_6051().method_43055()));
        shuffled.subList(0, Math.min(shuffled.size(), tradeCount)).stream().map(it -> it.method_7246((class_1297)trader, trader.method_6051())).filter(Objects::nonNull).forEach(arg_0 -> offers.add(arg_0));
        AbstractVillagerAccessor accessor = (AbstractVillagerAccessor)trader;
        accessor.setOffers(offers);
        return true;
    }

    private static boolean resetVillager(class_1646 villager) {
        class_1916 offers = new class_1916();
        class_3850 data = villager.method_7231();
        Int2ObjectMap trades = (Int2ObjectMap)class_3853.field_17067.get(data.method_16924());
        if (trades == null || trades.isEmpty()) {
            return false;
        }
        for (int level = 1; level <= data.method_16925(); ++level) {
            class_3853.class_1652[] listings = (class_3853.class_1652[])trades.get(level);
            int tradeCount = ProfessionReloader.INSTANCE.takeTradesAmount(villager, level).orElse(2);
            if (listings == null) continue;
            List<class_3853.class_1652> shuffled = Arrays.asList(listings);
            Collections.shuffle(shuffled, new Random(villager.method_6051().method_43055()));
            shuffled.subList(0, Math.min(shuffled.size(), tradeCount)).stream().map(it -> it.method_7246((class_1297)villager, villager.method_6051())).filter(Objects::nonNull).forEach(arg_0 -> offers.add(arg_0));
        }
        villager.method_16917(offers);
        return true;
    }
}

