/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.data_trades.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.possible_triangle.data_trades.Constants;
import com.possible_triangle.data_trades.data.TradeLevel;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public record Profession(boolean disabled, Int2ObjectMap<TradeLevel> trades) {
    public static Optional<Profession> parse(JsonObject json, class_2960 id) {
        try {
            boolean disabled = class_3518.method_15258((JsonObject)json, (String)"disabled", (boolean)false);
            Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
            JsonObject levels = class_3518.method_15281((JsonObject)json, (String)"levels", (JsonObject)new JsonObject());
            levels.entrySet().forEach(entry -> {
                int level = Integer.parseInt((String)entry.getKey());
                TradeLevel.parse(((JsonElement)entry.getValue()).getAsJsonObject(), id, "level-" + level).ifPresent(parsed -> trades.put(level, parsed));
            });
            if (trades.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new Profession(disabled, (Int2ObjectMap<TradeLevel>)trades));
        }
        catch (JsonSyntaxException ex) {
            Constants.LOGGER.error("Error loading profession '{}': {}", (Object)id, (Object)ex.getMessage());
            return Optional.empty();
        }
    }
}

