/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.data_trades.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.possible_triangle.data_trades.CommonClass;
import com.possible_triangle.data_trades.Constants;
import com.possible_triangle.data_trades.data.ProfessionReloader;
import com.possible_triangle.data_trades.data.TradeIngredient;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3853;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public record Trade(TradeIngredient wants, @Nullable TradeIngredient wants2, TradeIngredient sells, int uses, int maxUses, int xp, float priceMultiplier, int demand, Predicate<class_47> condition) implements class_3853.class_1652
{
    public static Optional<Predicate<class_47>> parseCondition(JsonObject json) {
        if (json.has("condition")) {
            JsonObject element = json.getAsJsonObject("condition");
            return Optional.ofNullable((Predicate)CommonClass.LOOT_GSON.fromJson((JsonElement)element, class_5341.class));
        }
        return Optional.empty();
    }

    public static Optional<Trade> parse(JsonObject json, class_2960 id) {
        try {
            boolean disabled = class_3518.method_15258((JsonObject)json, (String)"disabled", (boolean)false);
            if (disabled) {
                return Optional.empty();
            }
            ImmutableList.Builder wantsBuilder = new ImmutableList.Builder();
            for (JsonElement element : class_3518.method_15261((JsonObject)json, (String)"wants")) {
                TradeIngredient ingredient = TradeIngredient.fromJson((JsonElement)element.getAsJsonObject());
                if (ingredient.isEmpty()) continue;
                wantsBuilder.add((Object)ingredient);
            }
            ImmutableList wants = wantsBuilder.build();
            TradeIngredient sells = TradeIngredient.fromJson((JsonElement)class_3518.method_15296((JsonObject)json, (String)"sells"));
            if (sells.isEmpty()) {
                throw new JsonSyntaxException("Trade defined no valid result");
            }
            if (wants.isEmpty()) {
                throw new JsonSyntaxException("Trade defined no valid ingredients");
            }
            if (wants.size() > 2) {
                throw new JsonSyntaxException("Trades can require up to 2 items");
            }
            int uses = class_3518.method_15282((JsonObject)json, (String)"uses", (int)0);
            int maxUses = class_3518.method_15282((JsonObject)json, (String)"maxUses", (int)10);
            int xp = class_3518.method_15282((JsonObject)json, (String)"xp", (int)1);
            float priceMultiplier = class_3518.method_15277((JsonObject)json, (String)"priceMultiplier", (float)2.0f);
            int demand = class_3518.method_15282((JsonObject)json, (String)"demand", (int)0);
            Predicate condition = Trade.parseCondition(json).orElseGet(() -> context -> true);
            Trade trade = new Trade((TradeIngredient)wants.get(0), wants.size() > 1 ? (TradeIngredient)wants.get(1) : null, sells, uses, maxUses, xp, priceMultiplier, demand, condition);
            return Optional.of(trade);
        }
        catch (JsonSyntaxException ex) {
            Constants.LOGGER.error("Error loading trade '{}': {}", (Object)id, (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    public class_1914 method_7246(class_1297 entity, class_5819 randomSource) {
        return ProfessionReloader.createContext(entity).filter(this.condition).map(context -> new class_1914(this.wants.createStack((class_47)context), this.wants2 != null ? this.wants2.createStack((class_47)context) : class_1799.field_8037, this.sells.createStack((class_47)context), this.uses, this.maxUses, this.xp, this.priceMultiplier, this.demand)).orElse(null);
    }
}

