/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.data_trades.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.possible_triangle.data_trades.Constants;
import com.possible_triangle.data_trades.data.TradeLevel;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public record Trader(boolean disabled, @Nullable TradeLevel genericTrades, @Nullable TradeLevel rareTrades) {
    public static Optional<Trader> parse(JsonObject json, class_2960 id) {
        try {
            boolean disabled = class_3518.method_15258((JsonObject)json, (String)"disabled", (boolean)false);
            Optional<TradeLevel> genericTrades = TradeLevel.parse(json.getAsJsonObject("generic"), id, "generic");
            Optional<TradeLevel> rareTrades = TradeLevel.parse(json.getAsJsonObject("rare"), id, "rare");
            if (genericTrades.isEmpty() && rareTrades.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new Trader(disabled, genericTrades.orElse(null), rareTrades.orElse(null)));
        }
        catch (JsonSyntaxException ex) {
            Constants.LOGGER.error("Error loading trader '{}': {}", (Object)id, (Object)ex.getMessage());
            return Optional.empty();
        }
    }
}

