/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.base;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_4593;
import net.minecraft.class_630;

public class BaseColorableAgeableListModel<E extends class_1297>
extends class_4593<E>
implements EasyNPCModel<E> {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, class_630> modelPartMap = new EnumMap<ModelPartType, class_630>(ModelPartType.class);
    protected final class_630 tail;
    protected final class_630 head;
    protected final class_630 body;
    protected final class_630 rightHindLeg;
    protected final class_630 leftHindLeg;
    protected final class_630 rightFrontLeg;
    protected final class_630 leftFrontLeg;

    public BaseColorableAgeableListModel(class_630 modelPart) {
        this.head = this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.rightHindLeg = this.defineModelPart(ModelPartType.RIGHT_HIND_LEG, modelPart, "right_hind_leg");
        this.leftHindLeg = this.defineModelPart(ModelPartType.LEFT_HIND_LEG, modelPart, "left_hind_leg");
        this.rightFrontLeg = this.defineModelPart(ModelPartType.RIGHT_FRONT_LEG, modelPart, "right_front_leg");
        this.leftFrontLeg = this.defineModelPart(ModelPartType.LEFT_FRONT_LEG, modelPart, "left_front_leg");
        this.tail = this.defineModelPart(ModelPartType.TAIL, modelPart, "tail");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_HIND_LEG, this.rightHindLeg);
        this.resetModelPart(ModelPartType.LEFT_HIND_LEG, this.leftHindLeg);
        this.resetModelPart(ModelPartType.RIGHT_FRONT_LEG, this.rightFrontLeg);
        this.resetModelPart(ModelPartType.LEFT_FRONT_LEG, this.leftFrontLeg);
        this.resetModelPart(ModelPartType.TAIL, this.tail);
    }

    protected Iterable<class_630> method_22946() {
        return List.of(this.head);
    }

    protected Iterable<class_630> method_22948() {
        return List.of(this.body, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg, this.tail);
    }

    public void method_2819(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnimation((class_1297)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftFrontLeg, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightFrontLeg, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftHindLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightHindLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean animateModelHead(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.field_3654 = headPitch * ((float)Math.PI / 180);
        headPart.field_3675 = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, class_630> getModelPartMap() {
        return this.modelPartMap;
    }

    @Override
    public boolean isHumanoidModel() {
        return false;
    }
}

