/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.base;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmAnimation;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmPoseAnimation;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_3881;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_5597;
import net.minecraft.class_630;

public class BaseHierarchicalArmHeadModel<E extends class_1308>
extends class_5597<E>
implements class_3881,
class_3882,
EasyNPCModel<E>,
HumanoidArmAnimation,
HumanoidArmPoseAnimation {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, class_630> modelPartMap = new EnumMap<ModelPartType, class_630>(ModelPartType.class);
    protected final class_630 root;
    protected final class_630 body;
    protected final class_630 head;
    protected final class_630 rightArm;
    protected final class_630 leftArm;
    protected final class_630 rightLeg;
    protected final class_630 leftLeg;

    public BaseHierarchicalArmHeadModel(class_630 modelPart) {
        class_630 bodyModelPart;
        class_630 rootModelPart;
        try {
            rootModelPart = this.defineModelPart(ModelPartType.ROOT, modelPart, "root");
        }
        catch (NoSuchElementException e) {
            rootModelPart = this.defineModelPart(ModelPartType.ROOT, modelPart);
        }
        try {
            bodyModelPart = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        }
        catch (NoSuchElementException e) {
            bodyModelPart = null;
        }
        this.root = rootModelPart;
        this.head = this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.body = bodyModelPart;
        this.rightArm = this.defineModelPart(ModelPartType.RIGHT_ARM, modelPart, "right_arm");
        this.leftArm = this.defineModelPart(ModelPartType.LEFT_ARM, modelPart, "left_arm");
        this.rightLeg = this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
        this.leftLeg = this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
    }

    public class_630 method_32008() {
        return this.root;
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        if (this.body != null) {
            this.resetModelPart(ModelPartType.BODY, this.body);
        }
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.rightArm);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.leftArm);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.leftLeg);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnimation((class_1297)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public boolean animateModelArms(E entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightArmPart, class_630 leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidArmAnimation.animateHumanoidModelArms(rightArmPart, leftArmPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean animateModelArmPose(E entity, ModelArmPose modelArmPose, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return HumanoidArmPoseAnimation.animateHumanoidArmPose(entity, modelArmPose, this.head, this.body, this.rightArm, this.leftArm, this.field_3447, ageInTicks);
    }

    @Override
    public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftArm, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightArm, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean setupCrouchingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.field_3654 = 0.5f;
        this.body.field_3656 = 3.2f;
        this.head.field_3656 = 4.2f;
        this.leftArm.field_3654 += 0.4f;
        this.leftArm.field_3656 = 5.2f;
        this.leftLeg.field_3656 = 12.2f;
        this.leftLeg.field_3655 = 4.0f;
        this.rightArm.field_3654 += 0.4f;
        this.rightArm.field_3656 = 5.2f;
        this.rightLeg.field_3656 = 12.2f;
        this.rightLeg.field_3655 = 4.0f;
        return true;
    }

    protected class_630 getArm(class_1306 humanoidArm) {
        return humanoidArm == class_1306.field_6182 ? this.leftArm : this.rightArm;
    }

    public void method_2803(class_1306 humanoidArm, class_4587 poseStack) {
        this.getArm(humanoidArm).method_22703(poseStack);
    }

    public class_630 method_2838() {
        return this.head;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, class_630> getModelPartMap() {
        return this.modelPartMap;
    }
}

