/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import de.markusbordihn.easynpc.client.renderer.EasyNPCRenderer;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import net.minecraft.class_1092;
import net.minecraft.class_1309;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import net.minecraft.class_970;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface EasyNPCModelRenderer<E extends EasyNPCBaseModelEntity<E>, M extends class_583<E>>
extends EasyNPCRenderer<E, M> {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public static <T extends class_1309, M extends class_572<T>, L extends class_3887<T, M>, R extends class_922<T, M>> L getHumanoidArmorLayer(R mobRenderer, class_5617.class_5618 context, class_5601 innerArmor, class_5601 outerArmor, Class<L> armorLayerClass) {
        if (armorLayerClass != null) {
            try {
                return (L)((class_3887)armorLayerClass.getConstructor(class_3883.class, class_572.class, class_572.class, class_1092.class).newInstance(mobRenderer, new class_572(context.method_32167(innerArmor)), new class_572(context.method_32167(outerArmor)), context.method_48481()));
            }
            catch (Exception e) {
                log.error("Failed to create custom armor layer for {} will use default armor layer instead.", mobRenderer, (Object)e);
            }
        }
        return (L)new class_970(mobRenderer, new class_572(context.method_32167(innerArmor)), new class_572(context.method_32167(outerArmor)), context.method_48481());
    }

    public static void scaleEntity(EasyNPC<?> easyNPC, class_4587 poseStack) {
        class_1309 livingEntity = easyNPC.getLivingEntity();
        ScaleData<?> scaleData = easyNPC.getEasyNPCScaleData();
        if (livingEntity.method_6109()) {
            poseStack.method_22905(scaleData.getScaleX().floatValue() * 0.5f, scaleData.getScaleY().floatValue() * 0.5f, scaleData.getScaleZ().floatValue() * 0.5f);
        } else {
            poseStack.method_22905(scaleData.getScaleX().floatValue(), scaleData.getScaleY().floatValue(), scaleData.getScaleZ().floatValue());
        }
    }

    public static void renderEntityNameTag(EasyNPC<?> easyNPC, class_4587 poseStack) {
        CustomRotation rootRotation = easyNPC.getEasyNPCModelData().getModelRootRotation();
        if (rootRotation != null) {
            poseStack.method_46416(0.0f, -1.0f, 0.0f);
            poseStack.method_22907(class_7833.field_40714.rotation(-rootRotation.x()));
            poseStack.method_22907(class_7833.field_40716.rotation(-rootRotation.y()));
            poseStack.method_22907(class_7833.field_40718.rotation(-rootRotation.z()));
            poseStack.method_46416(0.0f, 1.0f, 0.0f);
        }
    }

    public static int getEntityLightLevel(EasyNPC<?> easyNPC, class_2338 blockPos) {
        int entityLightLevel = easyNPC.getEasyNPCDisplayAttributeData().getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
        if (entityLightLevel > 0) {
            return entityLightLevel;
        }
        class_1309 livingEntity = easyNPC.getLivingEntity();
        return livingEntity.method_37908().method_8314(class_1944.field_9282, blockPos);
    }

    default public void renderCustomPose(E entity, M model, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
    }

    default public void renderDefaultPose(E entity, M model, class_4050 pose, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
    }

    default public <N extends EasyNPC<E>> void rotateEntity(N easyNPC, class_4587 poseStack) {
        CustomRotation rootRotation = easyNPC.getEasyNPCModelData().getModelRootRotation();
        if (rootRotation != null) {
            poseStack.method_46416(0.0f, 1.0f, 0.0f);
            poseStack.method_22907(class_7833.field_40714.rotation(rootRotation.x()));
            poseStack.method_22907(class_7833.field_40716.rotation(rootRotation.y()));
            poseStack.method_22907(class_7833.field_40718.rotation(rootRotation.z()));
            poseStack.method_46416(0.0f, -1.0f, 0.0f);
        }
    }

    default public void renderModel(E entity, M model, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        this.rotateEntity((EasyNPC)entity, poseStack);
        ModelPose modelPose = entity.getModelPose();
        if (modelPose == ModelPose.DEFAULT) {
            this.renderDefaultPose(entity, model, entity.method_18376(), entityYaw, partialTicks, poseStack, buffer, packedLight);
        } else if (modelPose == ModelPose.CUSTOM) {
            this.renderCustomPose(entity, model, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }
}

