/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SliderButton
extends class_357 {
    public static final int DEFAULT_HEIGHT = 16;
    protected static final class_2561 EMPTY_TEXT = class_2561.method_43470((String)"");
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final class_2960 SLIDER_LOCATION = new class_2960("minecraft", "textures/gui/slider.png");
    protected final OnChange onChange;
    protected final float maxValue;
    private final float minValue;
    private final float stepSize;
    private final float valueFraction;
    private final Type type;
    private float initValue;
    private float roundFactor = 100.0f;
    private float targetValue;

    public SliderButton(int x, int y, int width, String name, float initValue, Type type, OnChange onChange) {
        this(x, y, width, 16, (class_2561)class_2561.method_43470((String)name), initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, float initValue, Type type, OnChange onChange) {
        this(x, y, width, height, EMPTY_TEXT, initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, String name, double initValue, double minValue, double maxValue, OnChange onChange) {
        this(x, y, width, height, (class_2561)class_2561.method_43470((String)name), (float)initValue, (float)minValue, (float)maxValue, onChange, Type.DOUBLE);
    }

    public SliderButton(int x, int y, int width, int height, class_2561 name, float initValue, float minValue, float maxValue, OnChange onChange, Type type) {
        super(x, y, width, height, name, (double)initValue);
        this.initValue = initValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = SliderButton.getStepSize(type);
        this.valueFraction = maxValue - minValue;
        this.field_22753 = (this.initValue - minValue) / this.valueFraction;
        if (this.minValue == 0.0f && this.maxValue == 360.0f || this.minValue == -180.0f && this.maxValue == 180.0f) {
            this.roundFactor = 1.0f;
        }
        this.onChange = onChange;
        this.type = type;
        this.updateTargetValue();
        this.method_25346();
    }

    private static float getMinValue(Type type) {
        return switch (type) {
            case Type.DEGREE -> -180.0f;
            case Type.DOUBLE -> 0.0f;
            case Type.SCALE -> 0.1f;
            case Type.POSITION -> -24.0f;
            default -> -100.0f;
        };
    }

    private static float getMaxValue(Type type) {
        return switch (type) {
            case Type.DEGREE -> 180.0f;
            case Type.DOUBLE -> 1024.0f;
            case Type.SCALE -> 10.0f;
            case Type.POSITION -> 24.0f;
            default -> 100.0f;
        };
    }

    private static float getStepSize(Type type) {
        return switch (type) {
            case Type.DEGREE -> 0.5f;
            case Type.DOUBLE -> 1.0f;
            case Type.SCALE, Type.POSITION -> 0.1f;
            default -> 1.0f;
        };
    }

    public void setDefaultValue(double value) {
        this.setDefaultValue((float)Math.round(value * (double)this.roundFactor) / this.roundFactor);
    }

    public void setDefaultValue(float value) {
        this.initValue = value;
        this.field_22753 = (this.initValue - this.minValue) / this.valueFraction;
        this.method_25344();
        this.method_25346();
    }

    public void reset() {
        this.setDefaultValue(0.0f);
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    private void setTargetValue(double value) {
        this.field_22753 = value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
        this.method_25344();
        this.method_25346();
    }

    public double getTargetDoubleValue() {
        return this.targetValue;
    }

    private void updateTargetValue() {
        this.targetValue = (float)Math.round(((double)this.minValue + (double)this.valueFraction * this.field_22753) * (double)this.roundFactor) / this.roundFactor;
    }

    private double getStepSize() {
        return this.stepSize / this.valueFraction;
    }

    protected void method_25346() {
        switch (this.type) {
            case DEGREE: {
                this.method_25355((class_2561)class_2561.method_43470((String)(this.targetValue + "\u00b0")));
                break;
            }
            default: {
                this.method_25355((class_2561)class_2561.method_43470((String)("" + this.targetValue)));
            }
        }
    }

    protected void method_25344() {
        this.updateTargetValue();
        this.onChange.onChange(this);
    }

    protected void renderBg(@NotNull class_332 guiGraphics) {
        int i = this.method_25367() ? 60 : 40;
        guiGraphics.method_25302(SLIDER_LOCATION, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 0, i, 4, this.field_22759);
        guiGraphics.method_25302(SLIDER_LOCATION, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)) + 4, this.method_46427(), 196, i, 4, this.field_22759);
        guiGraphics.method_25302(SLIDER_LOCATION, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427() + this.field_22759 - 4, 0, i + 20 - 4, 4, 4);
        guiGraphics.method_25302(SLIDER_LOCATION, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)) + 4, this.method_46427() + this.field_22759 - 4, 196, i + 20 - 4, 4, 4);
    }

    public boolean method_25404(int keyCode, int unused1, int unused2) {
        if (keyCode == 263 || keyCode == 262) {
            float step = keyCode == 263 ? -1.0f : 1.0f;
            double incrementalSteps = (double)step * this.getStepSize();
            this.setTargetValue(this.field_22753 + incrementalSteps);
        }
        return false;
    }

    public boolean method_25401(double x, double y, double distance) {
        if (this.method_25367()) {
            double incrementalSteps = distance * this.getStepSize();
            this.setTargetValue(this.field_22753 + incrementalSteps);
        }
        return true;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderButton(class_332 guiGraphics, int left, int top, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        int i = this.method_25367() ? 20 : 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.method_25302(SLIDER_LOCATION, this.method_46426(), this.method_46427(), 0, i, this.field_22758 / 2, this.field_22759);
        guiGraphics.method_25302(SLIDER_LOCATION, this.method_46426() + this.field_22758 / 2, this.method_46427(), 200 - this.field_22758 / 2, i, this.field_22758 / 2, this.field_22759);
        guiGraphics.method_25302(SLIDER_LOCATION, this.method_46426(), this.method_46427() + this.field_22759 - 4, 0, i + 20 - 4, this.field_22758 / 2, 4);
        guiGraphics.method_25302(SLIDER_LOCATION, this.method_46426() + this.field_22758 / 2, this.method_46427() + this.field_22759 - 4, 200 - this.field_22758 / 2, i + 20 - 4, this.field_22758 / 2, 4);
        this.renderBg(guiGraphics);
        int fgColor = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        guiGraphics.method_27534(font, this.method_25369(), this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, fgColor | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    public static enum Type {
        DOUBLE,
        DEGREE,
        POSITION,
        SCALE,
        UNKNOWN;

    }

    public static interface OnChange {
        public void onChange(SliderButton var1);
    }
}

