/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.objective;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class ObjectiveConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static final int SPACE_BETWEEN_ENTRIES = 20;
    protected final ObjectiveDataSet objectiveDataSet = this.getObjectiveDataSet();
    protected class_4185 basicObjectiveButton;
    protected class_4185 followObjectiveButton;
    protected class_4185 attackObjectiveButton;
    protected class_4185 lookObjectiveButton;

    public ObjectiveConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    protected Checkbox getObjectiveCheckbox(int left, int top, ObjectiveType objectiveType) {
        return this.getObjectiveCheckbox(left, top, objectiveType, 0.6);
    }

    protected Checkbox getObjectiveCheckbox(int left, int top, ObjectiveType objectiveType, double speedModifier) {
        return new Checkbox(left, top, objectiveType.getObjectiveName(), this.objectiveDataSet.hasObjective(objectiveType), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = this.objectiveDataSet.getOrCreateObjective(objectiveType);
            objectiveDataEntry.setSpeedModifier(speedModifier);
            if (checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        });
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.basicObjectiveButton = (class_4185)this.method_37063((class_364)new TextButton(this.buttonLeftPos, this.buttonTopPos, 60, "basic", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.BASIC_OBJECTIVE)));
        this.followObjectiveButton = (class_4185)this.method_37063((class_364)new TextButton(this.basicObjectiveButton.method_46426() + this.basicObjectiveButton.method_25368(), this.buttonTopPos, 60, "follow", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.FOLLOW_OBJECTIVE)));
        this.attackObjectiveButton = (class_4185)this.method_37063((class_364)new TextButton(this.followObjectiveButton.method_46426() + this.followObjectiveButton.method_25368(), this.buttonTopPos, 60, "attack", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ATTACK_OBJECTIVE)));
        this.lookObjectiveButton = (class_4185)this.method_37063((class_364)new TextButton(this.attackObjectiveButton.method_46426() + this.attackObjectiveButton.method_25368(), this.buttonTopPos, 65, "look", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.LOOK_OBJECTIVE)));
    }
}

