/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class CustomPoseConfigurationScreen<T extends ConfigurationMenu>
extends PoseConfigurationScreen<T> {
    protected SliderButton headSliderButton;
    protected SliderButton bodySliderButton;
    protected SliderButton armsSliderButton;
    protected SliderButton leftArmSliderButton;
    protected SliderButton rightArmSliderButton;
    protected SliderButton leftLegSliderButton;
    protected SliderButton rightLegSliderButton;

    public CustomPoseConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    private SliderButton createVisibilityRotationPositionSlider(int left, int top, ModelPart modelPart, String label) {
        SliderButton sliderRotationButtonX = this.createRotationSliderCompact(left, top, modelPart, label);
        SliderButton sliderPositionButtonX = this.createPositionSliderCompact(left, top + sliderRotationButtonX.method_25364(), modelPart, label);
        boolean modelPartVisibility = this.modelData.isModelPartVisible(modelPart);
        this.method_37063((class_364)new Checkbox(sliderRotationButtonX.method_46426() + 3, top - sliderPositionButtonX.method_25364(), "", modelPartVisibility, checkbox -> NetworkMessageHandlerManager.getServerHandler().modelVisibilityChange(this.getEasyNPCUUID(), modelPart, checkbox.selected())));
        return sliderRotationButtonX;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.customPoseButton.field_22763 = false;
        int sliderTopPos = this.contentTopPos + 16;
        int sliderLeftPos = this.contentLeftPos - 3;
        int sliderLeftSpace = 200;
        int sliderTopSpace = 66;
        VariantData<?> variantData = this.getEasyNPC().getEasyNPCVariantData();
        boolean hasCrossedArms = variantData.hasVariantCrossedArms();
        if (this.modelData.hasHeadModelPart()) {
            this.headSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.HEAD, "head");
        }
        if (this.modelData.hasBodyModelPart()) {
            this.bodySliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.BODY, "body");
        }
        sliderTopPos += sliderTopSpace;
        if (hasCrossedArms || !this.modelData.hasLeftArmModelPart() && !this.modelData.hasRightArmModelPart() && this.modelData.hasArmsModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.armsSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.ARMS, "arms");
        }
        if (!hasCrossedArms && this.modelData.hasRightArmModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.rightArmSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_ARM, "right_arm");
        }
        if (!hasCrossedArms && this.modelData.hasLeftArmModelPart()) {
            this.leftArmSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_ARM, "left_arm");
        }
        sliderTopPos += sliderTopSpace;
        if (this.modelData.hasRightLegModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.rightLegSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_LEG, "right_leg");
        }
        if (this.modelData.hasLeftLegModelPart()) {
            this.leftLegSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_LEG, "left_leg");
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        ScreenHelper.renderCustomPoseEntityAvatar(this.contentLeftPos + 152, this.contentTopPos + 165, 45, (float)(this.contentLeftPos + 150) - this.xMouse, (float)(this.contentTopPos + 100) - this.yMouse, this.getEasyNPC());
        if (this.modelData.hasHeadModelPart() && this.headSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.head", this.headSliderButton.method_46426() + 20, this.headSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasBodyModelPart() && this.bodySliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.body", this.bodySliderButton.method_46426() + 20, this.bodySliderButton.method_46427() - 12);
        }
        if (this.modelData.hasLeftArmModelPart() && this.leftArmSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.left_arm", this.leftArmSliderButton.method_46426() + 20, this.leftArmSliderButton.method_46427() - 12);
        } else if (this.modelData.hasArmsModelPart() && this.armsSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.arms", this.armsSliderButton.method_46426() + 20, this.armsSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasRightArmModelPart() && this.rightArmSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.right_arm", this.rightArmSliderButton.method_46426() + 20, this.rightArmSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasLeftLegModelPart() && this.leftLegSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.left_leg", this.leftLegSliderButton.method_46426() + 20, this.leftLegSliderButton.method_46427() - 12);
        }
        if (this.modelData.hasRightLegModelPart() && this.rightLegSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "pose.right_leg", this.rightLegSliderButton.method_46426() + 20, this.rightLegSliderButton.method_46427() - 12);
        }
    }

    @Override
    protected void renderBg(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.method_25294(this.contentLeftPos + 99, this.contentTopPos, this.contentLeftPos + 206, this.contentTopPos + 208, -16777216);
        guiGraphics.method_25294(this.contentLeftPos + 100, this.contentTopPos + 1, this.contentLeftPos + 205, this.contentTopPos + 207, -5592406);
    }
}

