/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class PoseConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected final ModelData<?> modelData = this.getEasyNPC().getEasyNPCModelData();
    protected class_4185 defaultPoseButton;
    protected class_4185 advancedPoseButton;
    protected class_4185 customPoseButton;

    public PoseConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    protected SliderButton createRotationSliderCompact(int left, int top, ModelPart modelPart, String label) {
        return this.createRotationSlider(left, top, modelPart, label, true);
    }

    protected SliderButton createRotationSlider(int left, int top, ModelPart modelPart, String label, boolean compact) {
        int sliderWidth = 34;
        int sliderLeftPosition = left;
        if (compact && (modelPart == ModelPart.BODY || modelPart == ModelPart.LEFT_ARM || modelPart == ModelPart.LEFT_LEG)) {
            sliderLeftPosition = left + 10;
        }
        CustomRotation modelPartRotation = this.modelData.getModelPartRotation(modelPart);
        SliderButton sliderButtonX = (SliderButton)this.method_37063((class_364)new SliderButton(sliderLeftPosition, top, sliderWidth, label + "RotationX", (float)Math.toDegrees(modelPartRotation.x()), SliderButton.Type.DEGREE, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation((float)Math.toRadians(slider.getTargetValue()), currentModelPartRotation.y(), currentModelPartRotation.z()));
        }));
        SliderButton sliderButtonY = (SliderButton)this.method_37063((class_364)new SliderButton(sliderButtonX.method_46426() + sliderButtonX.method_25368(), top, sliderWidth, label + "RotationY", (float)Math.toDegrees(modelPartRotation.y()), SliderButton.Type.DEGREE, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(currentModelPartRotation.x(), (float)Math.toRadians(slider.getTargetValue()), currentModelPartRotation.z()));
        }));
        SliderButton sliderButtonZ = (SliderButton)this.method_37063((class_364)new SliderButton(sliderButtonY.method_46426() + sliderButtonY.method_25368(), top, sliderWidth, label + "RotationZ", (float)Math.toDegrees(modelPartRotation.z()), SliderButton.Type.DEGREE, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(currentModelPartRotation.x(), currentModelPartRotation.y(), (float)Math.toRadians(slider.getTargetValue())));
        }));
        if (compact) {
            int resetButtonLeftPosition = switch (modelPart) {
                case ModelPart.BODY, ModelPart.LEFT_ARM, ModelPart.LEFT_LEG -> left;
                default -> sliderButtonZ.method_46426() + sliderButtonZ.method_25368();
            };
            this.method_37063((class_364)new TextButton(resetButtonLeftPosition, top, 10, (class_2561)class_2561.method_43470((String)"\u21ba"), button -> {
                sliderButtonX.reset();
                sliderButtonY.reset();
                sliderButtonZ.reset();
                NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(0.0f, 0.0f, 0.0f));
            }));
        } else {
            this.method_37063((class_364)new TextButton(sliderButtonX.method_46426(), top + 16, sliderWidth * 3, "reset", button -> {
                sliderButtonX.reset();
                sliderButtonY.reset();
                sliderButtonZ.reset();
                NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(0.0f, 0.0f, 0.0f));
            }));
        }
        return sliderButtonX;
    }

    protected SliderButton createPositionSliderCompact(int left, int top, ModelPart modelPart, String label) {
        return this.createPositionSlider(left, top, modelPart, label, true);
    }

    protected SliderButton createPositionSlider(int left, int top, ModelPart modelPart, String label, boolean compact) {
        int sliderWidth = 34;
        int sliderLeftPosition = left;
        if (compact && (modelPart == ModelPart.BODY || modelPart == ModelPart.LEFT_ARM || modelPart == ModelPart.LEFT_LEG)) {
            sliderLeftPosition = left + 10;
        }
        CustomPosition modelPartPosition = this.modelData.getModelPartPosition(modelPart);
        SliderButton sliderButtonX = (SliderButton)this.method_37063((class_364)new SliderButton(sliderLeftPosition, top, sliderWidth, label + "PositionX", modelPartPosition.x(), SliderButton.Type.POSITION, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(slider.getTargetValue(), currentModelPartPosition.y(), currentModelPartPosition.z()));
        }));
        SliderButton sliderButtonY = (SliderButton)this.method_37063((class_364)new SliderButton(sliderButtonX.method_46426() + sliderButtonX.method_25368(), top, sliderWidth, label + "PositionY", modelPartPosition.y(), SliderButton.Type.POSITION, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(currentModelPartPosition.x(), slider.getTargetValue(), currentModelPartPosition.z()));
        }));
        SliderButton sliderButtonZ = (SliderButton)this.method_37063((class_364)new SliderButton(sliderButtonY.method_46426() + sliderButtonY.method_25368(), top, sliderWidth, label + "PositionZ", modelPartPosition.z(), SliderButton.Type.POSITION, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(currentModelPartPosition.x(), currentModelPartPosition.y(), slider.getTargetValue()));
        }));
        if (compact) {
            int resetButtonLeftPosition = switch (modelPart) {
                case ModelPart.BODY, ModelPart.LEFT_ARM, ModelPart.LEFT_LEG -> left;
                default -> sliderButtonZ.method_46426() + sliderButtonZ.method_25368();
            };
            this.method_37063((class_364)new TextButton(resetButtonLeftPosition, top, 10, (class_2561)class_2561.method_43470((String)"\u21ba"), button -> {
                sliderButtonX.reset();
                sliderButtonY.reset();
                sliderButtonZ.reset();
                NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(0.0f, 0.0f, 0.0f));
            }));
        } else {
            this.method_37063((class_364)new TextButton(sliderButtonX.method_46426(), top + 20, sliderWidth * 3, "reset", button -> {
                sliderButtonX.reset();
                sliderButtonY.reset();
                sliderButtonZ.reset();
                NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(0.0f, 0.0f, 0.0f));
            }));
        }
        return sliderButtonX;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        int poseButtonWidth = 80;
        this.defaultPoseButton = (class_4185)this.method_37063((class_364)new TextButton(this.buttonLeftPos, this.buttonTopPos, poseButtonWidth - 10, "default", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_POSE)));
        this.advancedPoseButton = (class_4185)this.method_37063((class_364)new TextButton(this.buttonLeftPos + this.defaultPoseButton.method_25368(), this.buttonTopPos, poseButtonWidth + 10, "advanced", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ADVANCED_POSE)));
        this.customPoseButton = (class_4185)this.method_37063((class_364)new TextButton(this.advancedPoseButton.method_46426() + this.advancedPoseButton.method_25368(), this.buttonTopPos, poseButtonWidth + 20, "custom", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_POSE)));
    }
}

