/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.dialog;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.Screen;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogMetaData;
import de.markusbordihn.easynpc.data.dialog.DialogScreenLayout;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.menu.dialog.DialogMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class DialogScreen<T extends DialogMenu>
extends Screen<T> {
    private static final int BUTTON_WIDTH = 126;
    private static final int MIDDLE_BUTTON_WIDTH = 200;
    private static final int LARGE_BUTTON_WIDTH = 250;
    private static final int MAX_NUMBER_OF_PIXEL_PER_LINE = 180;
    private static final int MAX_NUMBER_OF_DIALOG_LINES = 10;
    private static DialogScreenLayout dialogScreenLayout = DialogScreenLayout.UNKNOWN;
    protected final ArrayList<class_4185> dialogButtons = new ArrayList();
    protected final class_2561 dialogText;
    protected final DialogMetaData dialogMetaData;
    protected class_4185 dialogForwardButton = null;
    protected class_4185 dialogBackwardButton = null;
    protected String dialog;
    protected class_2561 dialogComponent;
    protected int numberOfDialogLines = 1;
    protected int dialogPageIndex = 0;
    private List<class_5481> cachedDialogComponents = Collections.emptyList();

    public DialogScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.dialogText = this.getDialogText();
        this.dialogMetaData = new DialogMetaData(this.getEasyNPC().getLivingEntity(), (class_1657)(this.minecraftInstance != null ? this.minecraftInstance.field_1724 : null));
    }

    private static void setDialogScreenLayout(DialogScreenLayout dialogScreenLayout) {
        DialogScreen.dialogScreenLayout = dialogScreenLayout;
    }

    protected void renderDialog(class_332 guiGraphics) {
        int dialogTopPosition = this.topPos + 20;
        switch (dialogScreenLayout) {
            case COMPACT_TEXT_ONLY: 
            case COMPACT_TEXT_WITH_ONE_BUTTON: 
            case COMPACT_TEXT_WITH_TWO_BUTTONS: 
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: 
            case COMPACT_TEXT_WITH_THREE_BUTTONS: 
            case COMPACT_TEXT_WITH_FOUR_BUTTONS: 
            case COMPACT_TEXT_WITH_FIVE_BUTTONS: 
            case COMPACT_TEXT_WITH_SIX_BUTTONS: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DIALOG, this.leftPos + 70, dialogTopPosition, 0, 120, 205, 78);
                break;
            }
            default: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DIALOG, this.leftPos + 70, dialogTopPosition, 0, 0, 205, 118);
            }
        }
        if (!this.cachedDialogComponents.isEmpty()) {
            for (int line = this.dialogPageIndex * 10; line < this.numberOfDialogLines && line < 10 * (this.dialogPageIndex + 1); ++line) {
                Objects.requireNonNull(this.field_22793);
                int textTopPosition = dialogTopPosition + 6 + (line - this.dialogPageIndex * 10) * (9 + 2);
                class_5481 formattedCharSequence = this.cachedDialogComponents.get(line);
                Text.drawString(guiGraphics, this.field_22793, formattedCharSequence, this.leftPos + 87, textTopPosition, 0);
            }
        }
    }

    private void setDialogText(DialogDataEntry dialogData) {
        if (dialogData == null) {
            return;
        }
        String dialogText = dialogData.getDialogText(this.dialogMetaData);
        if (dialogText == null || dialogText.isBlank()) {
            return;
        }
        this.dialogComponent = class_2561.method_43470((String)dialogText);
        this.cachedDialogComponents = this.field_22793.method_1728((class_5348)this.dialogComponent, 180);
        Objects.requireNonNull(this.field_22793);
        this.numberOfDialogLines = Math.min(128 / 9, this.cachedDialogComponents.size());
    }

    private void addDialogButton(DialogButtonEntry dialogButtonEntry) {
        if (dialogButtonEntry == null) {
            return;
        }
        int dialogButtonMaxTextLength = switch (dialogScreenLayout) {
            case DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON, DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS, DialogScreenLayout.TEXT_WITH_ONE_BUTTON, DialogScreenLayout.TEXT_WITH_TWO_BUTTONS, DialogScreenLayout.TEXT_WITH_THREE_BUTTONS -> 41;
            case DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS -> 32;
            default -> 22;
        };
        class_2561 dialogButtonText = dialogButtonEntry.getButtonName(dialogButtonMaxTextLength);
        TextButton dialogButton = new TextButton(this.leftPos + 70, this.topPos + 55, 198, dialogButtonText, onPress -> {
            if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_BUTTON_CLICK)) {
                NetworkMessageHandlerManager.getServerHandler().triggerActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_BUTTON_CLICK);
            }
            if (dialogButtonEntry.hasActionData()) {
                UUID buttonId = dialogButtonEntry.id();
                NetworkMessageHandlerManager.getServerHandler().triggerDialogButtonAction(this.getEasyNPCUUID(), this.getDialogUUID(), buttonId);
            } else {
                this.closeScreen();
            }
        });
        dialogButton.field_22764 = dialogButtonEntry.name() != null && !dialogButtonEntry.name().isBlank();
        this.dialogButtons.add(dialogButton);
    }

    private class_4185 renderDialogButton(int buttonIndex, int width, int left, int top) {
        class_4185 dialogButton = this.dialogButtons.get(buttonIndex);
        dialogButton.method_25358(width);
        dialogButton.method_46421(left);
        dialogButton.method_46419(top);
        return (class_4185)this.method_37063((class_364)dialogButton);
    }

    private void renderDialogButtons() {
        switch (dialogScreenLayout) {
            case COMPACT_TEXT_ONLY: 
            case TEXT_ONLY: {
                break;
            }
            case COMPACT_TEXT_WITH_ONE_BUTTON: {
                this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 140);
                break;
            }
            case COMPACT_TEXT_WITH_TWO_BUTTONS: {
                class_4185 firstCompactDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                this.renderDialogButton(1, 126, firstCompactDialogButton.method_46426() + firstCompactDialogButton.method_25368() + 10, firstCompactDialogButton.method_46427());
                break;
            }
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: {
                class_4185 firstCompactLargeDialogButton = this.renderDialogButton(0, 200, this.leftPos + 75, this.topPos + 115);
                this.renderDialogButton(1, 200, firstCompactLargeDialogButton.method_46426(), firstCompactLargeDialogButton.method_46427() + firstCompactLargeDialogButton.method_25364() + 10);
                break;
            }
            case TEXT_WITH_ONE_BUTTON: {
                this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 170);
                break;
            }
            case TEXT_WITH_TWO_BUTTONS: {
                class_4185 firstTwoDialogButton = this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 145);
                this.renderDialogButton(1, 250, firstTwoDialogButton.method_46426(), firstTwoDialogButton.method_46427() + firstTwoDialogButton.method_25364() + 10);
                break;
            }
            case COMPACT_TEXT_WITH_THREE_BUTTONS: 
            case TEXT_WITH_THREE_BUTTONS: {
                class_4185 firstThreeDialogButton = this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 140);
                class_4185 secondThreeDialogButton = this.renderDialogButton(1, 250, firstThreeDialogButton.method_46426(), firstThreeDialogButton.method_46427() + firstThreeDialogButton.method_25364() + 5);
                this.renderDialogButton(2, 250, secondThreeDialogButton.method_46426(), secondThreeDialogButton.method_46427() + secondThreeDialogButton.method_25364() + 5);
                break;
            }
            case COMPACT_TEXT_WITH_FOUR_BUTTONS: 
            case TEXT_WITH_FOUR_BUTTONS: {
                class_4185 firstFourDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 150);
                class_4185 secondFourDialogButton = this.renderDialogButton(1, 126, firstFourDialogButton.method_46426() + firstFourDialogButton.method_25368() + 10, firstFourDialogButton.method_46427());
                class_4185 thirdFourDialogButton = this.renderDialogButton(2, 126, firstFourDialogButton.method_46426(), firstFourDialogButton.method_46427() + firstFourDialogButton.method_25364() + 10);
                this.renderDialogButton(3, 126, secondFourDialogButton.method_46426(), thirdFourDialogButton.method_46427());
                break;
            }
            case COMPACT_TEXT_WITH_FIVE_BUTTONS: 
            case TEXT_WITH_FIVE_BUTTONS: {
                class_4185 firstFiveDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                class_4185 secondFiveDialogButton = this.renderDialogButton(1, 126, firstFiveDialogButton.method_46426() + firstFiveDialogButton.method_25368() + 10, firstFiveDialogButton.method_46427());
                class_4185 thirdFiveDialogButton = this.renderDialogButton(2, 126, firstFiveDialogButton.method_46426(), firstFiveDialogButton.method_46427() + firstFiveDialogButton.method_25364() + 5);
                this.renderDialogButton(3, 126, secondFiveDialogButton.method_46426(), thirdFiveDialogButton.method_46427());
                this.renderDialogButton(4, 126, firstFiveDialogButton.method_46426(), thirdFiveDialogButton.method_46427() + thirdFiveDialogButton.method_25364() + 5);
                break;
            }
            case COMPACT_TEXT_WITH_SIX_BUTTONS: 
            case TEXT_WITH_SIX_BUTTONS: {
                class_4185 firstSixDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                class_4185 secondSixDialogButton = this.renderDialogButton(1, 126, firstSixDialogButton.method_46426() + firstSixDialogButton.method_25368() + 10, firstSixDialogButton.method_46427());
                class_4185 thirdSixDialogButton = this.renderDialogButton(2, 126, firstSixDialogButton.method_46426(), firstSixDialogButton.method_46427() + firstSixDialogButton.method_25364() + 5);
                this.renderDialogButton(3, 126, secondSixDialogButton.method_46426(), thirdSixDialogButton.method_46427());
                class_4185 fifthSixDialogButton = this.renderDialogButton(4, 126, firstSixDialogButton.method_46426(), thirdSixDialogButton.method_46427() + thirdSixDialogButton.method_25364() + 5);
                this.renderDialogButton(5, 126, secondSixDialogButton.method_46426(), fifthSixDialogButton.method_46427());
                break;
            }
            default: {
                log.warn("Unknown dialog screen layout {} for {} with {} line(s)", (Object)dialogScreenLayout, (Object)this.getDialogDataSet(), (Object)this.numberOfDialogLines);
            }
        }
    }

    private void defineDialogNavigationButtons() {
        int dialogNavigationButtonTopPosition = dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_ONLY || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_TWO_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_FOUR_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_FIVE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_SIX_BUTTONS ? this.topPos + 95 : this.topPos + 136;
        this.dialogForwardButton = (class_4185)this.method_37063((class_364)new SpriteButton(this.leftPos + 257, dialogNavigationButtonTopPosition, 12, 12, Constants.TEXTURE_DIALOG, 206, 2, 12, 12, onPress -> {
            int n = this.dialogPageIndex = this.dialogPageIndex < this.numberOfDialogLines / 10 ? this.dialogPageIndex + 1 : 0;
            if (this.dialogBackwardButton != null) {
                boolean bl = this.dialogBackwardButton.field_22763 = this.dialogPageIndex > 0;
            }
            if (this.dialogForwardButton != null) {
                this.dialogForwardButton.field_22763 = this.dialogPageIndex < this.numberOfDialogLines / 10;
            }
        }));
        this.dialogForwardButton.field_22763 = this.dialogPageIndex < this.numberOfDialogLines / 10;
        this.dialogBackwardButton = (class_4185)this.method_37063((class_364)new SpriteButton(this.leftPos + 245, dialogNavigationButtonTopPosition, 12, 12, Constants.TEXTURE_DIALOG, 207, 28, 12, 12, onPress -> {
            int n = this.dialogPageIndex = this.dialogPageIndex > 0 ? this.dialogPageIndex - 1 : this.numberOfDialogLines / 10;
            if (this.dialogForwardButton != null) {
                boolean bl = this.dialogForwardButton.field_22763 = this.dialogPageIndex < this.numberOfDialogLines / 10;
            }
            if (this.dialogBackwardButton != null) {
                this.dialogBackwardButton.field_22763 = this.dialogPageIndex > 0;
            }
        }));
        this.dialogBackwardButton.field_22763 = this.dialogPageIndex > 0;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.imageHeight = 200;
        this.imageWidth = 280;
        this.titleLabelX = 10;
        this.titleLabelY = 8;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.closeButton.method_46421(this.leftPos + this.imageWidth - 13);
        this.closeButton.method_46419(this.topPos + 4);
        DialogScreen.setDialogScreenLayout(DialogUtils.getDialogScreenLayout(this.getDialogData(), this.field_22793));
        log.debug("Prepare Dialog Screen {} with page index {} for {} with {} line(s) and layout {}", (Object)this.getDialogUUID(), (Object)this.getPageIndex(), (Object)this.getDialogDataSet(), (Object)this.numberOfDialogLines, (Object)dialogScreenLayout);
        this.setDialogText(this.getDialogData());
        log.debug("Dialog with {} line(s) and layout {}", (Object)this.numberOfDialogLines, (Object)dialogScreenLayout);
        if (this.numberOfDialogLines > 10) {
            this.defineDialogNavigationButtons();
        }
        if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_OPEN_DIALOG)) {
            NetworkMessageHandlerManager.getServerHandler().triggerActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_OPEN_DIALOG);
        }
        if (this.hasDialogData() && this.getDialogData().getNumberOfDialogButtons() > 0) {
            this.dialogButtons.ensureCapacity(this.getDialogData().getNumberOfDialogButtons());
            for (DialogButtonEntry dialogButtonEntry : this.getDialogData().getDialogButtons()) {
                if (dialogButtonEntry == null) continue;
                this.addDialogButton(dialogButtonEntry);
            }
            this.renderDialogButtons();
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        if (this.getEasyNPC() == null) {
            return;
        }
        super.method_25394(guiGraphics, x, y, partialTicks);
        int avatarPositionTop = 60 + this.getEasyNPC().getEasyNPCDialogData().getEntityDialogTop();
        int left = this.leftPos + 40;
        int top = this.topPos + 70 + avatarPositionTop;
        ScreenHelper.renderEntityDialog(left, top, Math.round((double)(left - 140) - (double)this.xMouse * 0.25), Math.round((double)(top - 120) - (double)this.yMouse * 0.5), this.getEasyNPC());
        this.renderDialog(guiGraphics);
    }

    @Override
    protected void renderLabels(class_332 guiGraphics, int x, int y) {
        Text.drawString(guiGraphics, this.field_22793, this.field_22785, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY);
    }

    @Override
    protected void renderBg(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        switch (dialogScreenLayout) {
            case UNKNOWN: {
                break;
            }
            case COMPACT_TEXT_ONLY: 
            case COMPACT_TEXT_WITH_ONE_BUTTON: 
            case COMPACT_TEXT_WITH_TWO_BUTTONS: 
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos, 0, 0, 200, 170);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos, 165, 0, 85, 170);
                break;
            }
            default: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos, 0, 0, 210, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos, 165, 0, 85, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos + 70, 0, 30, 210, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos + 70, 165, 30, 85, 140);
            }
        }
    }

    @Override
    public void method_25419() {
        if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_CLOSE_DIALOG)) {
            NetworkMessageHandlerManager.getServerHandler().triggerActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_CLOSE_DIALOG);
        }
        super.method_25419();
    }
}

