/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.spawner;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import de.markusbordihn.easynpc.menu.spawner.SpawnerMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import net.minecraft.class_1661;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerScreen<T extends SpawnerMenu>
extends class_465<T> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String SPAWNER_PREFIX = "spawner.";
    private final SpawnerMenu spawnerMenu;
    private class_342 delayEdit;
    private class_4185 delaySaveButton;
    private class_342 maxNearbyEntitiesEdit;
    private class_4185 maxNearbyEntitiesSaveButton;
    private class_342 requiredPlayerRangeEdit;
    private class_4185 requiredPlayerRangeSaveButton;
    private class_342 spawnCountEdit;
    private class_4185 spawnCountSaveButton;
    private class_342 spawnerDespawnRangeEdit;
    private class_4185 spawnerDespawnRangeSaveButton;
    private class_342 spawnerRangeEdit;
    private class_4185 spawnerRangeSaveButton;
    private boolean updatedDataFields = false;

    public SpawnerScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.spawnerMenu = menu;
    }

    public void method_25426() {
        super.method_25426();
        this.field_2779 = 243;
        this.field_2792 = 260;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2 + 2;
        this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        this.field_25270 = this.field_2779 - 92;
        int settingsLeft = this.field_2776 + 196;
        int settingsTop = this.field_2800 + 20;
        int settingsWidth = 35;
        this.requiredPlayerRangeEdit = (class_342)this.method_37063((class_364)new PositiveNumberField(this.field_22793, settingsLeft, settingsTop, settingsWidth, this.spawnerMenu.getRequiredPlayerRange(), 3));
        this.requiredPlayerRangeEdit.method_1863(value -> {
            if (this.requiredPlayerRangeSaveButton != null) {
                this.requiredPlayerRangeSaveButton.field_22763 = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getRequiredPlayerRange();
            }
        });
        this.requiredPlayerRangeSaveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.requiredPlayerRangeEdit.method_46426() + this.requiredPlayerRangeEdit.method_25368() + 5, this.requiredPlayerRangeEdit.method_46427() - 1, button -> {
            if (this.requiredPlayerRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.REQUIRED_PLAYER_RANGE, Integer.parseInt(this.requiredPlayerRangeEdit.method_1882()));
                this.requiredPlayerRangeSaveButton.field_22763 = false;
            }
        }));
        this.delayEdit = (class_342)this.method_37063((class_364)new PositiveNumberField(this.field_22793, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getDelay(), 4));
        this.delayEdit.method_1863(value -> {
            if (this.delaySaveButton != null) {
                this.delaySaveButton.field_22763 = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getDelay();
            }
        });
        this.delaySaveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.delayEdit.method_46426() + this.delayEdit.method_25368() + 5, this.delayEdit.method_46427() - 1, button -> {
            if (this.delayEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.DELAY, Integer.parseInt(this.delayEdit.method_1882()));
                this.delaySaveButton.field_22763 = false;
            }
        }));
        this.maxNearbyEntitiesEdit = (class_342)this.method_37063((class_364)new PositiveNumberField(this.field_22793, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getMaxNearbyEntities(), 2));
        this.maxNearbyEntitiesEdit.method_1863(value -> {
            if (this.maxNearbyEntitiesSaveButton != null) {
                this.maxNearbyEntitiesSaveButton.field_22763 = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getMaxNearbyEntities();
            }
        });
        this.maxNearbyEntitiesSaveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.maxNearbyEntitiesEdit.method_46426() + this.maxNearbyEntitiesEdit.method_25368() + 5, this.maxNearbyEntitiesEdit.method_46427() - 1, button -> {
            if (this.maxNearbyEntitiesEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.MAX_NEARBY_ENTITIES, Integer.parseInt(this.maxNearbyEntitiesEdit.method_1882()));
                this.maxNearbyEntitiesSaveButton.field_22763 = false;
            }
        }));
        this.spawnCountEdit = (class_342)this.method_37063((class_364)new PositiveNumberField(this.field_22793, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getSpawnCount(), 3));
        this.spawnCountEdit.method_1863(value -> {
            if (this.spawnCountSaveButton != null) {
                this.spawnCountSaveButton.field_22763 = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getSpawnCount();
            }
        });
        this.spawnCountSaveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.spawnCountEdit.method_46426() + this.spawnCountEdit.method_25368() + 5, this.spawnCountEdit.method_46427() - 1, button -> {
            if (this.spawnCountEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.SPAWN_COUNT, Integer.parseInt(this.spawnCountEdit.method_1882()));
                this.spawnCountSaveButton.field_22763 = false;
            }
        }));
        this.spawnerRangeEdit = (class_342)this.method_37063((class_364)new PositiveNumberField(this.field_22793, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getSpawnRange(), 3));
        this.spawnerRangeEdit.method_1863(value -> {
            if (this.spawnerRangeSaveButton != null && this.spawnerDespawnRangeEdit != null) {
                this.spawnerRangeSaveButton.field_22763 = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getSpawnRange() && Integer.parseInt(value) < Integer.parseInt(this.spawnerDespawnRangeEdit.method_1882());
            }
        });
        this.spawnerRangeSaveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.spawnerRangeEdit.method_46426() + this.spawnerRangeEdit.method_25368() + 5, this.spawnerRangeEdit.method_46427() - 1, button -> {
            if (this.spawnerRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.SPAWN_RANGE, Integer.parseInt(this.spawnerRangeEdit.method_1882()));
                this.spawnerRangeSaveButton.field_22763 = false;
            }
        }));
        this.spawnerDespawnRangeEdit = (class_342)this.method_37063((class_364)new PositiveNumberField(this.field_22793, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getDespawnRange(), 3));
        this.spawnerDespawnRangeEdit.method_1863(value -> {
            if (this.spawnerDespawnRangeSaveButton != null && this.spawnerRangeEdit != null) {
                this.spawnerDespawnRangeSaveButton.field_22763 = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getDespawnRange() && Integer.parseInt(value) > Integer.parseInt(this.spawnerRangeEdit.method_1882());
            }
        });
        this.spawnerDespawnRangeSaveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.spawnerDespawnRangeEdit.method_46426() + this.spawnerDespawnRangeEdit.method_25368() + 5, this.spawnerDespawnRangeEdit.method_46427() - 1, button -> {
            if (this.spawnerDespawnRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.DESPAWN_RANGE, Integer.parseInt(this.spawnerDespawnRangeEdit.method_1882()));
                this.spawnerDespawnRangeSaveButton.field_22763 = false;
            }
        }));
    }

    protected void method_37432() {
        super.method_37432();
        if (!this.updatedDataFields) {
            this.updateDataFields();
            this.updatedDataFields = true;
        }
    }

    protected void updateDataFields() {
        if (this.spawnerRangeEdit != null) {
            this.spawnerRangeEdit.method_1852(String.valueOf(this.spawnerMenu.getSpawnRange()));
        }
        if (this.spawnerDespawnRangeEdit != null) {
            this.spawnerDespawnRangeEdit.method_1852(String.valueOf(this.spawnerMenu.getDespawnRange()));
        }
        if (this.requiredPlayerRangeEdit != null) {
            this.requiredPlayerRangeEdit.method_1852(String.valueOf(this.spawnerMenu.getRequiredPlayerRange()));
        }
        if (this.delayEdit != null) {
            this.delayEdit.method_1852(String.valueOf(this.spawnerMenu.getDelay()));
        }
        if (this.maxNearbyEntitiesEdit != null) {
            this.maxNearbyEntitiesEdit.method_1852(String.valueOf(this.spawnerMenu.getMaxNearbyEntities()));
        }
        if (this.spawnCountEdit != null) {
            this.spawnCountEdit.method_1852(String.valueOf(this.spawnerMenu.getSpawnCount()));
        }
    }

    protected void changeSpawnerSetting(class_2338 blockPos, SpawnerSettingType spawnerSettingType, int value) {
        NetworkMessageHandlerManager.getServerHandler().changeSpawnerSettings(blockPos, spawnerSettingType, value);
    }

    protected void renderLabels(class_332 guiGraphics) {
        int labelOffsetX = -180;
        int labelOffsetY = 4;
        if (this.spawnerRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, SPAWNER_PREFIX + SpawnerSettingType.SPAWN_RANGE.name().toLowerCase(), this.spawnerRangeEdit.method_46426() + labelOffsetX, this.spawnerRangeEdit.method_46427() + labelOffsetY);
        }
        if (this.spawnerDespawnRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, SPAWNER_PREFIX + SpawnerSettingType.DESPAWN_RANGE.name().toLowerCase(), this.spawnerDespawnRangeEdit.method_46426() + labelOffsetX, this.spawnerDespawnRangeEdit.method_46427() + labelOffsetY);
        }
        if (this.requiredPlayerRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, SPAWNER_PREFIX + SpawnerSettingType.REQUIRED_PLAYER_RANGE.name().toLowerCase(), this.requiredPlayerRangeEdit.method_46426() + labelOffsetX, this.requiredPlayerRangeEdit.method_46427() + labelOffsetY);
        }
        if (this.delayEdit != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, SPAWNER_PREFIX + SpawnerSettingType.DELAY.name().toLowerCase(), this.delayEdit.method_46426() + labelOffsetX, this.delayEdit.method_46427() + labelOffsetY);
        }
        if (this.maxNearbyEntitiesEdit != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, SPAWNER_PREFIX + SpawnerSettingType.MAX_NEARBY_ENTITIES.name().toLowerCase(), this.maxNearbyEntitiesEdit.method_46426() + labelOffsetX, this.maxNearbyEntitiesEdit.method_46427() + labelOffsetY);
        }
        if (this.spawnCountEdit != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, SPAWNER_PREFIX + SpawnerSettingType.SPAWN_COUNT.name().toLowerCase(), this.spawnCountEdit.method_46426() + labelOffsetX, this.spawnCountEdit.method_46427() + labelOffsetY);
        }
        Text.drawConfigString(guiGraphics, this.field_22793, "spawner.preset_item", this.field_2776 + 42 - 20, this.field_2800 + 169 + 22, this.spawnerMenu.getPresetItem().method_7960() ? 0xFF5555 : 0xAAAAAA);
    }

    public void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        Text.drawString(guiGraphics, this.field_22793, this.field_22785, this.field_25267 + 80, this.field_25268 + 2, 0);
        Text.drawString(guiGraphics, this.field_22793, "(" + this.spawnerMenu.getSpawnerPosition().method_23854() + ")", this.field_25267 + 180, this.field_25268 + 2, 0xAAAAAA);
        Text.drawString(guiGraphics, this.field_22793, this.field_29347, this.field_25269 + 90, this.field_25270 - 10, 0);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderLabels(guiGraphics);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.field_2776, this.field_2800, 0, 0, 210, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.field_2776 + 153, this.field_2800, 132, 0, 120, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.field_2776, this.field_2800 + 77, 0, 5, 210, 170);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.field_2776 + 153, this.field_2800 + 77, 132, 5, 120, 170);
        Graphics.blit(guiGraphics, Constants.TEXTURE_INVENTORY, this.field_2776 + 97, this.field_2800 + 152, 7, 83, 162, 54);
        Graphics.blit(guiGraphics, Constants.TEXTURE_INVENTORY, this.field_2776 + 97, this.field_2800 + 212, 7, 141, 162, 18);
        Graphics.blit(guiGraphics, Constants.TEXTURE_INVENTORY, this.field_2776 + 42 - 1, this.field_2800 + 169 - 1, 76, 61, 18, 18);
        if (this.spawnerMenu.getPresetItem().method_7960()) {
            Graphics.blit(guiGraphics, Constants.TEXTURE_SPAWNER, this.field_2776 + 42 + 20, this.field_2800 + 169 + 2, 0, 0, 32, 12);
            Graphics.blit(guiGraphics, Constants.TEXTURE_SPAWNER, this.field_2776 + 42 + 1, this.field_2800 + 169, 2, 12, 16, 16);
        }
    }
}

