/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.RemoteSkinDataFiles;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final HashMap<TextureModelKey, class_2960> textureCache = new HashMap();
    private static final HashMap<TextureModelKey, SkinType> textureSkinTypeCache = new HashMap();
    private static final HashMap<TextureModelKey, String> textureSkinURLCache = new HashMap();
    private static final HashSet<UUID> textureReloadProtection = new HashSet();
    private static final String LOG_PREFIX = "[Remote Texture Manager] ";

    private RemoteTextureManager() {
    }

    public static Set<UUID> getTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || !RemoteTextureManager.hasTextureSkinData(textureModelKey)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static String getTextureSkinURL(TextureModelKey textureModelKey) {
        return textureSkinURLCache.get(textureModelKey);
    }

    public static SkinType getTextureSkinType(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.get(textureModelKey);
    }

    public static boolean hasTextureSkinData(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.containsKey(textureModelKey) && textureSkinURLCache.containsKey(textureModelKey);
    }

    public static class_2960 getOrCreateTextureWithDefault(SkinData<?> skinData, class_2960 defaultResourceLocation) {
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        class_2960 resourceLocation = textureCache.get(textureModelKey);
        String skinURL = skinData.getSkinURL();
        if (resourceLocation != null) {
            if (!RemoteTextureManager.hasTextureSkinData(textureModelKey)) {
                textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
                textureSkinURLCache.put(textureModelKey, skinURL);
            }
            return resourceLocation;
        }
        class_2960 createdResourceLocation = RemoteTextureManager.createTexture(textureModelKey, skinData, skinURL);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static class_2960 createTexture(TextureModelKey textureModelKey, SkinData<?> skinData, String skinURL) {
        UUID skinUUID = textureModelKey.getUUID();
        if (!textureReloadProtection.add(skinUUID)) {
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = RemoteSkinDataFiles.getRemoteSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        class_2960 localTextureCache = TextureManager.getCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            textureSkinURLCache.put(textureModelKey, skinURL);
            return localTextureCache;
        }
        class_2960 resourceLocation = TextureManager.addRemoteTexture(textureModelKey, skinURL, textureDataFolder);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            textureSkinURLCache.put(textureModelKey, skinURL);
            return resourceLocation;
        }
        log.error("{} Unable to load remote texture {} ({}) from {}!", (Object)LOG_PREFIX, (Object)textureModelKey, (Object)skinURL, (Object)textureDataFolder);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_43496((class_2561)class_2561.method_43470((String)("[Remote Texture Manager] Unable to load remote " + skinURL + " texture " + textureModelKey)).method_27692(class_124.field_1061));
        }
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        RemoteTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        class_2960 resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }
}

