/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogMetaData;
import de.markusbordihn.easynpc.data.dialog.DialogScreenLayout;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.utils.TextFormattingCodes;
import java.util.LinkedHashSet;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class DialogUtils {
    private static final String MACRO_NPC_STRING = "@npc";
    private static final String MACRO_INITIATOR_STRING = "@initiator";
    private static final int MAX_DIALOG_LINE_LENGTH = 178;
    private static final int MAX_SMALL_BUTTON_NAME_LENGTH = 20;

    protected DialogUtils() {
    }

    public static String parseDialogText(class_2561 component, DialogMetaData dialogMetaData) {
        if (dialogMetaData == null) {
            return component.getString();
        }
        return DialogUtils.parseDialogText(component.getString(), dialogMetaData.livingEntity(), dialogMetaData.player());
    }

    public static String parseDialogText(String text, class_1309 entity, class_1657 player) {
        if (DialogUtils.hasDialogMacros(text)) {
            if (entity != null) {
                text = text.replace(MACRO_NPC_STRING, entity.method_5477().getString());
            }
            if (player != null) {
                text = text.replace(MACRO_INITIATOR_STRING, player.method_5477().getString());
            }
        }
        text = TextFormattingCodes.parseTextLineBreaks(text);
        text = TextFormattingCodes.parseTextFormattingCodes(text);
        return text;
    }

    public static boolean hasDialogMacros(class_2561 component) {
        return component != null && DialogUtils.hasDialogMacros(component.getString());
    }

    public static boolean hasDialogMacros(String text) {
        return text != null && !text.isEmpty() && (text.contains(MACRO_NPC_STRING) || text.contains(MACRO_INITIATOR_STRING));
    }

    public static String generateButtonLabel(String name) {
        return DialogUtils.generateLabel(name, "button", 32);
    }

    public static String generateDialogLabel(String name) {
        return DialogUtils.generateLabel(name, "dialog", 32);
    }

    private static String generateLabel(String name, String type, int maxLength) {
        if (name == null || name.isEmpty()) {
            return type + "_" + UUID.randomUUID().toString().substring(0, 8).replace("-", "").toLowerCase();
        }
        String label = name.trim().toLowerCase();
        label = label.replace(" ", "_");
        return (label = label.replaceAll("[^a-z0-9_]", "")).length() > maxLength ? label.substring(0, maxLength) : label;
    }

    public static int getNumbersOfDialogLines(class_2561 component, class_327 font) {
        return DialogUtils.getNumbersOfDialogLines(component, 178, font);
    }

    public static int getNumbersOfDialogLines(String text, class_327 font) {
        return DialogUtils.getNumbersOfDialogLines(text, 178, font);
    }

    public static int getNumbersOfDialogLines(String text, int maxLineLength, class_327 font) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        class_5250 textComponent = class_2561.method_43470((String)text);
        return DialogUtils.getNumbersOfDialogLines((class_2561)class_2561.method_43470((String)text), maxLineLength, font);
    }

    public static int getNumbersOfDialogLines(class_2561 component, int maxLineLength, class_327 font) {
        return font.method_1728((class_5348)component, maxLineLength).size();
    }

    public static DialogDataSet getBasicDialog(String dialog) {
        DialogDataSet dialogDataSet = new DialogDataSet(DialogType.BASIC);
        DialogDataEntry dialogData = new DialogDataEntry("Basic Dialog", dialog);
        dialogDataSet.addDialog(dialogData);
        return dialogDataSet;
    }

    public static DialogDataSet getYesNoDialog(String dialogText, String yesButtonText, String noButtonText, String yesDialogText, String noDialogText) {
        ActionDataSet yesActionDataSet = new ActionDataSet();
        yesActionDataSet.add(new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, "yes_answer"));
        ActionDataSet noActionDataSet = new ActionDataSet();
        noActionDataSet.add(new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, "no_answer"));
        DialogButtonEntry yesButtonData = new DialogButtonEntry(yesButtonText, "yes_button", yesActionDataSet);
        DialogButtonEntry noButtonData = new DialogButtonEntry(noButtonText, "no_button", noActionDataSet);
        LinkedHashSet<DialogButtonEntry> buttons = new LinkedHashSet<DialogButtonEntry>();
        buttons.add(yesButtonData);
        buttons.add(noButtonData);
        DialogDataSet dialogDataSet = new DialogDataSet(DialogType.YES_NO);
        dialogDataSet.addDefaultDialog(new DialogDataEntry("question", "Question Dialog", dialogText, buttons));
        dialogDataSet.addDialog(new DialogDataEntry("yes_answer", "Yes Dialog", yesDialogText));
        dialogDataSet.addDialog(new DialogDataEntry("no_answer", "No Dialog", noDialogText));
        return dialogDataSet;
    }

    public static DialogScreenLayout getDialogScreenLayout(DialogDataEntry dialogData, class_327 font) {
        boolean hasLargeButtonName;
        if (dialogData == null) {
            return DialogScreenLayout.UNKNOWN;
        }
        boolean hasText = !dialogData.getText().isBlank();
        int numberOfButtons = dialogData.getNumberOfDialogButtons();
        if (!hasText) {
            return DialogScreenLayout.UNKNOWN;
        }
        class_2561 dialogText = dialogData.getDialogText();
        boolean hasDialogMacros = DialogUtils.hasDialogMacros(dialogText);
        if (TextFormattingCodes.hasTextLinebreakCodes(dialogText)) {
            dialogText = TextFormattingCodes.parseTextLineBreaks(dialogText);
        }
        int numberOfLines = DialogUtils.getNumbersOfDialogLines(dialogText, font);
        if (hasDialogMacros) {
            numberOfLines += 20;
        }
        int maxButtonNameLength = 0;
        if (numberOfButtons > 0) {
            for (DialogButtonEntry buttonData : dialogData.getDialogButtons()) {
                int buttonNameLength = buttonData.name().length();
                if (buttonNameLength <= maxButtonNameLength) continue;
                maxButtonNameLength = buttonNameLength;
            }
        }
        boolean bl = hasLargeButtonName = maxButtonNameLength > 20;
        if (numberOfLines <= 6) {
            if (numberOfButtons == 0) {
                return DialogScreenLayout.COMPACT_TEXT_ONLY;
            }
            if (numberOfButtons == 1) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON;
            }
            if (numberOfButtons == 2) {
                return hasLargeButtonName ? DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS : DialogScreenLayout.COMPACT_TEXT_WITH_TWO_BUTTONS;
            }
            if (numberOfButtons == 3) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS;
            }
            if (numberOfButtons == 4) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_FOUR_BUTTONS;
            }
            if (numberOfButtons == 5) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_FIVE_BUTTONS;
            }
            if (numberOfButtons == 6) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_SIX_BUTTONS;
            }
        }
        if (numberOfButtons == 0) {
            return DialogScreenLayout.TEXT_ONLY;
        }
        if (numberOfButtons == 1) {
            return DialogScreenLayout.TEXT_WITH_ONE_BUTTON;
        }
        if (numberOfButtons == 2) {
            return DialogScreenLayout.TEXT_WITH_TWO_BUTTONS;
        }
        if (numberOfButtons == 3) {
            return DialogScreenLayout.TEXT_WITH_THREE_BUTTONS;
        }
        if (numberOfButtons == 4) {
            return DialogScreenLayout.TEXT_WITH_FOUR_BUTTONS;
        }
        if (numberOfButtons == 5) {
            return DialogScreenLayout.TEXT_WITH_FIVE_BUTTONS;
        }
        if (numberOfButtons == 6) {
            return DialogScreenLayout.TEXT_WITH_SIX_BUTTONS;
        }
        return DialogScreenLayout.UNKNOWN;
    }
}

