/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.objective;

import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.data.objective.ObjectiveUtils;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class ObjectiveDataEntry {
    public static final String DATA_ATTACK_INTERVAL_TAG = "AttackInterval";
    public static final String DATA_ATTACK_RADIUS_TAG = "AttackRadius";
    public static final String DATA_CAN_DEAL_WITH_DOORS_TAG = "CanDealWithDoors";
    public static final String DATA_DISTANCE_TO_POI_TAG = "DistanceToPoi";
    public static final String DATA_ID_TAG = "Id";
    public static final String DATA_INTERVAL_TAG = "Interval";
    public static final String DATA_LOOK_DISTANCE_TAG = "LookDistance";
    public static final String DATA_MUST_REACH_TARGET_TAG = "MustReachTarget";
    public static final String DATA_MUST_SEE_TARGET_TAG = "MustSeeTarget";
    public static final String DATA_ONLY_AT_NIGHT_TAG = "OnlyAtNight";
    public static final String DATA_PRIORITY_TAG = "Prio";
    public static final String DATA_PROBABILITY_TAG = "Probability";
    public static final String DATA_SPEED_MODIFIER_TAG = "SpeedModifier";
    public static final String DATA_START_DISTANCE_TAG = "StartDistance";
    public static final String DATA_STOP_DISTANCE_TAG = "StopDistance";
    public static final String DATA_TARGET_ENTITY_UUID_TAG = "TargetEntityUUID";
    public static final String DATA_TARGET_OWNER_UUID_TAG = "TargetOwnerUUID";
    public static final String DATA_TARGET_PLAYER_NAME_TAG = "TargetPlayerName";
    public static final String DATA_TYPE_TAG = "Type";
    private int attackInterval = 20;
    private float attackRadius = 8.0f;
    private BooleanSupplier canDealWithDoors = () -> false;
    private int distanceToPoi = 16;
    private class_1352 goal = null;
    private String id = UUID.randomUUID().toString();
    private int interval = 10;
    private boolean isRegistered = false;
    private float lookDistance = 15.0f;
    private boolean mustReachTarget = true;
    private boolean mustSeeTarget = true;
    private ObjectiveType objectiveType = ObjectiveType.NONE;
    private boolean onlyAtNight = false;
    private int priority = 1;
    private float probability = 1.0f;
    private double speedModifier = 0.7;
    private float startDistance = 16.0f;
    private float stopDistance = 2.0f;
    private class_1352 target = null;
    private UUID targetEntityUUID;
    private UUID targetOwnerUUID;
    private String targetPlayerName;

    public ObjectiveDataEntry() {
    }

    public ObjectiveDataEntry(ObjectiveType objectiveType) {
        this.id = objectiveType.name();
        this.objectiveType = objectiveType;
    }

    public ObjectiveDataEntry(ObjectiveType objectiveType, int priority) {
        this(objectiveType);
        this.priority = priority;
    }

    public ObjectiveDataEntry(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public ObjectiveType getType() {
        return this.objectiveType;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public double getSpeedModifier() {
        return this.speedModifier;
    }

    public void setSpeedModifier(double speedModifier) {
        this.speedModifier = speedModifier;
    }

    public float getStartDistance() {
        return this.startDistance;
    }

    public float getStopDistance() {
        return this.stopDistance;
    }

    public float getProbability() {
        return this.probability;
    }

    public int getDistanceToPoi() {
        return this.distanceToPoi;
    }

    public BooleanSupplier getCanDealWithDoors() {
        return this.canDealWithDoors;
    }

    public boolean getOnlyAtNight() {
        return this.onlyAtNight;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isMustSeeTarget() {
        return this.mustSeeTarget;
    }

    public boolean isMustReachTarget() {
        return this.mustReachTarget;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public String getTargetPlayerName() {
        return this.targetPlayerName;
    }

    public void setTargetPlayerName(String targetPlayerName) {
        this.targetPlayerName = targetPlayerName;
    }

    public float getLookDistance() {
        return this.lookDistance;
    }

    public float getAttackRadius() {
        return this.attackRadius;
    }

    public int getAttackInterval() {
        return this.attackInterval;
    }

    public class_3222 getTargetPlayer() {
        if (this.hasPlayerTarget()) {
            return LivingEntityManager.getPlayerByName(this.targetPlayerName);
        }
        return null;
    }

    public UUID getTargetOwnerUUID() {
        return this.targetOwnerUUID;
    }

    public void setTargetOwnerUUID(UUID targetOwnerUUID) {
        this.targetOwnerUUID = targetOwnerUUID;
    }

    public UUID getTargetEntityUUID() {
        return this.targetEntityUUID;
    }

    public void setTargetEntityUUID(UUID targetEntityUUID) {
        this.targetEntityUUID = targetEntityUUID;
    }

    public class_1309 getTargetEntity(EasyNPC<?> easyNPC) {
        return this.getTargetEntity(easyNPC.getServerLevel());
    }

    public class_1309 getTargetEntity(class_3218 serverLevel) {
        if (this.hasEntityTarget() && serverLevel != null) {
            return LivingEntityManager.getLivingEntityByUUID(this.targetEntityUUID, serverLevel);
        }
        return null;
    }

    public class_1297 getTargetOwner(EasyNPC<?> easyNPC) {
        return this.getTargetOwner(easyNPC.getServerLevel());
    }

    public class_1297 getTargetOwner(class_3218 serverLevel) {
        if (this.hasOwnerTarget() && this.targetOwnerUUID != null && serverLevel != null) {
            return LivingEntityManager.getPlayerByUUID(this.targetOwnerUUID, serverLevel);
        }
        return null;
    }

    public boolean hasTravelObjective() {
        return this.objectiveType.hasTravelObjective();
    }

    public boolean hasOwnerTarget() {
        return this.getType() == ObjectiveType.FOLLOW_OWNER && this.targetOwnerUUID != null;
    }

    public boolean hasPlayerTarget() {
        return this.getType() == ObjectiveType.FOLLOW_PLAYER && this.targetPlayerName != null && !this.targetPlayerName.isEmpty();
    }

    public boolean hasEntityTarget() {
        return this.getType() == ObjectiveType.FOLLOW_ENTITY_BY_UUID && this.targetEntityUUID != null;
    }

    public boolean hasValidTarget(EasyNPC<?> easyNPC) {
        class_3218 serverLevel = easyNPC.getServerLevel();
        return serverLevel != null && this.hasValidTarget(serverLevel);
    }

    public boolean hasValidTarget(class_3218 serverLevel) {
        if (!(this.hasOwnerTarget() || this.hasPlayerTarget() || this.hasEntityTarget())) {
            return true;
        }
        if (this.hasOwnerTarget()) {
            class_3222 serverPlayer = LivingEntityManager.getPlayerByUUID(this.targetOwnerUUID, serverLevel);
            return serverPlayer != null && serverPlayer.method_5805();
        }
        if (this.hasPlayerTarget()) {
            class_3222 serverPlayer = LivingEntityManager.getPlayerByName(this.targetPlayerName);
            return serverPlayer != null && serverPlayer.method_5805();
        }
        if (this.hasEntityTarget()) {
            class_1309 livingEntity = LivingEntityManager.getLivingEntityByUUID(this.targetEntityUUID, serverLevel);
            return livingEntity != null && livingEntity.method_5805();
        }
        return this.goal != null;
    }

    public class_1352 getGoal(EasyNPC<?> easyNPC) {
        if (this.goal == null) {
            this.goal = ObjectiveUtils.createObjectiveGoal(this, easyNPC);
        }
        return this.goal;
    }

    public class_1352 getTarget(EasyNPC<?> easyNPC) {
        if (this.target == null) {
            this.target = ObjectiveUtils.createObjectiveTarget(this, easyNPC);
        }
        return this.target;
    }

    public void load(class_2487 compoundTag) {
        this.objectiveType = ObjectiveType.get(compoundTag.method_10558(DATA_TYPE_TAG));
        this.priority = compoundTag.method_10550(DATA_PRIORITY_TAG);
        this.id = compoundTag.method_10545(DATA_ID_TAG) && !compoundTag.method_10558(DATA_ID_TAG).isEmpty() ? compoundTag.method_10558(DATA_ID_TAG) : this.objectiveType.name();
        if (compoundTag.method_10545(DATA_TARGET_ENTITY_UUID_TAG)) {
            this.targetEntityUUID = compoundTag.method_25926(DATA_TARGET_ENTITY_UUID_TAG);
        }
        if (compoundTag.method_10545(DATA_TARGET_PLAYER_NAME_TAG)) {
            this.targetPlayerName = compoundTag.method_10558(DATA_TARGET_PLAYER_NAME_TAG);
        }
        if (compoundTag.method_10545(DATA_TARGET_OWNER_UUID_TAG)) {
            this.targetOwnerUUID = compoundTag.method_25926(DATA_TARGET_OWNER_UUID_TAG);
        }
        if (compoundTag.method_10545(DATA_SPEED_MODIFIER_TAG)) {
            this.speedModifier = compoundTag.method_10574(DATA_SPEED_MODIFIER_TAG);
        }
        if (compoundTag.method_10545(DATA_START_DISTANCE_TAG)) {
            this.startDistance = compoundTag.method_10583(DATA_START_DISTANCE_TAG);
        }
        if (compoundTag.method_10545(DATA_STOP_DISTANCE_TAG)) {
            this.stopDistance = compoundTag.method_10583(DATA_STOP_DISTANCE_TAG);
        }
        if (compoundTag.method_10545(DATA_ONLY_AT_NIGHT_TAG)) {
            this.onlyAtNight = compoundTag.method_10577(DATA_ONLY_AT_NIGHT_TAG);
        }
        if (compoundTag.method_10545(DATA_DISTANCE_TO_POI_TAG)) {
            this.distanceToPoi = compoundTag.method_10550(DATA_DISTANCE_TO_POI_TAG);
        }
        if (compoundTag.method_10545(DATA_CAN_DEAL_WITH_DOORS_TAG)) {
            this.canDealWithDoors = () -> compoundTag.method_10577(DATA_CAN_DEAL_WITH_DOORS_TAG);
        }
        if (compoundTag.method_10545(DATA_LOOK_DISTANCE_TAG)) {
            this.lookDistance = compoundTag.method_10583(DATA_LOOK_DISTANCE_TAG);
        }
        if (compoundTag.method_10545(DATA_ATTACK_INTERVAL_TAG)) {
            this.attackInterval = compoundTag.method_10550(DATA_ATTACK_INTERVAL_TAG);
        }
        if (compoundTag.method_10545(DATA_ATTACK_RADIUS_TAG)) {
            this.attackRadius = compoundTag.method_10583(DATA_ATTACK_RADIUS_TAG);
        }
        if (compoundTag.method_10545(DATA_INTERVAL_TAG)) {
            this.interval = compoundTag.method_10550(DATA_INTERVAL_TAG);
        }
        if (compoundTag.method_10545(DATA_MUST_SEE_TARGET_TAG)) {
            this.mustSeeTarget = compoundTag.method_10577(DATA_MUST_SEE_TARGET_TAG);
        }
        if (compoundTag.method_10545(DATA_MUST_REACH_TARGET_TAG)) {
            this.mustReachTarget = compoundTag.method_10577(DATA_MUST_REACH_TARGET_TAG);
        }
        if (compoundTag.method_10545(DATA_PROBABILITY_TAG)) {
            this.probability = compoundTag.method_10583(DATA_PROBABILITY_TAG);
        }
    }

    public class_2487 save(class_2487 compoundTag) {
        compoundTag.method_10582(DATA_TYPE_TAG, this.objectiveType.name());
        compoundTag.method_10569(DATA_PRIORITY_TAG, this.priority);
        if (this.id != null && !this.id.isEmpty() && !this.id.equals(this.objectiveType.name())) {
            compoundTag.method_10582(DATA_ID_TAG, this.id);
        }
        if (this.targetEntityUUID != null) {
            compoundTag.method_25927(DATA_TARGET_ENTITY_UUID_TAG, this.targetEntityUUID);
        }
        if (this.targetPlayerName != null && !this.targetPlayerName.isEmpty()) {
            compoundTag.method_10582(DATA_TARGET_PLAYER_NAME_TAG, this.targetPlayerName);
        }
        if (this.targetOwnerUUID != null) {
            compoundTag.method_25927(DATA_TARGET_OWNER_UUID_TAG, this.targetOwnerUUID);
        }
        if (this.speedModifier != 0.7) {
            compoundTag.method_10549(DATA_SPEED_MODIFIER_TAG, this.speedModifier);
        }
        if (this.startDistance != 16.0f) {
            compoundTag.method_10548(DATA_START_DISTANCE_TAG, this.startDistance);
        }
        if (this.stopDistance != 2.0f) {
            compoundTag.method_10548(DATA_STOP_DISTANCE_TAG, this.stopDistance);
        }
        if (this.onlyAtNight) {
            compoundTag.method_10556(DATA_ONLY_AT_NIGHT_TAG, true);
        }
        if (this.distanceToPoi != 16) {
            compoundTag.method_10569(DATA_DISTANCE_TO_POI_TAG, this.distanceToPoi);
        }
        if (this.canDealWithDoors.getAsBoolean()) {
            compoundTag.method_10556(DATA_CAN_DEAL_WITH_DOORS_TAG, this.canDealWithDoors.getAsBoolean());
        }
        if (this.lookDistance != 15.0f) {
            compoundTag.method_10548(DATA_LOOK_DISTANCE_TAG, this.lookDistance);
        }
        if (this.attackInterval != 20) {
            compoundTag.method_10569(DATA_ATTACK_INTERVAL_TAG, this.attackInterval);
        }
        if (this.attackRadius != 8.0f) {
            compoundTag.method_10548(DATA_ATTACK_RADIUS_TAG, this.attackRadius);
        }
        if (this.interval != 10) {
            compoundTag.method_10569(DATA_INTERVAL_TAG, this.interval);
        }
        if (!this.mustSeeTarget) {
            compoundTag.method_10556(DATA_MUST_SEE_TARGET_TAG, false);
        }
        if (!this.mustReachTarget) {
            compoundTag.method_10556(DATA_MUST_REACH_TARGET_TAG, false);
        }
        if (this.probability != 1.0f) {
            compoundTag.method_10548(DATA_PROBABILITY_TAG, this.probability);
        }
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }

    public String toString() {
        return "ObjectiveData [id=" + this.id + ", type=" + this.objectiveType + ", priority=" + this.priority + ", targetPlayerName=" + this.targetPlayerName + ", targetEntityUUID=" + this.targetEntityUUID + ", targetOwnerUUID=" + this.targetOwnerUUID + ", isRegistered=" + this.isRegistered + ", speedModifier=" + this.speedModifier + ", startDistance=" + this.startDistance + ", stopDistance=" + this.stopDistance + ", onlyAtNight=" + this.onlyAtNight + ", distanceToPoi=" + this.distanceToPoi + ", canDealWithDoors=" + this.canDealWithDoors + ", lookDistance=" + this.lookDistance + ", attackInterval=" + this.attackInterval + ", attackRadius=" + this.attackRadius + ", interval=" + this.interval + ", mustSeeTarget=" + this.mustSeeTarget + ", probability=" + this.probability + "]";
    }
}

