/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.synched.SynchedEntityData;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.InteractionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.VisibilityHandler;
import de.markusbordihn.easynpc.server.player.FakePlayer;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1355;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1811;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCBaseEntity<E extends class_1314>
extends class_1314
implements EasyNPCBase<E> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final EnumMap<SynchedDataIndex, class_2940<?>> entityDataAccessorMap = new EnumMap(SynchedDataIndex.class);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private final EnumMap<TickerType, Integer> tickerMap = new EnumMap(TickerType.class);
    protected class_1916 merchantTradingOffers;
    private ServerEntityData serverEntityData;
    private int attackAnimationTick;
    private int npcDataVersion = -1;
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    private SynchedEntityData synchedEntityData;
    private class_1657 tradingPlayer;
    private FakePlayer fakePlayer;

    public EasyNPCBaseEntity(class_1299<? extends class_1314> entityType, class_1937 level, Enum<?> variant) {
        super(entityType, level);
        this.registerEasyNPCDefaultHandler(variant);
        this.method_5684(true);
        this.refreshGroundNavigation();
    }

    @Override
    public FakePlayer getFakePlayer(class_3218 level, class_2338 blockPos) {
        if (FakePlayer.isInvalidFakePlayer(this.fakePlayer)) {
            this.fakePlayer = new FakePlayer(level, blockPos);
            return this.fakePlayer;
        }
        return this.fakePlayer.updatePosition(level, blockPos);
    }

    @Override
    public int getTicker(TickerType tickerType) {
        return this.tickerMap.getOrDefault((Object)tickerType, 0);
    }

    @Override
    public void setTicker(TickerType tickerType, int ticker) {
        this.tickerMap.put(tickerType, ticker);
    }

    public void method_24651() {
        this.field_6278 = 0;
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean method_6121(class_1297 entity) {
        this.attackAnimationTick = 10;
        this.method_37908().method_8421((class_1297)this, (byte)4);
        return super.method_6121(entity);
    }

    public void method_5711(byte flag) {
        super.method_5711(flag);
        if (flag == 4) {
            this.attackAnimationTick = 10;
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_38069()) {
            this.method_6119();
            if (this.attackAnimationTick > 0) {
                --this.attackAnimationTick;
            }
        } else {
            this.method_29510((class_3218)this.method_37908(), true);
        }
    }

    @Override
    public class_1657 method_8257() {
        return this.tradingPlayer;
    }

    @Override
    public void method_8259(class_1657 player) {
        this.tradingPlayer = player;
    }

    public class_2561 method_5477() {
        class_2561 component = this.method_5797();
        return component != null ? TextUtils.removeAction(component) : this.method_23315();
    }

    public boolean method_5643(class_1282 damageSource, float damage) {
        this.handleHurtEvent(damageSource, damage);
        return super.method_5643(damageSource, damage);
    }

    public void method_6078(class_1282 damageSource) {
        this.handleDieEvent(damageSource);
        super.method_6078(damageSource);
    }

    public class_1297 method_5731(class_3218 serverLevel) {
        this.handleChangeDimensionEvent(serverLevel);
        return super.method_5731(serverLevel);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        return InteractionHandler.handleMobInteraction(this, player, hand);
    }

    public boolean method_5767() {
        return VisibilityHandler.handleIsInvisible(this, super.method_5767());
    }

    public boolean method_5756(class_1657 player) {
        return VisibilityHandler.handleIsInvisibleToPlayer(this, player, super.method_5756(player));
    }

    @Override
    public int getNPCDataVersion() {
        return this.npcDataVersion;
    }

    @Override
    public void setNPCDataVersion(int version) {
        this.npcDataVersion = version;
    }

    @Override
    public class_1916 getMerchantTradingOffers() {
        return this.merchantTradingOffers;
    }

    @Override
    public void setMerchantTradingOffers(class_1916 merchantOffers) {
        this.merchantTradingOffers = merchantOffers;
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficulty, class_3730 mobSpawnType, class_1315 spawnGroupData, class_2487 compoundTag) {
        return this.finalizeEasyNPCSpawn(super.method_5943(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag));
    }

    @Override
    public void handleEasyNPCJoin(EasyNPC<?> easyNPC) {
        this.onEasyNPCJoinUpdateObjective(easyNPC);
    }

    @Override
    public void handleEasyNPCLeave(EasyNPC<?> easyNPC) {
        this.onEasyNPCLeaveUpdateObjective(easyNPC);
    }

    @Override
    public void handlePlayerJoin(class_3222 serverPlayer) {
        this.onPlayerJoinUpdateObjective(serverPlayer);
    }

    @Override
    public void handlePlayerLeave(class_3222 serverPlayer) {
        this.onPlayerLeaveUpdateObjective(serverPlayer);
    }

    @Override
    public void handleLivingEntityJoin(class_1309 livingEntity) {
        this.onLivingEntityJoinUpdateObjective(livingEntity);
    }

    @Override
    public void handleLivingEntityLeave(class_1309 livingEntity) {
        this.onLivingEntityLeaveUpdateObjective(livingEntity);
    }

    public boolean method_25938(class_1811 projectileWeaponItem) {
        return AttackHandler.canFireProjectileWeapon(projectileWeaponItem);
    }

    public int method_29507() {
        return this.remainingPersistentAngerTime;
    }

    public void method_29514(int remainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = remainingPersistentAngerTime;
    }

    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    @Override
    public class_1355 getEntityGoalSelector() {
        return this.field_6201;
    }

    @Override
    public class_1355 getEntityTargetSelector() {
        return this.field_6185;
    }

    @Override
    public <T> void defineSynchedEntityData(SynchedDataIndex synchedDataIndex, T defaultData) {
        if (this.synchedEntityData == null) {
            this.synchedEntityData = new SynchedEntityData((class_1297)this, entityDataAccessorMap);
        }
        this.synchedEntityData.define(synchedDataIndex, defaultData);
    }

    @Override
    public <T> void setSynchedEntityData(SynchedDataIndex synchedDataIndex, T data) {
        this.synchedEntityData.set(synchedDataIndex, data);
    }

    @Override
    public <T> T getSynchedEntityData(SynchedDataIndex synchedDataIndex) {
        return this.synchedEntityData.get(synchedDataIndex);
    }

    @Override
    public void defineServerEntityData() {
        this.serverEntityData = new ServerEntityData((class_1297)this);
    }

    @Override
    public ServerEntityData getServerEntityData() {
        if (this.serverEntityData == null) {
            this.defineServerEntityData();
        }
        return this.serverEntityData;
    }

    public boolean method_5931(class_1657 player) {
        class_3222 serverPlayer;
        if (!this.method_5934() && player instanceof class_3222 && ((serverPlayer = (class_3222)player).method_7337() || this.isOwner(serverPlayer))) {
            return true;
        }
        return !this.method_5934() && this.getAttributeDataLoaded() && this.getAttributeCanBeLeashed();
    }

    public boolean method_5732() {
        return this.getAttributeDataLoaded() && this.getAttributeIsAttackable();
    }

    public boolean method_5810() {
        return this.getAttributeDataLoaded() && this.getAttributeIsPushable();
    }

    protected void method_6070() {
        if (this.getAttributeDataLoaded() && this.getAttributePushEntities()) {
            super.method_6070();
        }
    }

    public boolean method_5655() {
        return this.getAttributeDataLoaded() ? !this.getAttributeIsAttackable() : super.method_5655();
    }

    public boolean method_5679(class_1282 damageSource) {
        return this.method_5655() || super.method_5679(damageSource);
    }

    public void method_5966() {
        this.playDefaultAmbientSound();
    }

    public int method_5970() {
        return 240;
    }

    public void method_6013(class_1282 damageSource) {
        this.playDefaultHurtSound(damageSource);
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.playDefaultStepSound(blockPos, blockState);
    }

    public class_3414 method_6002() {
        return this.getDefaultDeathSound();
    }

    protected void method_18379() {
        if (this.getAttributeDataLoaded() && this.getAttributeCanUseNetherPortal()) {
            super.method_18379();
        }
    }

    public boolean method_5974(double distance) {
        return false;
    }

    public void method_5670() {
        super.method_5670();
        if (this.method_38069() || !this.method_5805()) {
            return;
        }
        this.handleCustomObjectiveBaseTick();
        this.handleBaseTick();
    }

    public void method_6091(class_243 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.method_6091(vec3);
        } else {
            this.method_29242(this instanceof class_1432);
        }
    }

    public boolean method_6765() {
        return false;
    }

    public void method_6576(class_3419 soundSource) {
        if (soundSource != null) {
            this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14824, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean method_6725() {
        return false;
    }

    public class_1310 method_6046() {
        return class_1310.field_6290;
    }

    protected void method_5693() {
        super.method_5693();
        this.defineEasyNPCBaseSyncedData();
        this.defineEasyNPCBaseServerSideData();
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.method_29517(compoundTag);
        this.addEasyNPCBaseAdditionalSaveData(compoundTag);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.method_29512(this.method_37908(), compoundTag);
        this.readEasyNPCBaseAdditionalSaveData(compoundTag);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EasyNPCBaseEntity)) {
            return false;
        }
        EasyNPCBaseEntity easyNPCBaseEntity = (EasyNPCBaseEntity)object;
        return Objects.equals(this.method_5667(), easyNPCBaseEntity.method_5667());
    }

    public int hashCode() {
        return Objects.hash(this.method_5667());
    }

    static {
        EasyNPCBase.registerEasyNPCDataSerializers();
        EasyNPCBase.registerEasyNPCSyncedData(entityDataAccessorMap, EasyNPCBaseEntity.class);
    }
}

