/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LivingEntityManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String LOG_PREFIX = "[Living Entity Manager]";
    private static final ConcurrentHashMap<String, class_3222> playerNameMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, EasyNPC<?>> npcEntityMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, class_3222> playerMap = new ConcurrentHashMap();

    private LivingEntityManager() {
    }

    public static void addEasyNPC(EasyNPC<?> easyNPC) {
        UUID uuid = easyNPC.getUUID();
        log.debug("{} [Add] EASY NPC entity {}: {}", (Object)LOG_PREFIX, easyNPC, (Object)uuid);
        npcEntityMap.put(uuid, easyNPC);
        if (easyNPC.method_38069()) {
            return;
        }
        for (EasyNPC<?> easyNPCChild : npcEntityMap.values()) {
            if (easyNPCChild == easyNPC) continue;
            easyNPCChild.handleEasyNPCJoin(easyNPC);
        }
    }

    public static void removeEasyNPC(EasyNPC<?> easyNPC) {
        log.debug("{} [Remove] EASY NPC entity {}: {}", (Object)LOG_PREFIX, easyNPC, (Object)easyNPC.getUUID());
        npcEntityMap.remove(easyNPC.getUUID());
        if (easyNPC.method_38069()) {
            return;
        }
        for (EasyNPC<?> easyNPCChild : npcEntityMap.values()) {
            if (easyNPCChild == easyNPC) continue;
            easyNPCChild.handleEasyNPCLeave(easyNPC);
        }
    }

    public static void addLivingEntity(class_1309 livingEntity) {
        if (log.isTraceEnabled()) {
            log.trace("{} [Add] Living entity {}: {}", (Object)LOG_PREFIX, (Object)livingEntity, (Object)livingEntity.method_5667());
        }
        for (EasyNPC<?> easyNPC : npcEntityMap.values()) {
            easyNPC.handleLivingEntityJoin(livingEntity);
        }
    }

    public static void removeLivingEntity(class_1309 livingEntity) {
        if (log.isTraceEnabled()) {
            log.trace("{} [Remove] Living entity {}: {}", (Object)LOG_PREFIX, (Object)livingEntity, (Object)livingEntity.method_5667());
        }
        for (EasyNPC<?> easyNPC : npcEntityMap.values()) {
            easyNPC.handleLivingEntityLeave(livingEntity);
        }
    }

    public static void addServerPlayer(class_3222 serverPlayer) {
        log.debug("{} [Add] Server player {}: {}", (Object)LOG_PREFIX, (Object)serverPlayer, (Object)serverPlayer.method_5667());
        playerMap.put(serverPlayer.method_5667(), serverPlayer);
        playerNameMap.put(serverPlayer.method_5477().getString(), serverPlayer);
        for (EasyNPC<?> easyNPC : npcEntityMap.values()) {
            easyNPC.handlePlayerJoin(serverPlayer);
        }
    }

    public static void removeServerPlayer(class_3222 serverPlayer) {
        log.debug("{} [Remove] Server player {}: {}", (Object)LOG_PREFIX, (Object)serverPlayer, (Object)serverPlayer.method_5667());
        playerMap.remove(serverPlayer.method_5667());
        playerNameMap.remove(serverPlayer.method_5477().getString());
        for (EasyNPC<?> easyNPC : npcEntityMap.values()) {
            easyNPC.handlePlayerLeave(serverPlayer);
        }
    }

    public static class_1309 getLivingEntityByUUID(UUID uuid, class_3218 serverLevel) {
        if (uuid == null || serverLevel == null) {
            return null;
        }
        class_1297 entity = serverLevel.method_14190(uuid);
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            return livingEntity;
        }
        class_3222 serverPlayer = LivingEntityManager.getPlayerByUUID(uuid, serverLevel);
        if (serverPlayer != null) {
            return serverPlayer;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverLevel);
        return easyNPC != null ? easyNPC.getLivingEntity() : null;
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid, class_3222 serverPlayer) {
        return LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer.method_51469());
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid, class_3218 serverLevel) {
        if (uuid == null || serverLevel == null) {
            return null;
        }
        class_1297 entity = serverLevel.method_14190(uuid);
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return easyNPC;
        }
        return LivingEntityManager.getEasyNPCEntityByUUID(uuid);
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return npcEntityMap.getOrDefault(uuid, null);
    }

    public static class_3222 getPlayerByUUID(UUID uuid, class_3218 serverLevel) {
        if (uuid == null || serverLevel == null) {
            return null;
        }
        class_1657 player = serverLevel.method_18470(uuid);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            return serverPlayer;
        }
        return playerMap.getOrDefault(uuid, null);
    }

    public static class_3222 getPlayerByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return playerNameMap.getOrDefault(name, null);
    }

    public static Stream<String> getUUIDStrings() {
        return npcEntityMap.keySet().stream().map(UUID::toString);
    }

    public static Stream<String> getUUIDStringsByOwner(class_3222 serverPlayer) {
        Map<UUID, class_1297> npcEntityMapByOwner = LivingEntityManager.getEntityMapByOwner(serverPlayer);
        return npcEntityMapByOwner != null ? npcEntityMapByOwner.keySet().stream().map(UUID::toString) : Stream.empty();
    }

    public static Map<UUID, class_1297> getEntityMapByOwner(class_3222 serverPlayer) {
        return serverPlayer != null ? LivingEntityManager.getEntityMapByOwner(serverPlayer.method_5667()) : null;
    }

    public static Map<UUID, class_1297> getEntityMapByOwner(UUID ownerUUID) {
        HashMap<UUID, class_1297> result = new HashMap<UUID, class_1297>();
        for (Map.Entry<UUID, EasyNPC<?>> entry : npcEntityMap.entrySet()) {
            OwnerData ownerData;
            EasyNPC<?> easyNPC = entry.getValue();
            if (!(easyNPC instanceof OwnerData) || !(ownerData = (OwnerData)easyNPC).isOwner(ownerUUID)) continue;
            result.put(entry.getKey(), easyNPC.getEntity());
        }
        return result;
    }

    public static boolean hasAccess(UUID uuid, class_3222 serverPlayer) {
        if (uuid == null || serverPlayer == null) {
            return false;
        }
        return LivingEntityManager.hasAccess(serverPlayer.method_51469().method_14190(uuid), serverPlayer);
    }

    public static boolean hasAccess(class_1297 entity, class_3222 serverPlayer) {
        EasyNPC easyNPC;
        if (serverPlayer.method_7337()) {
            return true;
        }
        if (entity instanceof EasyNPC && (easyNPC = (EasyNPC)entity) instanceof OwnerData) {
            OwnerData ownerData = (OwnerData)easyNPC;
            UUID uuid = ownerData.method_6139();
            return uuid != null && uuid.equals(serverPlayer.method_5667());
        }
        return false;
    }

    public static void discardEasyNPCEntityByUUID(UUID uuid, class_3218 serverLevel) {
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverLevel);
        if (easyNPC != null && easyNPC.getMob() != null) {
            easyNPC.getMob().method_31472();
            npcEntityMap.remove(uuid);
        } else {
            log.warn("{} [Discard] Unable to discard EASY NPC entity {}: {}", (Object)LOG_PREFIX, easyNPC, (Object)uuid);
        }
    }
}

