/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import java.util.EnumMap;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1409;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;

public interface NavigationData<T extends class_1314>
extends EasyNPC<T> {
    public static final String DATA_HOME_TAG = "Home";
    public static final String DATA_NAVIGATION_TAG = "Navigation";
    public static final int TRAVEL_EVENT_TICK = 20;

    public static void registerSyncedNavigationData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Navigation Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.NAVIGATION_HOME_POSITION, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13324));
    }

    default public class_2338 getHomePosition() {
        return (class_2338)this.getSynchedEntityData(SynchedDataIndex.NAVIGATION_HOME_POSITION);
    }

    default public void setHomePosition(class_2338 blockPos) {
        this.setSynchedEntityData(SynchedDataIndex.NAVIGATION_HOME_POSITION, blockPos);
    }

    default public boolean hasHomePosition() {
        return this.getHomePosition() != null && !this.getHomePosition().equals((Object)class_2338.field_10980);
    }

    default public void setPosition(class_243 pos) {
        this.getLivingEntity().method_33574(pos);
        this.getLivingEntity().method_29495(pos);
    }

    default public void refreshGroundNavigation() {
        class_1409 groundPathNavigation = this.getGroundPathNavigation();
        if (groundPathNavigation != null) {
            AttributeData attributeData = this.getEasyNPCAttributeData();
            if (attributeData != null && attributeData.getAttributeDataLoaded()) {
                groundPathNavigation.method_6363(attributeData.getAttributeCanOpenDoor());
                groundPathNavigation.method_35139(attributeData.getAttributeCanPassDoor());
                groundPathNavigation.method_6354(attributeData.getAttributeCanFloat());
            } else {
                groundPathNavigation.method_6363(true);
                groundPathNavigation.method_35139(true);
                groundPathNavigation.method_6354(true);
            }
        }
    }

    default public class_1409 getGroundPathNavigation() {
        class_1308 mob;
        NavigationData navigationData = this;
        if (navigationData instanceof class_1308 && (navigationData = (mob = (class_1308)navigationData).method_5942()) instanceof class_1409) {
            class_1409 groundPathNavigation = (class_1409)navigationData;
            return groundPathNavigation;
        }
        return null;
    }

    default public void defineSynchedNavigationData() {
        this.defineSynchedEntityData(SynchedDataIndex.NAVIGATION_HOME_POSITION, class_2338.field_10980);
    }

    default public boolean canFly() {
        return false;
    }

    default public boolean isFlying() {
        return this.canFly() && !this.getEntity().method_24828();
    }

    default public void addAdditionalNavigationData(class_2487 compoundTag) {
        class_2487 navigationTag = new class_2487();
        if (this.hasHomePosition()) {
            navigationTag.method_10566(DATA_HOME_TAG, (class_2520)class_2512.method_10692((class_2338)this.getHomePosition()));
        }
        compoundTag.method_10566(DATA_NAVIGATION_TAG, (class_2520)navigationTag);
    }

    default public void readAdditionalNavigationData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_NAVIGATION_TAG)) {
            return;
        }
        class_2487 navigationTag = compoundTag.method_10562(DATA_NAVIGATION_TAG);
        if (navigationTag.method_10545(DATA_HOME_TAG)) {
            this.setHomePosition(class_2512.method_10691((class_2487)navigationTag.method_10562(DATA_HOME_TAG)));
        }
    }

    default public void handleNavigationTravelEvent(class_243 vec3) {
        TickerData tickerData = this.getEasyNPCTickerData();
        if (tickerData.checkAndIncreaseTicker(TickerType.TRAVEL_EVENT, 20)) {
            class_1308 mob = this.getMob();
            class_1937 level = this.getLevel();
            class_2680 blockState = level.method_8320(mob.method_23312());
            mob.method_24830(!blockState.method_27852(class_2246.field_10124) && !blockState.method_27852(class_2246.field_10479) && !blockState.method_27852(class_2246.field_10466) && !blockState.method_27852(class_2246.field_10536));
            ObjectiveData objectiveData = this.getEasyNPCObjectiveData();
            AttributeData attributeData = this.getEasyNPCAttributeData();
            if (!objectiveData.hasTravelTargetObjectives() && attributeData.getAttributeDataLoaded() && attributeData.getAttributeFreefall() && !mob.method_24828()) {
                mob.method_5814(mob.method_23317(), Math.floor(mob.method_23318() - 0.1), mob.method_23321());
            }
            tickerData.resetTicker(TickerType.TRAVEL_EVENT);
        }
    }
}

